<?php
/* -------------------------------------------------------------
 * apps.conf / applications configuration
 * 
 * アプリケーション共通設定
 * 
 * ---------------------------------------------------------- */

/**
 * 開発環境フラグ
 */

define('APP_ENV_PREFIX', 'er_');
if (preg_match('#^/' . APP_ENV_PREFIX. '(dev|stg|demo|ncchd|nec)(_s|_m|_l|_qq)?#', $_SERVER['REQUEST_URI'], $matches)) {
    define('APP_ENV', $matches[1]);
    if (isset($matches[2]) && $matches[2]) {
        define('APP_ENV_SUFFIX', $matches[2]);
    } else {
        define('APP_ENV_SUFFIX', '');
    }
} else {
    exit('[err1:apps.conf] invalid request.');
}

// 16歳以上(内科)の既往(1/2/3)の表示項目の設定
switch (APP_ENV_SUFFIX) {
    case '_s': // クリニック等忙しい外来
        define('ADULT_KIOU_SORT', 'sort1');
        define('ADULT_KIOU_POS',  'pos1');
        break;

    case '_m': // 病院外来（比較的時間あり）
        define('ADULT_KIOU_SORT', 'sort2');
        define('ADULT_KIOU_POS',  'pos2');
        break;

    case '_l': // のんびり診療できるところ
        define('ADULT_KIOU_SORT', 'sort3');
        define('ADULT_KIOU_POS',  'pos3');
        break;

    case '_qq': // 救急
        define('ADULT_KIOU_SORT', 'sort4');
        define('ADULT_KIOU_POS',  'pos4');
        break;

    default: // のんびり診療できるところ
        define('ADULT_KIOU_SORT', 'sort3');
        define('ADULT_KIOU_POS',  'pos3');
        break;
}

define('IS_DEMO', (strpos(getcwd(), '/var/www/er_demo/') === 0));
define('IS_STG',  (strpos(getcwd(), '/var/www/er_stg/') === 0));
define('IS_PROD', (strpos(getcwd(), '/var/www/er_ncchd/') === 0));
define('IS_NEC',  (strpos(getcwd(), '/var/www/er_nec/') === 0));
define('IS_DEV',  (! IS_DEMO && ! IS_STG && ! IS_PROD && ! IS_NEC));

/***************************************************************
 * database の設定
 **************************************************************/
if (IS_DEV || IS_STG) {
    // dev or staging
    define('DB_HOST', 'localhost');
    define('DB_USER', 'monshin');
    define('DB_PASS', 'enKK7co1a2Zv');
    define('DB_NAME', 'monshin_er_dev');
    define('DB_ENCODING', 'utf8');
    define('DB_ERRLOG_DIR', LAMBDA_BASEDIR.'/logs/mysql_error');
}
if (IS_DEMO) {
    // demo
    define('DB_HOST', 'localhost');
    define('DB_USER', 'monshin');
    define('DB_PASS', 'enKK7co1a2Zv');
    define('DB_NAME', 'monshin_er_demo');
    define('DB_ENCODING', 'utf8');
    define('DB_ERRLOG_DIR', LAMBDA_BASEDIR.'/logs/mysql_error');
}
if (IS_PROD) {
    // prod
    define('DB_HOST', 'localhost');
    define('DB_USER', 'monshin');
    define('DB_PASS', 'enKK7co1a2Zv');
    define('DB_NAME', 'monshin_er_ncchd');
    define('DB_ENCODING', 'utf8');
    define('DB_ERRLOG_DIR', LAMBDA_BASEDIR.'/logs/mysql_error');
}
//if (IS_NEC) {
//    // prod
//    define('DB_HOST', 'localhost');
//    define('DB_USER', 'monshin');
//    define('DB_PASS', 'enKK7co1a2Zv');
//    define('DB_NAME', 'monshin_er_nec');
//    define('DB_ENCODING', 'utf8');
//    define('DB_ERRLOG_DIR', LAMBDA_BASEDIR.'/logs/mysql_error');
//}

/**
 * 仮診察券番号のプレフィクス
 */
define('NONMEMBER_CARDNUMBER_PREFIX', 'DEMO');

/**
 * 救急入力の診察券番号のプレフィクス
 */
define('QQ_CARDNUMBER_PREFIX', 'QQ');

/**
 * 16歳以上(内科)の既往(1/2/3)の表示項目の設定
 *  
 *  下記の施設から一つ選び、その他をコメントアウトします。
 *  
 *  1) クリニック等忙しい外来
 *  2) 病院外来（比較的時間あり）
 *  3) のんびり診療できるところ
 *  4) 救急
 *  
 */
// デフォルト
//if ( ! defined('ADULT_KIOU_SORT')) define('ADULT_KIOU_SORT', 'sort3');
//if ( ! defined('ADULT_KIOU_POS')) define('ADULT_KIOU_POS',  'pos3');

/* クリニック等忙しい外来     */
//define('ADULT_KIOU_SORT', 'sort1');
//define('ADULT_KIOU_POS',  'pos1');

/* 病院外来（比較的時間あり） */
//define('ADULT_KIOU_SORT', 'sort2');
//define('ADULT_KIOU_POS',  'pos2');

/* のんびり診療できるところ   */
//define('ADULT_KIOU_SORT', 'sort3');
//define('ADULT_KIOU_POS',  'pos3');

/* 救急                       */
//define('ADULT_KIOU_SORT', 'sort4');
//define('ADULT_KIOU_POS',  'pos4');


