<?php
$keyword = $lmd->httpGet('keyword');
$resolved = (int)$lmd->httpGet('resolved');
$lmd->setResponse(array(
    'charset' => ini_get('default_charset') ? ini_get('default_charset') : 'utf-8',
    'title' => $lmd->param('title'),

    'card_number' => $lmd->param('card_number'),
));

$meta = '';
foreach ($lmd->param('meta', array()) as $v) {
    $meta .= $v."\n";
}

$link = '';
foreach ($lmd->param('link', array()) as $v) {
    $link .= $v."\n";
}

$script = '';
foreach ($lmd->param('script', array()) as $v) {
    $script .= $v."\n";
}

$lmd->setResponse(array(
    'meta'  => $meta,
    'link'  => $link,
    'script' => $script,
), Lambda::INSANITATION);



$dao = Factory::load('DB/DAO_answers')->getInstance();
$answer_date = array();
foreach ($dao->fetchAll_answer_date() as $v) {
    $key = str_replace('-', '', $v['answer_date']);
    $answer_date[$key] = str_replace('-', '/', $v['answer_date']);
}

$buf = $dao->fetchNewest_BY_answer_code($_answer_code);
$answer_id = isset($buf['answer_id']) ? $buf['answer_id'] : '';

// 外来カルテ取得...
if (! $lmd->isMainModule('doctor.top')) {
    $dao   = Factory::load('DB/DAO_outpatient_carte')->getInstance();
    $cartes = $dao->fetchAll_BY_answer_code($_answer_code);
    $carte = $cartes ? $cartes[0] : array('data' => '');
    list($severity_level, $risk_level) = getSeverityAndRiskByHead($buf['age'], $buf['answer_id']);
    $vital_sign = Factory::load('DB/DAO_vital_sign')->getInstance()->fetch_BY_answer_code($buf["answer_code"]);
    $has_carte = !empty($cartes) || (isset($vital_sign['assessment_flag']) && preg_match('/^[123]$/', $vital_sign['assessment_flag'])) ? TRUE : FALSE;
    $severity_color = Severity::getBackgroundColor($severity_level, $has_carte);
    list($history_original, $medical_history) = getMedicalHistory($_answer_code);
} else {
    // ドクター側TOPの場合は、空のまま...
    $medical_history = $history_original = $severity_color = $risk_level = $carte = array();
}

$user = Factory::load('DB/DAO_doctors')->getInstance()->fetch_BY_username(DocCookie::getUserName());




$lmd->setResponse(array(
    'resolved'=>$resolved,
    'keyword' =>$keyword,
    'risk_level' => $risk_level,
    'severity_color' => $severity_color,
    'history_original' => $history_original,
    'history' =>$medical_history,
    'user' => $user,
    'age_div_u15' => in_array('u15', $_age_div),
    'age_div_o16' => in_array('o16', $_age_div),

    'diagnosis_done' => in_array('done', $_diagnosis),
    'diagnosis_yet'  => in_array('yet', $_diagnosis),

    'severity_l'  => in_array(Severity::LEVEL_LOW, $_severity),
    'severity_m'  => in_array(Severity::LEVEL_MIDDLE, $_severity),
    'severity_h'  => in_array(Severity::LEVEL_HIGH, $_severity),
    'severity_sh' => in_array(Severity::LEVEL_SUPERHIGH, $_severity),

    'sort' => $_sort, 

    'answer_id' => $answer_id, 

    'ymd'  => $_ymd,
    'answer_date' => $answer_date,
    'answer_date_json' => array_values($answer_date),
    'ans' => $buf,
    'carte' => $carte, 
    //'carte_data' => json_decode(isset($carte['data']) ? $carte['data'] : '', TRUE),

    'vital' => Factory::load('DB/DAO_vital_sign')->getInstance()->fetch_BY_answer_code($_answer_code),
));



function getSeverityAndRiskByHead($age, $answer_id)
{
    $mode = _isChild($age) ? Severity::CHILD : Severity::ADULT;
    $isRoleDoctor = _isRoleDoctor();

    $severity = Factory::load('App/Severity')->getInstance($mode);
    $severity->judge($answer_id, $severity, $isRoleDoctor);
    $severity_level = $severity->getSeverityLevel();
    $risk_level     = $severity->getRiskLevel();

    return array($severity_level, $risk_level);
}



/**
 * 受診歴
 */
function getMedicalHistory($_answer_code)
{
    list($card_number, ) = explode('-', $_answer_code);

    $dao = Factory::load('DB/DAO_answers')->getInstance();
    $res = $dao->fetchAll_LEFT_JOIN_severitys_LEFT_JOIN_outpatient_carte_BY_card_number($card_number);

    $buf = array();
    foreach ($res as $v) {
        if ( ! isset($buf[$v['answer_code']])) {
            $buf[$v['answer_code']] = $v;
        } elseif ($v['version'] > $buf[$v['answer_code']]['version']) {
            $buf[$v['answer_code']] = $v;
        }
    }

    $first = $history = array();
    krsort($buf);
    $first = array_pop($buf);
    $history = $buf;
    array_unshift($history, $first);

    foreach ($history as $k => $v) {
        list($severity_level, $risk_level) = getSeverityAndRiskByHead($v['age'], $v['answer_id']);
        $history[$k]['severity_level'] = $severity_level;
        $history[$k]['risk_level']     = $risk_level;
        // 外来カルテ保存されているか、またはアセスメント[帰宅/処置検査後診察/入院]が指定されていれば、処理済み背景色とする
        $has_carte = $v['has_carte'] || (isset($v['assessment_flag']) && preg_match('/^[123]$/', $v['assessment_flag'])) ? TRUE : FALSE;
        $history[$k]['severity_color'] = Severity::getBackgroundColor($severity_level, $has_carte);
    }

    return array($buf, $history);

}