<?php
    $lmd->invokeModule('common.head.normal', array(
        'title' => SITE_NAME,
        'script' => array(
                    '',
                    ),
        'link' => array(
                    '',
                    ),
    ));
?>

<!-- <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet"> -->

<style type="text/css">

body {width: 75rem; margin: 0 auto;}
.border-custom { border: 2px solid #002060;}
.w-12{width:12rem }

/* 土曜日：青 */
.flatpickr-day.saturday {
    color: #0d6efd !important;
}
/* 日曜日：赤 */
.flatpickr-day.sunday {
    color: #dc3545 !important;
}
/* 禁止された日付 */
.flatpickr-day.bad-date {
    background-color: #e9ecef !important;
    color: #999 !important;
    cursor: not-allowed;
}
/* 曜日ヘッダー */
.flatpickr-weekdays .flatpickr-weekday:nth-child(1) {
    color: #dc3545 !important;
    /* 日曜日 → 赤 */
}

.flatpickr-weekdays .flatpickr-weekday:nth-child(7) {
    color: #0d6efd !important;
    /* 土曜日 → 青 */
}
.nlh{
    height: 37.6px; line-height:37.6px
}


table.custom-bordered-table,table.tabs-m-c-table{
  width: 100%;
  border-collapse: separate;
  border-spacing: 0.2rem;
  background-color: white;
}

table.custom-bordered-table td{
  border: 2px solid #002060; 
  padding: 0.2rem; 
  text-align: center;
}

table.custom-bordered-table th{
  padding: 0.4rem;
  text-align: center;
  background-color: #002060; color: #FFF;
}

table.tabs-m-c-table td{vertical-align: top;text-align: left; padding: 0;}
.dt-nav a {
  color: var(--primary-color);
  text-decoration: none;
  display: block;
  font-weight: 500;
  padding: 12px 0;
  background: var(--light-bg);
  border: none;
  text-align: center;
  font-size: 14px;
  transition: background-color 0.3s;
}
.dt-nav a:hover {
  background: #e4e9f2;
}
.dt-nav .active {background:#d2d8e9;}
.w-59 { width: 5.9rem;}
.w-118 { width: 7.8rem;}
.btn-primary{background: #3498db;}
.btn-primary:hover {background-color: #2980b9;}
.resolved input, .resolved label { cursor: pointer; color: rgb(0, 0, 0);font-weight: normal;}
</style>
 
<div style="padding: 0.2rem;">
<div class="clearfix  rounded" style="border: 2px solid #002060;padding: .5rem !important;margin: .5rem !important;">
    <div class="float-start  pe-0 mt-3">
        <div class="container">
            <div class="row mb-3">
                <div class="col-md-6 w-12 nlh">
                    <?=SITE_NAME?>
                </div>
                <div class="col-md-6 w-12 nlh">
                    <div>
                        新生児一覧
                    </div>
                </div>
            </div>
            <div class="row mb-3">
                <div class="col-md-6 w-12 nlh">
                    <div class="d-inline">専門医：<?=$user['name']?></div>
                </div>
                <div class="col-md-6 w-12">
   
                </div>
            </div>
        </div>
    </div>
    <div class="float-end">
        <div class="clearfix ">
            <div class="float-start clearfix border-custom rounded">
                <div class="float-start  mt-3">
                    <div class="container">
                        <div class="row mb-3 align-items-center">
                            <div class="col-md-3" style="width:8rem">
                                日付
                            </div>
                            <div class="col-md-4" style="width:10.8rem">
                                <div class="input-group">
                                <input id="datepicker" value="<?=date("Y/m/d", strtotime($ymd))?>" type="text" class="form-control" placeholder="年/月/日" aria-label="年/月/日" aria-describedby="basic-addon2">
                                <span class="input-group-text" id="basic-addon2"><i class="bi bi-calendar"></i></span>
                                </div> 
                            </div>
                            <div class="col-md-5" style="width:7.2rem">
                                <div class="resolved">
                                <label class="form-check-label" for="resolved">
                                    入力なし
                                </label>
                                <input class="form-check-input" type="checkbox" value="" id="resolved" <?=$resolved? 'checked':''?>>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3 align-items-center">
                            <div class="col-md-3" style="width:8rem">
                                フリーワード
                            </div>
                            <div class="col-md-9" style="width:17.7rem">
                                <div class="input-group">
                                    <input id="keyword" type="text" class="form-control" placeholder="検索キーワードを入力" value="<?=$keyword?>">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="float-start d-flex justify-content-center align-items-center mt-3" style="height:93px;width: 4rem;">
                    <div class="container">
                        <button id="search" class="btn btn-primary w-100 text-vertical px-1 py-3" type="button">検索</button>
                    </div>
                </div>
            </div>
            <div class="float-end mt-3 ms-3">
                <div class="containe container">
                    <div class="row align-items-center mb-3" style="height: 37.6px;">
                        <div class="col-md-12 text-center">
                            更新：
                            <?php
                                echo date("m-d H:i:s");
                            ?>
                        </div>
                    </div>
                    <div class="row  align-items-center mb-3" style="height: 37.6px;">
                        <div class="col-md-12">
                            <button onclick="logout()" type="button" class="btn btn-secondary">ログアウト</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>



<?php if( ! $lmd->isMainModule('doctor.top') && ! $lmd->isMainModule('doctor_tab.history')): ?>
<div class="ps-2 pe-2">
  <table class="custom-bordered-table">
    <thead>
      <tr>
        <th>患者ID</th>
        <th>性別</th>
        <th>Age</th>
        <th><div >体重</div><div>（前回）</div></th>
        <th>症状</th>
        <th>経過</th>
        <th>病名</th>
        <th>コメント</th>
      </tr>
    </thead>
    <tbody>

      <tr style="background-color:<?=$severity_color?>">
        <td><?=$ans['card_number'] ?></td>
        <td><?php echo $ans['gender_div_id'] == 1 ? '男' : '女' ?></td>
        <td><?php echo _getAgeNotation($ans['life_days']) ?></td>
        <td>
            <?php echo $ans['weight'] ?>kg<br>
            （<?php 
                $keys = array_keys($history_original);
                $index = array_search($ans['answer_code'], $keys);
                if ($index !== false && isset($keys[$index + 1])) {
                $nextKey = $keys[$index + 1];
                echo  $history_original[$nextKey]["weight"] . "kg";
                } else {
                echo "-";
                } 
            ?>）
        </td>
        <td>
            <?php
            // 小児科(16歳未満)
            $dis_child = Factory::load('DB/DAO_CarteDisRelationTable01')->getInstance();
            // 内科(16歳以上)
            $dis_adult = Factory::load('DB/DAO_INT_CarteDisRelationTable01')->getInstance();
            echo $ans['primaryShojo'];
            $list = explode(',', $ans['step3_answers']);
            foreach ($list as $val) {
                if ($val === '') { continue; }
                    $disease_id = $val;
                    $obj = _isChild($ans['age']) ? $dis_child : $dis_adult;
                    $data = $obj->fetch_BY_CategoryID_AND_DiseaseID($ans['shojo_category_id'], $disease_id);
                if ($ans['primaryShojo'] != $data['DiseaseName']) {
                    echo "、".LMDString::rh($data['DiseaseName']);
                }
            }
            ?>
        </td>
        <td>
          <div class="d-flex justify-content-center">
            <div style="width: 2rem;">
              <?php if (Severity::getRiskText($risk_level) == Severity::LABEL_RISK_HIGH): ?>
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" class="size-5">
                  <path fill-rule="evenodd" d="M5.22 14.78a.75.75 0 0 0 1.06 0l7.22-7.22v5.69a.75.75 0 0 0 1.5 0v-7.5a.75.75 0 0 0-.75-.75h-7.5a.75.75 0 0 0 0 1.5h5.69l-7.22 7.22a.75.75 0 0 0 0 1.06Z" clip-rule="evenodd" />
                </svg>
              <?php elseif (Severity::getRiskText($risk_level) == Severity::LABEL_RISK_MIDDLE): ?>
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" class="size-5">
                  <path fill-rule="evenodd" d="M3 10a.75.75 0 0 1 .75-.75h10.638L10.23 5.29a.75.75 0 1 1 1.04-1.08l5.5 5.25a.75.75 0 0 1 0 1.08l-5.5 5.25a.75.75 0 1 1-1.04-1.08l4.158-3.96H3.75A.75.75 0 0 1 3 10Z" clip-rule="evenodd" />
                </svg>
              <?php elseif (Severity::getRiskText($risk_level) == Severity::LABEL_RISK_LOW): ?>
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" class="size-5">
                  <path d="M6.28 5.22a.75.75 0 0 0-1.06 1.06l7.22 7.22H6.75a.75.75 0 0 0 0 1.5h7.5a.747.747 0 0 0 .75-.75v-7.5a.75.75 0 0 0-1.5 0v5.69L6.28 5.22Z" />
                </svg>
              <?php endif; ?>
            </div>
          </div>
        </td>
        <td><?=$carte['diagnosis'] ?? ''?></td>
        <td><?=$carte['outcome'] ?? ''?></td>
      </tr>
    </tbody>
  </table>
</div>
<?php endif; ?>


<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script>
const allowedDates = <?php echo json_encode($answer_date_json); ?>;
flatpickr("#datepicker", {
    dateFormat: "Y/m/d",
    enable: allowedDates,  // ← ここに許可日だけ入れる
    locale: {
        firstDayOfWeek: 0,
        weekdays: {
            shorthand: ['日', '月', '火', '水', '木', '金', '土'],
            longhand: ['日曜日', '月曜日', '火曜日', '水曜日', '木曜日', '金曜日', '土曜日'],
        },
        months: {
            shorthand: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月', '9月', '10月', '11月', '12月'],
            longhand: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月', '9月', '10月', '11月', '12月'],
        },
    },
    onDayCreate: function (dObj, dStr, fp, dayElem) {
        const date = dayElem.dateObj;
        const day = date.getDay();

        if (day === 0) {
            dayElem.classList.add("sunday");
        } else if (day === 6) {
            dayElem.classList.add("saturday");
        }

        const y = date.getFullYear();
        const m = ("0" + (date.getMonth() + 1)).slice(-2);
        const d = ("0" + date.getDate()).slice(-2);
        const dateStr = `${y}/${m}/${d}`;

        // enableに指定された日付以外は選択不可なので、bad-date クラスは不要ですが、
        // 選択不可の日付にグレーのスタイルをつけたい場合はこの条件を使えます。
        if (!allowedDates.includes(dateStr)) {
            dayElem.classList.add("bad-date");
        }
    }
});

$(function() {
    $("#search").click(function() {
        const selectedDate = $("#datepicker").val().replace(/\//g, "");
        const keyword = $("#keyword").val();
        window.location.href =   "<?php echo APP_ROOT ?>/doctor/top?ymd=" +selectedDate + '&keyword=' + keyword + '&resolved=' + ($('#resolved').is(':checked') ? 1 : 0);
    });
});
</script>