<?php

$dao = Factory::load(_isChild() ? 'DB/DAO_kiou_child' : 'DB/DAO_kiou_adult')->getInstance();
$Res = $dao->fetch_BY_answer_code($_answer_code);
$kiou = LMDString::rh($Res);
$q17_disease    = (isset($Res['q17_disease']) && $Res['q17_disease']) ? unserialize($Res['q17_disease']) : array();
$q17_other_text = (isset($Res['q17_other_text']) && $Res['q17_other_text']) ? unserialize($Res['q17_other_text']) : '';

function convWarekiDate($timestamp, $date_flag = true)
{
    $epoch = strtotime($timestamp);
    $j = date('j', $epoch);
    $n = date('n', $epoch);
    $yyyy = date('Y', $epoch);

    $y = (int)$yyyy;
    if (1926 <= $y && $y <= 1988) {
        $wareki = 'S'. ($y - 1925);
    } elseif (1989 <= $y) {
        $wareki = 'H'. ($y - 1988);
    } else {
        $wareki = '';
    }

    if ($date_flag) {
        return sprintf('%s.%d.%d', $wareki, $n, $j);
    } else {
        return sprintf('%s.%d', $wareki, $n);
    }
}
?>

<style type="text/css">
.left-side .left-side-item .left-side-item-con{ background-color: #B4C7E7; color: #25292F}
.w-11 { width: 11rem; }
.b-s-2 { border: 2px solid #002060; }
.b-c-1 {background-color: #002060; color: #FFF; font-weight:normal;}
.font-12 { font-size: 12px;}
</style>


<div class="left-side text-center w-11">

    <div class="left-side-item">
        <h5 class="p-2 m-0 left-side-item-title b-c-1"
            data-bs-toggle="collapse" 
            data-bs-target="#item5-content"
            role="button">受診歴</h5>
        <div class="left-side-item-con b-s-2 collapse show" id="item5-content">
        <ul class="list-unstyled m-0 p-0">
                <li class="p-1" style="background-color:<?php echo $first['severity_color'] ?>">
                    <a class="text-reset text-decoration-none" href="<?php echo APP_ROOT ?>/doctor_tab/exa?answer_code=<?php echo $first['answer_code'] ?>">
                    <span class="font-12">初診</span>
                    <span class="font-12"><?php echo date('Y/m/d H:i', strtotime($first['timestamp'])); ?></span>
                    <span class="font-12"><?php echo(Severity::getSeverityText($first['severity_level'])); ?></span>
                    </a>
                </li>
            <?php $loop = 1; if($res): foreach($res as $v): if($loop > 5) break; ?>
                <li class="p-1" style="background-color:<?php echo $v['severity_color'] ?>">
                    <a class="text-reset text-decoration-none" href="<?php echo APP_ROOT ?>/doctor_tab/exa?answer_code=<?php echo $v['answer_code'] ?>">
                    <span class="font-12"></span>
                    <span class="font-12"><?php echo date('Y/m/d H:i', strtotime($v['timestamp'])); ?></span>
                    <span class="font-12"><?php echo(Severity::getSeverityText($v['severity_level'])); ?></span>
                    </a>
                </li>
            <?php ++$loop; endforeach; endif; ?>
        </ul>
        </div>
    </div>


    <div class="left-side-item">
        <h5 class="p-2 m-0 left-side-item-title b-c-1"
            data-bs-toggle="collapse" 
            data-bs-target="#item4-content"
            role="button">既往歴</h5>
        <div class="left-side-item-con b-s-2 collapse" id="item4-content">
            <div class="p-3">
                <?php if(_isChild()): ?>
                    <?php if($q17_disease): foreach($q17_disease as $v): if((int)$v['value'] === 200) continue; /* 200:その他 */ ?>
                            <?php if($v['y'] && $v['m']): ?>
                                <div id="lm_value_s"><?php echo convWarekiDate(date('Ymd', strtotime("{$v['y']}/{$v['m']}/1")), false) ?></div>
                            <?php endif; ?>
                            <div id="lm_value_s"><?php echo Resource::get('kiou_disease', $v['value'], '') ?></div>
                    <?php endforeach; endif; ?>
                    <?php if($q17_other_text): $v = $q17_other_text; ?>
                            <?php if($v['y'] && $v['m']): ?>
                                <div id="lm_value_s"><?php echo convWarekiDate(date('Ymd', strtotime("{$v['y']}/{$v['m']}/1")), false) ?></div>
                            <?php endif; ?>
                            <div id="lm_value_s"><?php echo $v['text'] ?></div>
                    <?php endif; ?>
                <?php else: ?>
                    <?php if($kiou['diseases']): foreach(explode("\t", $kiou['diseases']) as $v): ?>
                            <div id="lm_value_s"><?php echo $v ?></div>
                    <?php endforeach; endif; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="left-side-item">
        <h5 class="p-2 m-0 left-side-item-title b-c-1" 
            data-bs-toggle="collapse" 
            data-bs-target="#item6-content"
            role="button">入院歴</h5>
        <div class="left-side-item-con b-s-2 collapse" id="item6-content">
            <div class="p-3">

            </div>
        </div>
    </div>



    <div class="left-side-item">
        <h5 class="p-2 m-0 left-side-item-title b-c-1"
            data-bs-toggle="collapse" 
            data-bs-target="#item7-content"
            role="button">処方歴</h5>
        <div class="left-side-item-con b-s-2 collapse" id="item7-content">
            <div class="p-3">

            </div>
        </div>
    </div>

    <?php if(_isChild()): ?>
    <div class="left-side-item">
        <h5 class="p-2 m-0 left-side-item-title b-c-1"
            data-bs-toggle="collapse" 
            data-bs-target="#item8-content"
            role="button">予防接種歴</h5>
        <div class="left-side-item-con b-s-2 collapse" id="item8-content">
            <div class="p-3">
                <div id="lm_value_s">
                <?php 
                    $answers = array();
                    if ($kiou['q5']) foreach (explode(',', $kiou['q5']) as $v) {
                        if ($ret = Resource::get('child.yobou', $v)) {
                            if ($ret !== 'その他') $answers[] = Resource::get('child.yobou', $v);
                        }
                    }
                    if ($kiou['q5_other_text'] !== '') $answers[] = $kiou['q5_other_text'];
                    echo implode('、', $answers);
                ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <div class="left-side-item">
        <h5 class="p-2 m-0 left-side-item-title b-c-1"
            data-bs-toggle="collapse" 
            data-bs-target="#item2-content"
            role="button">健診歴</h5>
        <div class="left-side-item-con b-s-2 collapse" id="item2-content">
            <div class="p-3">

            </div>
        </div>
    </div>



</div>


