<style>
table.custom-bordered-table {
  width: 100%;
  border-collapse: separate;
  border-spacing: 0.2rem;
  background-color: white;
}

table.custom-bordered-table td , .toast{
  border: 2px solid #002060; 
  padding: 0.2rem; 
  text-align: center;
}
table.custom-bordered-table th{
  padding: 0.4rem;
  text-align: center;
  background-color: #002060; color: #FFF;
}

.data-toast { display: none; }
.custom-toast-shadow {
  box-shadow: -10px -12px 16px rgba(0, 0, 0, 0.8);
  animation: none !important;
  transition: none !important;
}
</style>

<div class="ps-2 pe-2">
  <table class="custom-bordered-table">
    <thead>
      <tr>
        <th>患者ID</th>
        <th>性別</th>
        <th>Age</th>
        <th><div>体重</div><div>（前回）</div></th>
        <th>症状</th>
        <th>経過</th>
        <th>病名</th>
        <th>コメント</th>
      </tr>
    </thead>
    <tbody>
    <?php if($res): foreach($res as $idx => $v): ?>
      <tr data-href="<?php echo APP_ROOT ?>/doctor_tab/outpatient_carte?answer_code=<?=$v['answer_code']?>&keyword=<?=$keyword?>&ymd=<?=$ymd?>&resolved=<?=$resolved?>" style="<?php echo ($_answer_code && $v['answer_code'] == $_answer_code) ? 'color: #ff0000;' : '' ?> background-color:<?php echo $v['severity_color'] ?>">
        <td><?php echo $v['card_number'] ?></td>
        <td><?php echo Resource::get('gender', $v['gender_div_id'], '-') ?></td>
        <td><?php echo $v['age'] ?> 歳</td>
        <td>
            <?php echo $v['weight'] ?>kg
          <br>
          （
            <?php 
                $keys = array_keys($weightHistory[$v['card_number']]);
                $index = array_search($v['answer_code'], $keys);
                if ($index !== false && isset($keys[$index + 1])) {
                  $nextKey = $keys[$index + 1];
                  echo  $weightHistory[$v['card_number']][$nextKey]["weight"] . "kg";
                } else {
                  echo "-";
                } 
            ?>
            ）
        </td>
        <td class="shojo <?=count(explode(',', $v['step3_answers'])) >1 ? "toast_show" : ""?>">
            <?=$v['primaryShojo']?>
            <?=count(explode(',', $v['step3_answers'])) >1 ? "..." : ""?>
            <div class="data-toast">
            <?php
            echo $v['primaryShojo'];
            $list = explode(',', $v['step3_answers']);
            foreach ($list as $val) {
                if ($val === '') { continue; }
                    $disease_id = $val;
                    $obj = _isChild($v['age']) ? $dis_child : $dis_adult;
                    $data = $obj->fetch_BY_CategoryID_AND_DiseaseID($v['shojo_category_id'], $disease_id);
                if ($v['primaryShojo'] != $data['DiseaseName']) {
                    echo( '<br>' . LMDString::rh($data['DiseaseName'])  );
                }
            }
            ?>
            </div>
            
        </td>
        <td>
          <div class="d-flex justify-content-center">
            <div style="width: 2rem;">
              <?php if (Severity::getRiskText($v['risk_level']) == Severity::LABEL_RISK_HIGH): ?>
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" class="size-5">
                  <path fill-rule="evenodd" d="M5.22 14.78a.75.75 0 0 0 1.06 0l7.22-7.22v5.69a.75.75 0 0 0 1.5 0v-7.5a.75.75 0 0 0-.75-.75h-7.5a.75.75 0 0 0 0 1.5h5.69l-7.22 7.22a.75.75 0 0 0 0 1.06Z" clip-rule="evenodd" />
                </svg>
              <?php elseif (Severity::getRiskText($v['risk_level']) == Severity::LABEL_RISK_MIDDLE): ?>
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" class="size-5">
                  <path fill-rule="evenodd" d="M3 10a.75.75 0 0 1 .75-.75h10.638L10.23 5.29a.75.75 0 1 1 1.04-1.08l5.5 5.25a.75.75 0 0 1 0 1.08l-5.5 5.25a.75.75 0 1 1-1.04-1.08l4.158-3.96H3.75A.75.75 0 0 1 3 10Z" clip-rule="evenodd" />
                </svg>
              <?php elseif (Severity::getRiskText($v['risk_level']) == Severity::LABEL_RISK_LOW): ?>
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" class="size-5">
                  <path d="M6.28 5.22a.75.75 0 0 0-1.06 1.06l7.22 7.22H6.75a.75.75 0 0 0 0 1.5h7.5a.747.747 0 0 0 .75-.75v-7.5a.75.75 0 0 0-1.5 0v5.69L6.28 5.22Z" />
                </svg>
              <?php endif; ?>
            </div>
          </div>
        </td>
        <td><?=$v['diagnosis']?></td>
        <td><?=$v['outcome']?></td>
      </tr>
    <?php endforeach; else: ?>
    <?php if( ! $lmd->isMainModule('doctor_tab.history')): ?>
        <tr>
            <td colspan="9">該当はありませんでした</td>
        </tr>
    <?php endif; ?>
    <?php endif; ?>
    </tbody>
  </table>
</div>



<!-- Toast UI -->
<div class="toast custom-toast-shadow" id="myToast" role="alert" aria-live="assertive" aria-atomic="true"
    data-bs-autohide="true" data-bs-delay="5000" style="position: absolute;">
    <div class="toast-body" id="toast-body">
        <!-- メッセージ -->
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const toastEl = document.getElementById('myToast');
    const toastBody = document.getElementById('toast-body');
    const toast = new bootstrap.Toast(toastEl, {  });

    document.querySelectorAll('td.toast_show').forEach(td => {
        const toastMessageDiv = td.querySelector('.data-toast');

        if (toastMessageDiv) {
            const message = toastMessageDiv.innerHTML.trim();
            if (!message) {
              // カーソルをデフォルトに戻す
              td.style.cursor = 'auto';
              // メッセージが空ならトーストを表示せず、
              return;
            }
            // メッセージがあればカーソルはpointerのまま
            td.style.cursor = 'pointer';
            td.addEventListener('click', () => {
                // 改行を含むHTMLをセット
                toastBody.innerHTML = message;

                // 位置取得
                const thRect = td.getBoundingClientRect();
                const viewportHeight = window.innerHeight;

                // 位置設定
                toastEl.style.bottom = `${viewportHeight - thRect.top - thRect.height - window.scrollY + 5}px`;
                toastEl.style.left = `${thRect.left + window.scrollX}px`;

                // 幅設定（必要に応じて）
                toastEl.style.width = `${thRect.width}px`;
                toastEl.style.minWidth = `${thRect.width}px`;

                // ここでtd.shojoの背景色を取得してtoastに適用
                const thBgColor = window.getComputedStyle(td.parentElement).backgroundColor;
                toastEl.style.backgroundColor = thBgColor;

                toast.show();
            });
        }
    });
});



  document.addEventListener('DOMContentLoaded', function () {
    const table = document.querySelector('table');

    // すべての td に対して処理
    const tds = table.querySelectorAll('td:not(.shojo)');
    tds.forEach(function (td) {
      td.style.cursor = 'pointer';
      // クリックイベント
      td.addEventListener('click', function () {
        const tr = td.closest('tr');
        const href = tr.getAttribute('data-href');
        if (href) {
          window.location.href = href;
        }
      });
    });
  });
</script>


