<?php
    $lmd->invokeModule('doctor.head', array(
        'title' => SITE_NAME,
    ));
?>



<style>
/* モダンなUIスタイル */
:root {
  --primary-color: #2c3e50;
  --secondary-color: #3498db;
  --light-bg: #f5f7fa;
  --success-color: #2ecc71;
  --warning-color: #f39c12;
  --danger-color: #e74c3c;
  --text-color: #333;
  --border-radius: 4px;
  --box-shadow: 0 2px 5px rgba(0,0,0,0.1);
}

body {
  font-family: 'Helvetica Neue', Arial, sans-serif;
  background-color: var(--light-bg);
  color: var(--text-color);
}

/* ヘッダーエリアスタイル改善 */
#ctl-pad {
  background: linear-gradient(to bottom, #34495e, #2c3e50);
  /* border-radius: 0 0 var(--border-radius) var(--border-radius); */
  box-shadow: var(--box-shadow);
  /* padding: 15px; */
}

#reload_btn, #list_btn, #logout, #print-button {
  background-color: var(--secondary-color);
  color: white;
  border: none;
  border-radius: var(--border-radius);
  /* padding: 8px 15px; */
  cursor: pointer;
  font-size: 14px;
  transition: background-color 0.3s;
}

.list-box-head {
    margin-top: 8px;
}
.list-box-data {
    display: flex;
    align-items: center;
}

#logout {
    margin-bottom: 16px;
}

#reload_btn:hover, #list_btn:hover, #logout:hover, #print-button:hover {
  background-color: #2980b9;
}

#date-pad select {
  border-radius: var(--border-radius);
  border: 1px solid #ddd;
  padding: 8px;
  font-size: 16px;
}

/* フィルターセクション */
#div-pad {
  background-color: rgba(255,255,255,0.9);
  border-radius: var(--border-radius);
  padding: 10px;
  margin-bottom: 10px;
}

#div-pad label {
  margin-right: 15px;
  font-size: 14px;
}

/* リストスタイル改善 */
#list-pad {
  margin-top: 20px;
}

.list-row {
  background-color: white;
  border-radius: var(--border-radius);
  box-shadow: var(--box-shadow);
  margin-bottom: 10px;
  padding: 15px;
  top: -4px !important;
  transition: transform 0.2s, box-shadow 0.2s;
}

.list-row:hover {
  transform: translateY(-2px);
  box-shadow: 0 4px 8px rgba(0,0,0,0.15);
}

/* フォントサイズ統一 */
.row_exa_stat, .row_datetime, .row_card_number, 
.row_gender, .row_age, .row_weight, 
.row_nowtemp, .severity, .vital_sign, 
.row_assessment, .shojo, .diagnosis {
  font-size: 16px !important;
  margin-right: 10px;
}

/* Vital Signs スタイル */
.vital_sign input {
  border: 1px solid #ddd;
  border-radius: var(--border-radius);
  padding: 5px;
  width: 40px;
  font-size: 14px;
}

/* 重症度表示の改善 */
.severity select, .row_assessment select {
  border-radius: var(--border-radius);
  padding: 5px;
  font-size: 14px;
}

/* 診断結果 */
.diagnosis {
  font-weight: bold;
  color: var(--primary-color);
}

/* レスポンシブ対応 */
@media (max-width: 768px) {
  .list-row {
    padding: 10px;
  }
  
  .row_exa_stat, .row_datetime, .row_card_number, 
  .row_gender, .row_age, .row_weight, 
  .row_nowtemp, .severity, .vital_sign, 
  .row_assessment, .shojo, .diagnosis {
    font-size: 14px !important;
  }
}
</style>

<?php
    $lmd->invokeModule('doctor.list');
?>

<?php
    $lmd->invokeModule('doctor.foot');
?>
