<?php

$vital_sign  = $lmd->httpPost('vital_sign', array());
$answer_code = $lmd->httpPost('answer_code');
$doctor_id   = $lmd->httpPost('doctor_id');

$map = array(
    'bt'      => 'body_temperature',
    'hr'      => 'heart_rate',
    'rr'      => 'respiratory_rate',
    'spo2'    => 'spo2',
    'bp_low'  => 'blood_pressure_low',
    'bp_high' => 'blood_pressure_high',
);

$p = array(
    'answer_code' => $answer_code, 
    'doctor_id' => $doctor_id, 
);

foreach ($map as $k => $v) {
    if (isset($vital_sign[$k])) {
        $p[$v] = $vital_sign[$k];
    } else {
        // jquery の ajax にエラーとして認識させる
        header('HTTP/1.0 404 Not Found');
        exit('invalid request.');
    }
}

$dao = Factory::load('DB/DAO_vital_sign')->getInstance();
$res = $dao->update_minimum_BY_answer_code($answer_code, $p);
//if ( ! $res) header('HTTP/1.0 404 Not Found'); // jquery の ajax にエラーとして認識させる

exit;
