<?php

$answer_code = $lmd->httpPost('answer_code');

$new_card_number = $lmd->httpPost('new_card_number');
$datetime = $lmd->httpPost('datetime');
$new_answer_code = "{$new_card_number}-{$datetime}";

$dao = array();
$dao['base']     = Factory::load('DB/DAO_Base')->getInstance();
$dao['answers']  = Factory::load('DB/DAO_answers')->getInstance();
$dao['outpatient']  = Factory::load('DB/DAO_outpatient_carte')->getInstance();
$dao['vital']  = Factory::load('DB/DAO_vital_sign')->getInstance();
$dao['kiou']     = Factory::load(_isChild() ? 'DB/DAO_kiou_child' : 'DB/DAO_kiou_adult')->getInstance();

/**
 * Transaction.
 */
try {

    // begin
    $dao['base']->begin();

    // update: answers
    $dao['answers']->update_answer_code_AND_card_number_BY_answer_code($answer_code, $new_answer_code, $new_card_number);

    // update: outpatient
    $dao['outpatient']->update_answer_code_BY_answer_code($answer_code, $new_answer_code);

    // update: vital
    $dao['vital']->update_answer_code_BY_answer_code($answer_code, $new_answer_code);

    // update: kiou
    $dao['kiou']->update_answer_code_AND_card_number_BY_answer_code($answer_code, $new_answer_code, $new_card_number);

    // commit
    $dao['base']->commit();
    $res = true;

} catch (Exception $e) {

    // rollback
    $dao['base']->rollback();
    $res = false;
}

if ($res) {
    // 登録成功
    Javascript::redirect(APP_ROOT. "/doctor_tab/exa?answer_code={$new_answer_code}", '修正しました');
} else {
    // 登録失敗
    Javascript::backReferer('修正に失敗しました', '#ffa07a');
}
