<?php

Factory::import('App/ExternalInjuryDiagnosisRank');

$parts_answers = $lmd->param('parts_answers');
$lmd->setResponse(array(
    'serious_level' => $lmd->param('serious_level'), 
    'ex_diagnosis'  => $lmd->param('ex_diagnosis'), 
    'em_category'   => $lmd->param('em_category'), 
    'is_history'    => $lmd->param('is_history'), 
    'parts_answers' => $parts_answers, 
    'step232_answers' => $lmd->param('step232_answers'), 
));

/**
 * 診断名自動判定
 */
{
    $buf = array();
    if ($parts_answers) {
        $dao = Factory::load('DB/DAO_external_injury_diagnosis_rank')->getInstance();
        foreach ($parts_answers as $type_id => $values) {
            $values = is_array($values) ? $values : (array)$values;
            foreach ($values as $parts_id) {
                $ret = $dao->getDiagNameByTypeIdAndPatrsId($type_id, $parts_id);
                if ($ret) $buf[] = $ret;
            }
        }
    }

    $common = $life = array();
    foreach ($buf as $v) 
    {
        for ($i = 1; $i <= ExternalInjuryDiagnosisRank::COMMON_MAX; $i++) {
            $common[$i][] = $v['common'.$i];
        }
        for ($i = 1; $i <= ExternalInjuryDiagnosisRank::LIFE_THREATENING_MAX; $i++) {
            $life[$i][]  = $v['life_threatening'.$i];
        }
    }

    $eidr = new ExternalInjuryDiagnosisRank($common, $life);
    $lmd->setResponse(array(
        'diag_common' => $eidr->getSortedCommon(), 
        'diag_life'   => $eidr->getSortedLifeThreatening(), 
    ));
}


