<?php

$dao = Factory::load('DB/DAO_answers')->getInstance();
//_Ve($_answer_code);
$res = $dao->fetchNewest_BY_answer_code($_answer_code);

$answer_id = $res ? $res['answer_id'] : '';

//_Ve($res);
$lmd->setResponse(
    $res
);

$serial = unserialize($res['serialized']);
$lmd->setResponse(array(
    'serial' => $serial, 
));
//_ve($serial);

$qa = Factory::load('App/QA')->getInstance();

/**
 * step2: 全身の状態 
 */
{
    $step2_questions = $qa->step2_getQuestions($res['life_days'], $category_id);
    $step2_answers   = $qa->step2_getAnswers($step2_questions, $category_id);
    $lmd->setResponse(array(
        'step2_questions' => $step2_questions, 
        'step2_answers'   => $step2_answers, 
        'step2_selected_answer' => $serial[2]['answers'], 
    ));
}

// 救急外傷へ移行...
/**
 * step212: 外傷の詳細
 */
{
    if (isset($serial[211]['answers']) && $serial[211]['answers']) {
        $step212_questions = $qa->step212_getQuestions($serial[211]['answers'], $step212_injurys);
        $step212_answers   = $qa->step212_getAnswers($step212_questions);
        //_Ve($step212_injurys, $step212_questions, $step212_answers);
        $lmd->setResponse(array(
            'step212_injurys'   => $step212_injurys, 
            'step212_questions' => $step212_questions, 
            'step212_answers'   => $step212_answers, 
            'step212_selected_answer' => $serial[212]['answers'], 
        ));
        //_ve($serial[212]['answers']);
    }
}

/**
 * step31: 症状の詳細
 */
{
    // P.34 「全身状態用性年齢区分を抽出」で求めたCategoryID値は絶対に使用しない様に十分注意する事。
    $shojo_category_id = $res['shojo_category_id'];

    if (isset($serial[31]['answers']) && $serial[31]['answers']) {
        $diseases_arr = $qa->step31_getDiseaseArr($serial[3]['answers']);
        $step31_diseases  = $qa->step31_getDisease($diseases_arr, $shojo_category_id);
        $step31_questions = $qa->step31_getQestions($diseases_arr, $shojo_category_id);
        $step31_answers   = $qa->step31_getAnswers($step31_questions, $shojo_category_id);
        $lmd->setResponse(array(
            'step31_diseases'  => $step31_diseases, 
            'step31_questions' => $step31_questions, 
            'step31_answers'   => $step31_answers, 
            'step31_selected_answer' => $serial[31]['answers'], 
        ));
    }
    if (isset($serial[3]['enableFever']) && $serial[3]['enableFever']) {
        $step31_fever_diseases[FEVER_ID] = $qa->step31_getFiverDisease($category_id, FEVER_ID);
        $step31_fever_questions = $qa->step31_getFiverQestions($category_id, FEVER_ID);
        $step31_fever_answers   = $qa->step31_getAnswers($step31_fever_questions, $category_id);
        $lmd->setResponse(array(
            'step31_fever_diseases'  => $step31_fever_diseases, 
            'step31_fever_questions' => $step31_fever_questions, 
            'step31_fever_answers'   => $step31_fever_answers, 
            'step31_selected_fever_answers' => $serial[31]['fever_answers'], 
        ));
    }
    $lmd->setResponse(array(
        'step31_when' => (isset($res['step31_when']) && $res['step31_when']) ? _getWhen($res['step31_when']) : array(),
        'fromtemp_div_id' => (isset($res['fromtemp_div_id']) && $res['fromtemp_div_id']) ? $res['fromtemp_div_id'] : '', 
    ));
}

/**
 * step22: 誤飲
 */
{
    $step22_swallow_object = '';
    if ($res['isGoin']) {
        $step22_items = Factory::load('DB/DAO_monshin_child')->getInstance()->step22_getItems(range(2,7));
        foreach ($step22_items as $v) {
            if ($v['SwallowObjectID'] == $res['step22_answers']) {
                $step22_swallow_object = $v['SwallowObjectName'];
                break;
            }
        }
    }
    $step22_swallow_object = $res['isGoin'] ? 'はい' : 'いいえ';
    $lmd->setResponse(array(
        'step22_swallow_object' => $step22_swallow_object, 
    ));
}

// {{{ 救急外傷
///**
// * 救急外傷(全身状態2を含む)
// */
//{
//    // 全身状態2...
//    if (isset($serial[231]['answers']) && $serial[231]['answers']) {
//        $bod = Factory::load('DB/DAO_body_condition2_question')->getInstance();
//        $bodlist = $bod->fetchAllBodyCondition2QuestionWithAnswerSelection();
//        $step231_questions = $step231_answers = array();
//        if (! empty($bodlist)) {
//            // VIEW用の配列を生成...
//            foreach ($serial[231]['answers'] as $quest_id => $select_id) {
//                foreach ($bodlist as $val) {
//                    if ($val['body_condition2_question_id'] == $quest_id) {
//                        $step231_questions[$quest_id] = $val;
//                        $step231_answers[$quest_id][] = $val;
//                    }
//                }
//            }
//        }
//        $lmd->setResponse(array(
//            'step231_questions' => $step231_questions, 
//            'step231_answers'   => $step231_answers, 
//            'step231_selected_answer' => $serial[231]['answers'], 
//        ));
//    }
//    // 救急外傷...
//    if (isset($serial[233]['answers']) && $serial[233]['answers']) {
//        $ext = Factory::load('DB/DAO_external_injury_question')->getInstance();
//        $extlist = $ext->fetchAllExternalInjuryQuestionWithAnswerSelection();
//        $step233_injurys = $step233_questions = $step233_answers = array();
//        $step234_injurys = $step234_questions = $step234_answers = array();
//        if (! empty($extlist)) {
//            // VIEW用の配列を生成...
//            foreach ($serial[233]['answers'] as $quest_id => $select_id) {
//                foreach ($extlist as $val) {
//                    if ($val['external_injury_question_id'] == $quest_id) {
//                        $injury_id = $val['external_injury_type_id'];
//                        $step233_injurys[$injury_id]              = $val;
//                        $step233_questions[$injury_id][$quest_id] = $val;
//                        $step233_answers[$quest_id][]             = $val;
//                    }
//                }
//            }
//            if (isset($serial[234]['answers'])) {
//                foreach ($serial[234]['answers'] as $quest_id => $select_id) {
//                    foreach ($extlist as $val) {
//                        if ($val['external_injury_question_id'] == $quest_id) {
//                            $injury_id = $val['external_injury_type_id'];
//                            $step234_injurys[$injury_id]              = $val;
//                            $step234_questions[$injury_id][$quest_id] = $val;
//                            $step234_answers[$quest_id][]             = $val;
//                        }
//                    }
//                }
//            }
//        }
//        $lmd->setResponse(array(
//            'step233_injurys'   => $step233_injurys, 
//            'step233_questions' => $step233_questions, 
//            'step233_answers'   => $step233_answers, 
//            'step233_selected_answer' => isset($serial[233]['answers']) ? $serial[233]['answers'] : '', 
//            'step234_injurys'   => $step234_injurys, 
//            'step234_questions' => $step234_questions, 
//            'step234_answers'   => $step234_answers, 
//            'step234_selected_answer' => isset($serial[234]['answers']) ? $serial[234]['answers'] : '', 
//        ));
//    }
//    // 外傷共通項目
//    if (isset($serial[235]['answers']) && $serial[235]['answers']) {
//        $type_id = $serial[232]['answers'];
//        $con = Factory::load('DB/DAO_external_injury_common')->getInstance();
//        $que = Factory::load('DB/DAO_external_injury_question')->getInstance();
//        $parts = $con->fetchPartsList();
//        $parts_list = $parts_group = array();
//        foreach ($parts as $val) {
//            $parts_list[$val['external_injury_parts_id']] = $val;
//            $parts_group[$val['external_injury_group_id']] = $val['external_injury_group_name'];
//            $parts_group[$val['external_injury_group_id']] = $val['external_injury_group_name'];
//            $parts_group[$val['external_injury_group_id']] = $val['external_injury_group_name'];
//        }
//        $conlist = $con->fetchAllNameListByType($type_id);
//        $step235_questions = $step235_answers = array();
//        if (! empty($conlist)) {
//            // VIEW用の配列を生成...
//            foreach ($serial[235]['answers'] as $kind_id => $select_id) {
//                foreach ($conlist as $val) {
//                    if ($val['kind'] == 1) { // 部位の場合
//                        $val['external_injury_group_id'] = $parts_list[$val['common_num']]['external_injury_group_id'];
//                        $val['external_injury_group_name'] = $parts_list[$val['common_num']]['external_injury_group_name'];
//                    }
//                    if ($val['kind'] == $kind_id) {
//                        if (! isset($step235_questions[$kind_id])) {
//                            foreach ($type_id as $id) {
//                                $cname = 'type' . $id;
//                                if (! empty($val[$cname])) {
//                                    $ans_id = $val[$cname];
//                                    break;
//                                }
//                            }
//                            $question = $que->fetchExternalInjuryQuestionByAnswerId($ans_id);
//                            $step235_questions[$kind_id] = array(
//                                'kind' => $val['kind'],
//                                'question_name' => $question['question_name'],
//                                'external_injury_type_id' => $question['external_injury_type_id'],
//                                'select_type' => $question['select_type'],
//                            ); 
//                        }
//                        $step235_answers[$kind_id][] = $val;
//                    }
//                }
//            }
//        }
//        $lmd->setResponse(array(
//            'parts_group' => $parts_group,
//            'step235_questions' => $step235_questions, 
//            'step235_answers'   => $step235_answers, 
//            'step235_selected_answer' => isset($serial[235]['answers']) ? $serial[235]['answers'] : '', 
//        ));
//    }
//}
// }}}

/**
 * 既往
 */
{
    $dao = Factory::load(_isChild() ? 'DB/DAO_kiou_child' : 'DB/DAO_kiou_adult')->getInstance();
    $kiou = $dao->fetch_BY_answer_code($res['answer_code']);
    //_Ve($kiou);

    if (_isChild()) {
        $lmd->setResponse(array(
            'kiou' => $kiou,
        ));
    } else {
        $lmd->setResponse(array(
            'kiou' => $kiou,
        ), Lambda::INSANITATION);
    }

    $lmd->setResponse(array(
        'q12_family' => isset($kiou['q12_family']) ? $kiou['q12_family'] : '',
        'q13_family' => isset($kiou['q13_family']) ? $kiou['q13_family'] : '',
    ), Lambda::INSANITATION);
}

/**
 * 判定
 */
{
    $mode = _isChild($res['age']) ? Severity::CHILD : Severity::ADULT;
    $isRoleDoctor = _isRoleDoctor();

    $severity = Factory::load('App/Severity')->getInstance($mode);
    $severity->judge($answer_id, $severity, $isRoleDoctor);
    $severity_level = $severity->getSeverityLevel();
    $risk_level     = $severity->getRiskLevel();

    $lmd->setResponse(array(
        'severity_level' => $severity_level, 
        'risk_level'     => $risk_level, 
        'severity_answer_id' => $answer_id,
    ));
}

/**
 * Vital Sign / Outcome
 */
$lmd->setResponse(array(
    'vital' => Factory::load('DB/DAO_vital_sign')->getInstance()
                                            ->fetch_BY_answer_code($_answer_code),
));

// {{{ 処置対応データ取得とセット
$severity = Factory::load('App/Severity')->getInstance(_isChild() ? Severity::CHILD : Severity::ADULT);
$lmd->setResponse($severity->getShochiTaioComment($answer_id));
// }}}

