<?php
    $lmd->invokeModule('doctor.head', array(
        'title' => SITE_NAME,
        'card_number' => $card_number,
    ));
?>

<!-- {{{ Vital CSS -->
<script type="text/javascript">
$(function(){
    $('#vital input[type="checkbox"]').click(function(){
        vital.check_button($(this));
    });
    $('#vital input[type="radio"]').click(function(){
        var name = $(this).attr('name');
        $('#vital input[name="' + name + '"]').each(function(){
            vital.check_button($(this));
        });

    });
    $('#blood_pressure_lr_flag_label').click(function(){
        vital.check_blood($(this));
    });
    $('#vital input').change(function(){
        vital.update();
    });
    vital.check_default();

<?php if (_isRoleClerk()) : // 事務方は更新不可 ?>
    $('#vital input').attr('disabled', true);
<?php endif; ?>
});
var vital = {
    update: function() {
        var body_temperature = $('[name="body_temperature"]').val();
        var heart_rate = $('[name="heart_rate"]').val();
        var respiratory_rate = $('[name="respiratory_rate"]').val();
        var spo2 = $('[name="spo2"]').val();
        var room_air_flag = $('[name="room_air_flag"]').attr('checked') ? 1 : 0;
        var o2_flag = $('[name="o2_flag"]').attr('checked') ? 1 : 0;
        var o2 = $('[name="o2"]').val();
        // 血圧
        var blood_pressure_lr_flag = $('[name="blood_pressure_lr_flag"]').attr('checked') ? 1 : 0;
        var blood_pressure_low = $('[name="blood_pressure_low"]').val();
        var blood_pressure_high = $('[name="blood_pressure_high"]').val();
        // 左
        var blood_pressure_l_low = $('[name="blood_pressure_l_low"]').val();
        var blood_pressure_l_high = $('[name="blood_pressure_l_high"]').val();
        // 右
        var blood_pressure_r_low = $('[name="blood_pressure_r_low"]').val();
        var blood_pressure_r_high = $('[name="blood_pressure_r_high"]').val();
        if ($('#dx_flag_yes').attr('checked')) {
            var dx_flag = 1;
        } else if ($('#dx_flag_no').attr('checked')) {
            var dx_flag = 0;
        } else {
            var dx_flag = '';
        }
        if ($('#tx_flag_yes').attr('checked')) {
            var tx_flag = 1;
        } else if ($('#tx_flag_no').attr('checked')) {
            var tx_flag = 0;
        } else {
            var tx_flag = '';
        }
        if ($('#assessment_flag_home').attr('checked')) {
            var assessment_flag = 1;
        } else if ($('#assessment_flag_after').attr('checked')) {
            var assessment_flag = 2;
        } else if ($('#assessment_flag_enter').attr('checked')) {
            var assessment_flag = 3;
        } else {
            var assessment_flag = '';
        }
        $.ajax({
            type: 'GET',
            async: false,
            cache: false,
            url: '<?php echo APP_ROOT ?>/doctor/update_vital_sign_outcome',
            data: {
                'doctor_id' : '<?php echo(DocCookie::getUserId()); ?>',
                'answer_code' : '<?php echo($_answer_code); ?>',

                'body_temperature' : body_temperature,
                'heart_rate' : heart_rate,
                'respiratory_rate' : respiratory_rate,
                'spo2' : spo2,
                'room_air_flag' : room_air_flag,
                'o2_flag' : o2_flag,
                'o2' : o2,
                'blood_pressure_lr_flag' : blood_pressure_lr_flag,
                'blood_pressure_low' : blood_pressure_low,
                'blood_pressure_high' : blood_pressure_high,
                'blood_pressure_l_low' : blood_pressure_l_low,
                'blood_pressure_l_high' : blood_pressure_l_high,
                'blood_pressure_r_low' : blood_pressure_r_low,
                'blood_pressure_r_high' : blood_pressure_r_high,
                'dx_flag' : dx_flag,
                'tx_flag' : tx_flag,
                'assessment_flag' : assessment_flag
            },
            success: function(){
                // noop.
            }
        });
    },
    check_button: function(o) {
        if (o.attr('checked')) {
            o.prev().css({'color':'#0000ff','font-weight':'bold'});
        } else {
            o.prev().css({'color':'#000000','font-weight':'normal'});
        }
    },
    check_blood: function(o) {
        if (o.attr('checked')) {
            $('#blood_pressure_input').hide();
            $('#blood_pressure_lr_input').show();
        } else {
            $('#blood_pressure_input').show();
            $('#blood_pressure_lr_input').hide();
        }
    },
    check_default: function() {
        this.check_blood($('#blood_pressure_lr_flag_label'));
        $('#vital input[type="checkbox"], #vital input[type="radio"]').each(function(){
            vital.check_button($(this));
        });
    }
};
</script>



<!--ここからMI加藤手を入れる箇所-->



<style>
/* モダンなUIスタイル - 基本設定 */
:root {
  --primary-color: #2c3e50;
  --secondary-color: #3498db;
  --light-bg: #f5f7fa;
  --text-color: #333;
  --border-color: #E3E3E3;
  --border-radius: 4px;
  --box-shadow: 0 2px 5px rgba(0,0,0,0.1);
}

#vital input[type="radio"], #vital input[type="checkbox"] {
    display: none;
}

/* 基本フォントスタイル */
body {
  font-family: 'Helvetica Neue', Arial, sans-serif;
  font-size: 14px;
  line-height: 1.6;
  color: var(--text-color);
}

/* テーブルスタイルの修正 */
table.table-01 {
  width: 100%;
  border: 0;
  background: white;
}

table.table-01 th {
  text-align: center;
  padding: 12px;
  background: var(--primary-color);
  color: white;
  font-size: 14px;
  font-weight: normal;
}

table.table-01 td {
  padding: 12px;
  font-size: 14px;
}

/* バイタルサイン入力エリアの改善 */
#vital {
  width: 100%;

  background: white;
  border: 1px solid var(--border-color);
  border-radius: var(--border-radius);
  margin-bottom: 20px;
  font-size: 14px;
  line-height: 1.6;
}

#vital .tr {
  display: flex;
  padding: 15px;
  border-bottom: 1px solid var(--border-color);
  height: auto;
  min-height: 60px;
}

#vital .th {
  width: 130px;
  padding: 15px;
  background: var(--primary-color);
  color: white;
  font-weight: normal;
  border: none;
  height: auto;
}

#vital .td {
  flex: 1;
  padding: 15px;
  line-height: 2;
}

#vital input[type="text"] {
  width: 60px;
  padding: 4px 8px;
  border: 1px solid #ddd;
  border-radius: 3px;
  font-size: 14px;
}

#vital label {
  display: inline-block;
  padding: 4px 8px;
  background: #f5f5f5;
  border-radius: 3px;
  margin: 0 4px;
  cursor: pointer;
  font-size: 14px;
}

/* QAエリアの改善 */
.qa-area {
  background: white;
  border: 1px solid var(--border-color);
  border-radius: var(--border-radius);
  padding: 20px;
  margin-bottom: 20px;
  width: auto;

  font-size: 14px;
}

.qa-area p {
  margin: 10px 0;
  line-height: 1.6;
}

/* ボタンスタイル */
#print-button button {
  background: var(--secondary-color);
  color: white;
  border: none;
  border-radius: var(--border-radius);
  padding: 8px 16px;
  font-size: 14px;
  cursor: pointer;
}

#list_btn, #logout{
  background-color: var(--secondary-color);
  color: white;
  border: none;
  border-radius: var(--border-radius);
  /* padding: 8px 15px; */
  cursor: pointer;
  font-size: 14px;
  transition: background-color 0.3s;
}

#logout {
  margin-bottom: 16px;
}

/* 選択状態の表示改善 */
.a_selected {
  color: var(--secondary-color);
  font-weight: bold;
  font-size: 14px;
}

#left-menu {
    top: 190px !important; 
}

#spacer4ctl-pad {
    height: 180px !important;
}

.a_unselected {
  color: #999;
  font-size: 14px;
}

/* 印刷ボタン */


#print-button button {
  height: auto;
  width: auto;
  min-width: 120px;
}

/* レスポンシブ対応 */
@media (max-width: 768px) {
  #vital .tr {
    flex-direction: column;
  }
  
  #vital .th {
    width: 100%;
  }
  
  #vital .td {
    padding: 10px;
  }
  
  .table-01, 
  #vital, 
  .qa-area {
    width: 95%;
    margin: 10px auto;
  }
}

/* ユーティリティクラス */
.sub {
  vertical-align: sub;
  font-size: smaller;
}

.clear {
  clear: both;
}
/* ヘッダー情報エリアのスタイル改善 */
#info-pad {
  float: left;
  width: 75%;
  background-color: white;
  border-radius: var(--border-radius);
  box-shadow: var(--box-shadow);
  /* margin: 10px 0; */
  padding: 15px;
}

#info-pad table {
  width: 100%;
  border-collapse: collapse;
  margin-bottom: 8px;
  font-size: 14px;
}

#info-pad table:first-child {
  border-bottom: none;
}

#info-pad table th {
  width: 140px;
  background: var(--primary-color);
  color: white;
  padding: 8px;
  text-align: left;
  font-weight: normal;
  border-radius: var(--border-radius) 0 0 var(--border-radius);
}

#info-pad table td {
  padding: 8px;
  border: 1px solid var(--border-color);
  background: var(--light-bg);
}

/* バイタルサインの値を強調 */
#info-pad table td:not(:first-child) {
  font-weight: bold;
  color: var(--primary-color);
}

/* レスポンシブ対応 */
@media (max-width: 768px) {
  #info-pad {
    width: 95%;
    margin: 10px auto;
  }
  
  #info-pad table {
    font-size: 13px;
  }
  
  #info-pad table th {
    width: 100px;
  }
  
}

/* タブナビゲーションのスタイル改善 */


#tab {
  width: 100%;
  border-collapse: separate;
  border-spacing: 2px 0;
}

#tab td {
  padding: 12px 20px;
  background: var(--light-bg);
  border: none;
  border-radius: var(--border-radius) var(--border-radius) 0 0;
  text-align: center;
  font-size: 14px;
  transition: background-color 0.3s;
}

#tab td:hover {
  background: #e4e9f2;
}

#tab td.selected, 
#tab_exa, 
#tab_exa_edit, 
#tab_carte, 
#tab_treatment, 
#tab_history, 
#tab_card_number_edit {
  background: white;
  box-shadow: 0 -2px 5px rgba(0,0,0,0.1);
}

#tab td a {
  color: var(--primary-color);
  text-decoration: none;
  display: block;
  font-weight: 500;
}

/* 左メニューのスタイル改善 */
#left-menu {
  position: fixed;
  top: 190px;
  left: 0;
  width: 130px;
  background: white;
  border-radius: 0 var(--border-radius) var(--border-radius) 0;
  box-shadow: var(--box-shadow);
  z-index: 97;
}

.left-menu-tbl {
  width: 120px;
  border: none;
  border-radius: var(--border-radius);
  margin: 5px auto;
  background: white;
  overflow: hidden;
}

.left-menu-tbl th {
  padding: 8px;
  background: var(--primary-color);
  color: white;
  font-weight: normal;
  font-size: 13px;
  text-align: center;
  border: none;
}

.left-menu-tbl td {
  padding: 8px;
  background: white;
  border: 1px solid var(--border-color);
  border-top: none;
  font-size: 12px;
  line-height: 1.4;
}

.left-menu-tbl td a {
  color: var(--text-color);
  text-decoration: none;
  display: block;
}

.left-menu-tbl td:hover {
  background: var(--light-bg);
}

#lm_value_s {
  font-size: 12px;
  margin-bottom: 3px;
}

#left-menu a:hover {
  text-decoration: none;
}

/* メインコンテンツのマージン調整 */

#cne_wrap, 
#flexible_frame, 
#ctrl-menu, 
.diagnosis_list {
  margin-left: 140px;
}

/* レスポンシブ対応 */
@media (max-width: 768px) {
  #ctl-tab {
    margin-left: 10px;
  }
  
  #tab td {
    padding: 8px 12px;
    font-size: 13px;
  }
  
  #left-menu {
    width: 100px;
  }
  
  .left-menu-tbl {
    width: 90px;
  }
  

  #cne_wrap, 
  #flexible_frame, 
  #ctrl-menu, 
  .diagnosis_list {
    margin-left: 110px;
  }
}

  .w-11 { width: 11rem; }
</style>



<!--ここまでMI加藤手を入れる箇所-->





<link rel="stylesheet" href="<?php echo APP_ROOT; ?>/css/dropkick.css" type="text/css" media="all" />
<script src="<?php echo APP_ROOT; ?>/js/jquery.dropkick.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript" charset="utf-8">
<!--
var severity = {
    update: function(level){
        $.ajax({
            type: 'GET',
            async: false,
            cache: false,
            url: '<?php echo APP_ROOT ?>/doctor/update_severity',
            data: {
                'level' : level,
                'pre_level' : '<?php echo($severity_level); ?>',
                'pre_risk' : '<?php echo($risk_level); ?>',
                'user' : '<?php echo(DocCookie::getUserId()); ?>',
                'answer' : '<?php echo($severity_answer_id); ?>'
            },
            success: function(data){
                var level = data['level'];
                var image = data['image'];
                var risk_level = data['risk_level'];
                var risk_text  = data['risk_text'];
                $('#level-image').attr('src', image);
                $('#severity-risk').text(risk_text);
                $('#severity-level option').each(function(){
                    if ($(this).attr('value') == level) {
                        $(this).attr('selected', true);
                    }
                });
                var severity_text = $('#severity-level option:selected').text();
                $('.dk_label').text(severity_text);
            }
        });
    }
};
$(function(){
    $('.level').dropkick({
        change: function(){
            severity.update($(this).val());
        }
    });
    $('.dk_toggle').css({
        width: '50px'
    });
});
//-->
</script>


<div style="padding: 0.2rem;">
    <div class="clearfix ps-2 pe-2">
        <div class="float-start w-50">
            <div class="row container dt-nav">
                <div class="col-md-2 float-start ps-0 pe-1 w-59">
                    <a class="rounded text-nowrap <?=$lmd->isMainModule('doctor_tab.exa') ? "active" : "" ?>" href="<?php echo APP_ROOT ?>/doctor_tab/exa?answer_code=<?php echo $_answer_code ?>">予診票</a>
                </div>
                <?php if(_isRoleDoctor()): ?>
                    <div class="col-md-2 float-start ps-0 pe-1 w-59">
                    <a class="rounded text-nowrap <?=$lmd->isMainModule('doctor_tab.monshin') ? "active" : "" ?>" href="<?php echo APP_ROOT ?>/doctor_tab/monshin?answer_id=<?php echo $answer_id ?>&answer_code=<?php echo $_answer_code ?>">修正</a>
                    </div>
                <?php endif; ?>
                <div class="col-md-2 float-start ps-0 pe-1 w-59">
                    <a class="rounded text-nowrap <?=$lmd->isMainModule('doctor_tab.outpatient_carte') ? "active" : "" ?>" href="<?php echo APP_ROOT ?>/doctor_tab/outpatient_carte?answer_code=<?php echo $_answer_code ?>">外来カルテ</a>
                </div>
                <?php if (_isChild()) : ?>
                    <div class="col-md-2 float-start ps-0 pe-1 w-59">
                        <a class="rounded text-nowrap <?=$lmd->isMainModule('doctor_tab.treatment') ? "active" : "" ?>" href="<?php echo APP_ROOT ?>/doctor_tab/treatment?answer_id=<?php echo $answer_id ?>&answer_code=<?php echo $_answer_code ?>">患者説明</a>
                    </div>
                <?php endif; ?>
                <?php if(_isRoleDoctor()): ?>
                    <div class="col-md-4 float-start ps-0 pe-1 w-118">
                        <a class="rounded text-nowrap <?=$lmd->isMainModule('doctor_tab.card_number_edits') ? "active" : "" ?>" href="<?php echo APP_ROOT ?>/doctor_tab/card_number_edit?answer_code=<?php echo $_answer_code ?>">診察券番号修正</a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="float-end d-flex align-items-center" style="height:46.4px">
          <div id="print-button"><button onclick="window.print();">印刷ボタン</button></div>
        </div>
    </div>
</div>


<div class="ps-2 pe-2">
  <!-- abs-m-c-table -->
  <table class="tabs-m-c-table">
    <tbody>
      <tr>
        <td class="w-11">
            <?php
                $lmd->invokeModule('doctor.left_menu');
            ?>
        </td>
        <td colspan="7">


<?php if (Device::isIos()) : ?>
<!--
<script type="text/javascript" src="<?php echo APP_ROOT ?>/js/iscroll.js"></script>
<script type="text/javascript">
var myScroll;
var a = 0;
function loaded() {
    setHeight();
    myScroll = new iScroll('main-wrap', {desktopCompatibility:true});
}
function setHeight() {
    var headerH = 100,
        footerH = 0,
        wrapperH = window.innerHeight - headerH - footerH;
    document.getElementById('wrapper').style.height = wrapperH + 'px';
}
window.addEventListener('onorientationchange' in window ? 'orientationchange' : 'resize', setHeight, false);
document.addEventListener('touchmove', function (e) { e.preventDefault(); }, false);
document.addEventListener('DOMContentLoaded', loaded, false);
</script>
<style type="text/css">
#wrapper {
    position:relative;
    z-index:1;
    width:100% ;
    overflow:hidden;
}

</style>
-->

<div id="wrapper"><!-- wrapper -->
<?php endif; ?>

<div id="main-wrap" class="b-s-2">
<?php if (_isAgent()) : // 代理入力の場合のみ表示 ?>
<p id="list-button"><button onclick="location.href='<?php echo APP_ROOT ?>/doctor/top';">受診一覧</button></p>
<p id="next-button"><button onclick="location.href='<?php echo APP_ROOT ?>/agent/login';">次の問診をする</button></p>
<?php endif; ?>


<?php if (_isAgent()) : // {{{ 代理入力の場合のみ処置対応(患者説明)を表示 ?>
<link rel="stylesheet" href="<?php echo APP_ROOT; ?>/css/agent_exa.css" type="text/css" media="all" />
<?php
    foreach ($zenshin_diagnosis_arr as $k => $v) {
        if ($v['TreatmentContents'] === '特にありません。') unset($zenshin_diagnosis_arr[$k]);
    }
 ?>
<?php if($zenshin_diagnosis_arr): ?>
    <div class="qa-area">
    <h2>全身状態</h2>
    <?php foreach($zenshin_diagnosis_arr as $v): ?>
        <p><?php echo $v['TreatmentContents'] ?></p>
    <?php endforeach; ?>
    </div>
<?php endif; ?>
<?php if($shojo_diagnosis_arr): ?>
    <div class="qa-area">
    <h2>症状</h2>
    <?php foreach($shojo_diagnosis_arr as $v): ?>
        <p><?php echo $v['TreatmentName'] ?></p>
    <?php endforeach; ?>
    </div>
<?php endif; ?>
<?php if($fever_diagnosis): ?>
    <div class="qa-area">
    <h2>発熱</h2>
    <p><?php echo $fever_diagnosis['TreatmentName'] ?></p>
    </div>
<?php endif; ?>
<?php if($gaisho_diagnosis_arr): ?>
    <div class="qa-area">
    <h2>外傷①</h2>
    <?php foreach($gaisho_diagnosis_arr as $v): ?>
        <p><?php echo $v['InjuryCommonTreat'] ?></p>
    <?php endforeach; ?>
    </div>
<?php endif; ?>
<?php if($gaisho_detail_diagnosis_arr): ?>
    <div class="qa-area">
    <h2>外傷②</h2>
    <?php foreach($gaisho_detail_diagnosis_arr as $v): ?>
        <p><?php echo $v['InjuryDetailTreat'] ?></p>
    <?php endforeach; ?>
    </div>
<?php endif; ?>
<?php if($goin_diagnosis_text): ?>
    <div class="qa-area">
    <h2>誤飲</h2>
    <p><?php echo $goin_diagnosis_text ?></p>
    </div>
<?php endif; ?>
<?php endif; // }}} ?>

<table  class="table-01">
<tr>
<th>診察券番号</th>
<td colspan="3"><?php echo $card_number ?></td>
<td colspan="4" rowspan="3" style="text-align:center; vertical-align: middle; padding: 0px;">
    <img id="level-image" src="<?php echo(Severity::getLevelImage($severity_level, $risk_level)); ?>" width="60%" />
</td>
</tr>
<tr>
<th>主訴</th>
<td colspan="3">
<?php echo $primaryShojo ?>
<?php if($s3_other_disease !== ''): ?>
    (<?php echo $s3_other_disease ?>)
<?php endif; ?>
</td>
</tr>
<tr>
<th>判定</th>
<td colspan="3">
<?php if (_isRoleClerk()) : // 事務は編集不可 ?>
    <div style="float:left;width:50px;"><?php echo(Severity::getSeverityText($severity_level)); ?></div>
    <div style="float:left;"> / <?php echo(Severity::getRiskText($risk_level)); ?></div>
<?php else : ?>
<?php
    $fe = new FormElement(Resource::get('severity.level'));
    $fe->setDefault($severity_level);
    $fe->select('severity-level', array('id' => 'severity-level', 'class' => 'level', 'tabindex' => '1'));
?>
&nbsp;/&nbsp;
<span id="severity-risk"><?php echo(Severity::getRiskText($risk_level)) ?></span>
<?php endif; ?>
</td>
</tr>
<tr>
<th>生年月日</th>
<td><?php echo $birth_y ?>/<?php echo $birth_m ?>/<?php echo $birth_d ?></td>
<th>年齢</th>
<td><?php echo _getAgeNotation($life_days) ?></td>
<th>体温</th>
<td><?php echo $nowtemp ?></td>
<th>体重</th>
<td><?php echo $weight ?></td>
</tr>
</table>

<div id="vital"><!-- vital -->
    <div class="tr" id="vitalsign">
        <div class="th">Vital Sign</div>
        <div class="td">
            [体温 <input type="text" name="body_temperature" value="<?php echo(_array_isset($vital, 'body_temperature')); ?>" /> ℃]
            [脈拍 <input type="text" name="heart_rate" value="<?php echo(_array_isset($vital, 'heart_rate')); ?>" /> 回/分]
            [呼吸 <input type="text" name="respiratory_rate" value="<?php echo(_array_isset($vital, 'respiratory_rate')); ?>" /> 数回/分]
<br>
            [SpO<span class="sub">2</span>
                <input type="text" name="spo2" value="<?php echo(_array_isset($vital, 'spo2')); ?>" />
                %(
                <label for="room_air_flag_label">room air</label>
                <input type="checkbox" id="room_air_flag_label" name="room_air_flag" value="1" <?php echo(_array_isset($vital, 'room_air_flag') == 1 ? ' checked="checked"' : ''); ?>/>
                &nbsp;
                <label for="o2_flag_label">O<span class="sub">2</span></label>
                <input type="checkbox" id="o2_flag_label" name="o2_flag" value="1" <?php echo(_array_isset($vital, 'o2_flag') == 1 ? ' checked="checked"' : ''); ?>/>
                /
                <input type="text" name="o2" value="<?php echo(_array_isset($vital, 'o2')); ?>" />
            L )]
            <br />
            <label for="blood_pressure_lr_flag_label">　左右別　</label>
            &nbsp;
            <input type="checkbox" value="1" name="blood_pressure_lr_flag" id="blood_pressure_lr_flag_label" <?php echo(_array_isset($vital, 'blood_pressure_lr_flag') == 1 ? ' checked="checked"' : ''); ?>/>
            <span id="blood_pressure_input">
                血圧
                <input type="text" name="blood_pressure_low" value="<?php echo(_array_isset($vital, 'blood_pressure_low')); ?>" />
                /
                <input type="text" name="blood_pressure_high" value="<?php echo(_array_isset($vital, 'blood_pressure_high')); ?>" />mmHg
            </span>
            <span id="blood_pressure_lr_input">
                血圧
                (左) <input type="text" name="blood_pressure_l_low" value="<?php echo(_array_isset($vital, 'blood_pressure_l_low')); ?>" />
                / <input type="text" name="blood_pressure_l_high" value="<?php echo(_array_isset($vital, 'blood_pressure_l_high')); ?>" /> mmHg
                (右) <input type="text" name="blood_pressure_r_low" value="<?php echo(_array_isset($vital, 'blood_pressure_r_low')); ?>" />
                / <input type="text" name="blood_pressure_r_high" value="<?php echo(_array_isset($vital, 'blood_pressure_r_high')); ?>" /> mmHg
            </span>
        </div>
    </div>
    <div class="tr" id="outcome">
        <div class="th">Outcome</div>
        <div class="td">
            <span class="lname">検査</span>&nbsp;&nbsp;
            <label for="dx_flag_yes">　あり　</label>
            <input type="radio" id="dx_flag_yes" name="dx_flag" value="1" <?php echo(_array_isset($vital, 'dx_flag') === '1' ? ' checked="checked"' : ''); ?>/>
            <label for="dx_flag_no">　なし　</label>
            <input type="radio" id="dx_flag_no" name="dx_flag" value="0" <?php echo(_array_isset($vital, 'dx_flag') === '0' ? ' checked="checked"' : ''); ?>/>
            &nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;&nbsp;&nbsp;
            <span class="lname">処置</span>&nbsp;&nbsp;
            <label for="tx_flag_yes">　あり　</label>
            <input type="radio" id="tx_flag_yes" name="tx_flag" value="1" <?php echo(_array_isset($vital, 'tx_flag') === '1' ? ' checked="checked"' : ''); ?>/>
            <label for="tx_flag_no">　なし　</label>
            <input type="radio" id="tx_flag_no" name="tx_flag" value="0" <?php echo(_array_isset($vital, 'tx_flag') === '0' ? ' checked="checked"' : ''); ?>/>
            <br />
            <label for="assessment_flag_home">　　帰宅　　</label>
            <input type="radio" id="assessment_flag_home" name="assessment_flag" value="1" <?php echo(_array_isset($vital, 'assessment_flag') === '1' ? ' checked="checked"' : ''); ?>/>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            <label for="assessment_flag_after">　処置検査後診察　</label>
            <input type="radio" id="assessment_flag_after" name="assessment_flag" value="2" <?php echo(_array_isset($vital, 'assessment_flag') === '2' ? ' checked="checked"' : ''); ?>/>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            <label for="assessment_flag_enter">　　入院　　</label>
            <input type="radio" id="assessment_flag_enter" name="assessment_flag" value="3" <?php echo(_array_isset($vital, 'assessment_flag') === '3' ? ' checked="checked"' : ''); ?>/>
        </div>
    </div>
</div><!-- /vital -->

<?php if(isset($step2_questions) && $step2_questions): ?>
    <div class="qa-area">
    <?php foreach($step2_questions as $q_k => $q): ?>

        <p>■ <?php echo $q['GQContents'] ?><!/p><!--加藤ここpカット-->

        <?php foreach($step2_answers[$q['ClassID']] as $a): ?>

            <?php
                if (_isChild()) {
                    $checked = in_array($a['GAContentsID'], $step2_selected_answer) ? ' checked="checked"' : '';
                } else {
                    $checked = ($step2_selected_answer[$q_k] == $a['GAnswerID']) ? ' checked="checked"' : '';
                }
            ?>

            <!p><input type="radio"<?php echo $checked ?> disabled><!--加藤ここpカット-->
            <?php if($checked): ?>
                <span class="a_selected"><?php echo $a['GAContents'] ?></span>
            <?php else: ?>
                <span class="a_unselected"><?php echo $a['GAContents'] ?></span>
            <?php endif; ?>
            <!/p><!--加藤ここpカット-->

        <?php endforeach; ?>
</p><!--加藤ここp追加-->
    <?php endforeach; ?>

    </div>
<?php endif; ?>

<?php if(isset($step31_fever_diseases) && $step31_fever_diseases): ?>
    <div class="qa-area">
    <?php
        if ($step31_fever_diseases) {
            // 発熱
            $lmd->invokeModule('doctor_tab.exa.step31', array(
                'diseases'  => $step31_fever_diseases,
                'questions' => $step31_fever_questions,
                'answers'   => $step31_fever_answers,
                'fromtemp_div_id' => $fromtemp_div_id,
                'selected_answer' => $step31_selected_fever_answers,
            ));
        }
    ?>
    </div>
<?php endif; ?>

<?php if(isset($step31_diseases) && $step31_diseases): ?>
    <div class="qa-area">
    <?php
        $lmd->invokeModule('doctor_tab.exa.step31', array(
            'diseases'  => $step31_diseases,
            'questions' => $step31_questions,
            'answers'   => $step31_answers,
            'when' => $step31_when,
            'selected_answer' => $step31_selected_answer,
        ));
    ?>
    </div>
<?php endif; ?>

<?php if(isset($step212_injurys) && $step212_injurys): ?>
    <div class="qa-area">
    <?php foreach($step212_injurys as $v): $injury_id = $v['InjuryID']; ?>

        <p>■ <?php echo $v['InjuryName'] ?></p>

        <?php foreach($step212_questions[$injury_id] as $v2): $question_id = $v2['IQuestionID']; ?>

            <p style="padding-left:20px"><?php echo $v2['IQContents'] ?><!/p><!--加藤ここpカット-->

            <?php foreach($step212_answers[$question_id] as $v3): $answer_id = $v3['IAnswerID']; ?>

                <?php
                    $checked = in_array($v3['IAnswerID'], $step212_selected_answer) ? ' checked="checked"' : '';
                ?>

                <!p style="padding-left:40px"><input type="radio"<?php echo $checked ?> disabled><!--加藤ここpカット-->
                <?php if($checked): ?>
                    <span class="a_selected"><?php echo $v3['IAContents'] ?></span>
                <?php else: ?>
                    <span class="a_unselected"><?php echo $v3['IAContents'] ?></span>
                <?php endif; ?>
                <!/p><!--加藤ここpカット-->


            <?php endforeach; ?>
</p><!--加藤ここp追加-->
        <?php endforeach; ?>

    <?php endforeach; ?>
    </div>
<?php endif; ?>

<?php if(isset($step22_swallow_object) && $step22_swallow_object): ?>
    <div class="qa-area">

    <p>■ 誤飲<!/p><!--加藤ここpカット-->
    <font style="padding-left:10px"></font><!--加藤ここfont追加-->
    <!p class="a_selected" style="padding-left:20px"><?php echo $step22_swallow_object ?></p><!--加藤ここpカット-->

    </div>
<?php endif; ?>


<?php
    $lmd->invokeModule('doctor_tab.exa.kiou', array(
        'kiou' => $kiou,
        'q12_family' => $q12_family,
        'q13_family' => $q13_family,
    ));
?>

</div><!-- /main-wrap -->
        </td>
      </tr>
    </tbody>
  </table>
  <!-- abs-m-c-table -->
</div>

<?php if (Device::isIos()) : ?>
</div><!-- /wraper -->
<?php endif; ?>

<script type="text/javascript">
<!--
$(function(){

    // {{{ ある／なし動的表示コントロール
    // 打った
    arunasi(4,29,'ある');
    arunasi(5,34,'痛がる');
    arunasi(6,37,'ある');
    arunasi(8,43,'ある');
    arunasi(9,47,'ある');
    arunasi(11,54,'ある');
    // 切った
    arunasi(18,100,'ある');
    // 挟んだ／つぶした
    arunasi(27,144,'ある');
    // 捻った
    arunasi(30,167,'ある');
    arunasi(32,174,'ある');
    // やけどした
    arunasi(63,374,'はい');
    // }}}
});
function arunasi(qid, nasival, arutext)
{
    // 回答項目「ある」のラベルを調整
    $('label[aruid="'+qid+'"]').each(function(){
        var txt = $(this).text().replace(arutext + '　', '');
        txt = txt.replace(arutext + '、', '');
        $(this).text(txt);
    });
    // 「ある」トリガーボタンテキストのセット
    $('[for="aru_item'+qid+'"]').text(arutext + '　　');
}

$(function(){
    // 未選択の回答を非表示にする
    $('.qa-area input:radio, .qa-area input:checkbox').each(function(){
        if ( ! $(this).attr('checked')) {
            $(this).hide();
            $(this).next().hide();
        }
    });
});
//-->
</script>



<?php
    $lmd->invokeModule('doctor.foot');
?>
