<?php
    $dao = Factory::load('DB/DAO_answers')->getInstance();
    $buf = $dao->fetchNewest_BY_answer_code($_answer_code);
    $answer_id = isset($buf['answer_id']) ? $buf['answer_id'] : '';

    $lmd->invokeModule('doctor.head', array(
        'title' => SITE_NAME,
    ));

    $cid = _getCacheKey();

    if ($lmd->hasHttpGet('fh_id')) {
        $fh_id = $lmd->httpGet('fh_id');
        $path = APP_ROOT."/step4?answer_code={$_answer_code}&fh_id={$fh_id}&{$cid}";
    } else {
        $path = APP_ROOT."/step1?answer_code={$_answer_code}&{$cid}";
    }
?>

<style type="text/css">
/* モダンなUIスタイル - 基本設定 */
:root {
  --primary-color: #2c3e50;
  --secondary-color: #3498db;
  --light-bg: #f5f7fa;
  --text-color: #333;
  --border-color: #E3E3E3;
  --border-radius: 4px;
  --box-shadow: 0 2px 5px rgba(0,0,0,0.1);
}

/* 基本フォントスタイル */
body {
  font-family: 'Helvetica Neue', Arial, sans-serif;
  font-size: 14px;
  line-height: 1.6;
  color: var(--text-color);
}
/* タブナビゲーションのスタイル改善 */

#tab {

  border-collapse: separate;
  border-spacing: 2px 0;

}

#tab td {
  padding: 12px 20px;
  background: var(--light-bg);
  border: none;
  border-radius: var(--border-radius) var(--border-radius) 0 0;
  text-align: center;
  font-size: 14px;
  transition: background-color 0.3s;
}

#tab td:hover {
  background: #e4e9f2;
}

#tab td.selected, 
#tab_exa, 
#tab_exa_edit, 
#tab_carte, 
#tab_treatment, 
#tab_history, 
#tab_card_number_edit {
  background: white;
  box-shadow: 0 -2px 5px rgba(0,0,0,0.1);
}

#tab td a {
  color: var(--primary-color);
  text-decoration: none;
  display: block;
  font-weight: 500;
}

/* 左メニューのスタイル改善 */
#left-menu {
  position: fixed;
  top: 190px;
  left: 0;
  width: 130px;
  background: white;
  border-radius: 0 var(--border-radius) var(--border-radius) 0;
  box-shadow: var(--box-shadow);
  z-index: 97;
}

.left-menu-tbl {
  width: 120px;
  border: none;
  border-radius: var(--border-radius);
  margin: 5px auto;
  background: white;
  overflow: hidden;
}

.left-menu-tbl th {
  padding: 8px;
  background: var(--primary-color);
  color: white;
  font-weight: normal;
  font-size: 13px;
  text-align: center;
  border: none;
}

.left-menu-tbl td {
  padding: 8px;
  background: white;
  border: 1px solid var(--border-color);
  border-top: none;
  font-size: 12px;
  line-height: 1.4;
}

.left-menu-tbl td a {
  color: var(--text-color);
  text-decoration: none;
  display: block;
}

.left-menu-tbl td:hover {
  background: var(--light-bg);
}

#lm_value_s {
  font-size: 12px;
  margin-bottom: 3px;
}

#left-menu a:hover {
  text-decoration: none;
}

/* メインコンテンツのマージン調整 */
#main-wrap, 
#cne_wrap, 

#ctrl-menu, 
.diagnosis_list {
  margin-left: 140px;
}

/* レスポンシブ対応 */
@media (max-width: 768px) {
  #ctl-tab {
    margin-left: 10px;
  }
  
  #tab td {
    padding: 8px 12px;
    font-size: 13px;
  }
  
  #left-menu {
    width: 100px;
  }
  
  .left-menu-tbl {
    width: 90px;
  }
  
  #main-wrap, 
  #cne_wrap, 

  #ctrl-menu, 
  .diagnosis_list {
    margin-left: 110px;
  }
}
/* ヘッダー情報エリアのスタイル改善 */
#info-pad {
  float: left;
  width: 75%;
  background-color: white;
  border-radius: var(--border-radius);
  box-shadow: var(--box-shadow);
  /* margin: 10px 0; */
  padding: 15px;
}

#info-pad table {
  width: 100%;
  border-collapse: collapse;
  margin-bottom: 8px;
  font-size: 14px;
}

#info-pad table:first-child {
  border-bottom: none;
}

#info-pad table th {
  width: 140px;
  background: var(--primary-color);
  color: white;
  padding: 8px;
  text-align: left;
  font-weight: normal;
  border-radius: var(--border-radius) 0 0 var(--border-radius);
}

#info-pad table td {
  padding: 8px;
  border: 1px solid var(--border-color);
  background: var(--light-bg);
}

/* バイタルサインの値を強調 */
#info-pad table td:not(:first-child) {
  font-weight: bold;
  color: var(--primary-color);
}

/* レスポンシブ対応 */
@media (max-width: 768px) {
  #info-pad {
    width: 95%;
    margin: 10px auto;
  }
  
  #info-pad table {
    font-size: 13px;
  }
  
  #info-pad table th {
    width: 100px;
  }
  
}
#left-menu {
    top: 190px !important; 
}

#spacer4ctl-pad {
    height: 180px !important;
}

#list_btn, #logout{
  background-color: var(--secondary-color);
  color: white;
  border: none;
  border-radius: var(--border-radius);
  /* padding: 8px 15px; */
  cursor: pointer;
  font-size: 14px;
  transition: background-color 0.3s;
}

#logout {
  margin-bottom: 16px;
}


</style>

<div style="padding: 0.2rem;">
    <div class="clearfix ps-2 pe-2">
        <div class="float-start w-50">
            <div class="row container dt-nav">
                <div class="col-md-2 float-start ps-0 pe-1 w-59">
                    <a class="rounded text-nowrap <?=$lmd->isMainModule('doctor_tab.exa') ? "active" : "" ?>" href="<?php echo APP_ROOT ?>/doctor_tab/exa?answer_code=<?php echo $_answer_code ?>">予診票</a>
                </div>
                <?php if(_isRoleDoctor()): ?>
                    <div class="col-md-2 float-start ps-0 pe-1 w-59">
                    <a class="rounded text-nowrap <?=$lmd->isMainModule('doctor_tab.monshin') ? "active" : "" ?>" href="<?php echo APP_ROOT ?>/doctor_tab/monshin?answer_id=<?php echo $answer_id ?>&answer_code=<?php echo $_answer_code ?>">修正</a>
                    </div>
                <?php endif; ?>
                <div class="col-md-2 float-start ps-0 pe-1 w-59">
                    <a class="rounded text-nowrap <?=$lmd->isMainModule('doctor_tab.outpatient_carte') ? "active" : "" ?>" href="<?php echo APP_ROOT ?>/doctor_tab/outpatient_carte?answer_code=<?php echo $_answer_code ?>">外来カルテ</a>
                </div>
                <?php if (_isChild()) : ?>
                    <div class="col-md-2 float-start ps-0 pe-1 w-59">
                        <a class="rounded text-nowrap <?=$lmd->isMainModule('doctor_tab.treatment') ? "active" : "" ?>" href="<?php echo APP_ROOT ?>/doctor_tab/treatment?answer_id=<?php echo $answer_id ?>&answer_code=<?php echo $_answer_code ?>">患者説明</a>
                    </div>
                <?php endif; ?>
                <?php if(_isRoleDoctor()): ?>
                    <div class="col-md-4 float-start ps-0 pe-1 w-118">
                        <a class="rounded text-nowrap <?=$lmd->isMainModule('doctor_tab.card_number_edits') ? "active" : "" ?>" href="<?php echo APP_ROOT ?>/doctor_tab/card_number_edit?answer_code=<?php echo $_answer_code ?>">診察券番号修正</a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="float-end d-flex align-items-center" style="height:46.4px">
        </div>
    </div>
</div>

<div class="ps-2 pe-2">
  <!-- abs-m-c-table -->
  <table class="tabs-m-c-table">
    <tbody>
      <tr>
        <td class="w-11">
            <?php
                $lmd->invokeModule('doctor.left_menu');
            ?>
        </td>
        <td colspan="7">
          <div class="flexible_frame b-s-2">
          <iframe 
              id="flexible_frame" 
              src="<?php echo $path ?>" 
              width="100%" 
              hspace="0" 
              vspace="0"
          ></iframe>
          <div>
        </td>
      </tr>
    </tbody>
  </table>
  <!-- abs-m-c-table -->
</div>


<script type="text/javascript">
var adj = 148;
$(window).resize(function(){
    $('#flexible_frame').height($(this).height() - adj + 'px');
});
$('#flexible_frame').height($(this).height() - adj + 'px');
</script>

<?php
    $lmd->invokeModule('doctor.foot');
?>
