<?php

$answer_code = $lmd->httpPost('answer_code');
$json = json_encode($lmd->httpPost());
$doctor_id = DocCookie::getUserId();
$outcome = $lmd->httpPost('RECEPT7');    // 診療結果
$diagnosis = $lmd->httpPost('DiagName'); // 診断名
$login_name = DocCookie::getUserName();

$params = array(
    'answer_code' => $answer_code,
    'data' => $json,
    'doctor_id' => $doctor_id,
    'outcome' => $outcome,
    'diagnosis' => $diagnosis,
);

$dao = Factory::load('DB/DAO_outpatient_carte')->getInstance();
$dao->insert($params);
$new_id = $dao->lastInsertId();

{ // update: vital sign
    $dx_flag = NULL;
    if ($lmd->hasHttpPost('RECEPT2')) {
       switch ($lmd->httpPost('RECEPT2')) {
            case '検査あり' :
                $dx_flag = 1;
                break;
            case '検査なし' :
                $dx_flag = 0;
                break;
            default :
        }
    }
    $tx_flag = NULL;
    if ($lmd->hasHttpPost('RECEPT21')) {
       switch ($lmd->httpPost('RECEPT21')) {
            case '処置あり' :
                $tx_flag = 1;
                break;
            case '処置なし' :
                $tx_flag = 0;
                break;
            default :
        }
    }
    $assessment_flag = NULL;
    if ($lmd->hasHttpPost('RECEPT7')) {
       switch ($lmd->httpPost('RECEPT7')) {
            case '帰宅' :
                $assessment_flag = 1;
                break;
            case '処置検査後診察' :
                $assessment_flag = 2;
                break;
            case '入院' :
                $assessment_flag = 3;
                break;
            default :
        }
    }
    $dao = Factory::load('DB/DAO_vital_sign')->getInstance();
    $params = array(
        'body_temperature' => $lmd->httpPost('KARTE270101'), // 体温
        'heart_rate' => $lmd->httpPost('KARTE270201'), // 脈拍
        'respiratory_rate' => $lmd->httpPost('KARTE270301'), // 呼吸数
        'spo2' => $lmd->httpPost('KARTE271101'), // SpO2
        'room_air_flag'          => $lmd->hasHttpPost('KARTE271301_FX1') ? 1 : 0, // room air フラグ
        'o2_flag'                => $lmd->hasHttpPost('KARTE271301_FX2') ? 1 : 0, // OSフラグ
        'o2' => $lmd->httpPost('KARTE271201'), // O2
        'blood_pressure_lr_flag' => $lmd->hasHttpPost('KARTE271001') ? 1 : 0, // 左右別フラグ
        'blood_pressure_low' => $lmd->httpPost('KARTE270401'), // 血圧(低)
        'blood_pressure_high' => $lmd->httpPost('KARTE270501'), // 血圧(高)
        'blood_pressure_l_low' => $lmd->httpPost('KARTE270601'), // 血圧(左)(低)
        'blood_pressure_l_high' => $lmd->httpPost('KARTE270701'), // 血圧(左)(高)
        'blood_pressure_r_low' => $lmd->httpPost('KARTE270801'), // 血圧(左)(低)
        'blood_pressure_r_high' => $lmd->httpPost('KARTE270901'), // 血圧(右)(高)
        'dx_flag' => $dx_flag, // 検査フラグ
        'tx_flag' => $tx_flag, // 処置フラグ
        'assessment_flag' => $assessment_flag, // Assessmentフラグ
        'doctor_id' => DocCookie::getUserId(), 
    );
    $res = $dao->update_BY_answer_code($answer_code, $params);
}

// これは成育用なので目黒用経過XMLは無効にします。
//// {{{ XML...
//$moddate = date('Y/m/d H:i:s');
//$doc = Factory::load('DB/DAO_doctors')->getInstance();
//$pcd = Factory::load('DB/DAO_patient_code')->getInstance();
//$xr = Factory::load('App/XmlRecipe')->getInstance();
//$xp = Factory::load('App/XmlProcess')->getInstance();
//$pat = Factory::load('DB/DAO_xml_partitions')->getInstance();
//$rec = Factory::load('DB/DAO_xml_recipe')->getInstance();
//$pro = Factory::load('DB/DAO_xml_process')->getInstance();
//// 医師情報の取得
//$doctor = $doc->fetch_BY_username($login_name);
//// 患者コードの取得
//list($card_number, $answer_date) = explode('-', $answer_code);
//$tmpdate = sscanf($answer_date, "%04d%02d%02d%02d%02d%02d");
//$ansdate = sprintf("%04d/%02d/%02d %02d:%02d:%02d", $tmpdate[0], $tmpdate[1], $tmpdate[2], $tmpdate[3], $tmpdate[4], $tmpdate[5]);
//list($modymd, $modhis) = explode(' ', $moddate);
//list($ansymd, $anshis) = explode(' ', $ansdate);
//$patient = $pcd->fetchPatientCode($card_number);
//// パーティション確認と作成
//if (! $pat->isThisMonthPartition('xml_recipe')) {
//    $res = $pat->createThisMonthPartition('xml_recipe');
//}
//if (! $pat->isThisMonthPartition('xml_process')) {
//    $res = $pat->createThisMonthPartition('xml_process');
//}
//// {{{ 経過XML...
//// Header
//$header = $xp->parseHeader(
//    '小児科', // 今回「小児科」で固定
//    $doctor['name'],
//    $ansymd,
//    $modymd,
//    '', // コメントは空で固定
//    $patient['patient_code'] // 患者コード
//);
//// INPUTDATA
//$process_xml = $lmd->httpPost('process_xml');
//$input = array(
//            $process_xml[1], // CC,OC
//            $process_xml[2], // PE
//            $process_xml[3], // A/P
//            $process_xml[4], // Recipe/Dx/Tx
//            $doctor['username'],      // 医師名
//            $moddate, // 更新日時
//        );
//$row = $xp->parseRow($input, '564');
//$xp->setHeader($header);
//$xp->setRow($row);
//$fnm = $xp->getFileNameWithPatientDir();
//$xml = $xp->execute();
//$data = array();
//$data['file_name']    = $fnm;
//$data['xml_contents'] = $xml;
//$data['doctor_id']    = $doctor_id;
//$data['card_number']  = $card_number;
//$data['patient_code'] = $patient['patient_code'];
//$pro->insert($data);
//// }}}
//// }}}

$lmd->redirect(APP_ROOT."/doctor_tab/outpatient_carte?answer_code={$answer_code}&oc_id={$new_id}");
