<?php
    $lmd->invokeModule('doctor.head', array(
        'title' => SITE_NAME,
    ));
?>
<script type="text/javascript">
<!--
// {{{ デフォルト値のセット処理...
$(function(){
    defval.exec();
    recipe.direct();
});
// }}}
//-->
</script>

<style>


.tabs {overflow: hidden; width: 62.4rem;}
.tabs .tab-content-1 {  margin-top: 0.2rem; height: 811px;  overflow-y: auto;}
.tabs-ul .nav-item {flex: 0 0 calc(16.72% - 0.2rem);margin-right: 0.2rem;}
.tabs-ul .nav-item:last-child {margin-right: 0;}
.tabs-ul .nav-link, .simple_full span {  font-weight: bold; height:40px; overflow: hidden; color: #FFF;}
.tabs-ul .nav-item .special-item { font-size: 12px; line-height: 1; }
.tabs-ul .active, .simple_full .active{ background-color:#FFC000}

.left-side .left-side-item .left-side-item-con{ background-color: #B4C7E7; color: #25292F}
.impression-left, .impression-middle, .impression-right{  background-color: #B4C7E7;}


.simple_full span { padding : var(--bs-nav-link-padding-y) var(--bs-nav-link-padding-x); cursor: pointer;}
/* .w-11 { width: 11rem; }
.b-s-2 { border: 2px solid #002060; }
.b-c-1 {background-color: #002060; color: #FFF; font-weight:normal;}
.font-12 { font-size: 12px;} */



/* #left-menu { display: none;}
#ctrl-menu { display: none;}  */
</style>
<!--ここからMI加藤手を入れる箇所-->

<style type="text/css">
/* モダンなUIスタイル - 基本設定 */
:root {
  --primary-color: #2c3e50;
  --secondary-color: #3498db;
  --light-bg: #f5f7fa;
  --text-color: #333;
  --border-color: #E3E3E3;
  --border-radius: 4px;
  --box-shadow: 0 2px 5px rgba(0,0,0,0.1);
}

/* 基本フォントスタイル */
body {
  font-family: 'Helvetica Neue', Arial, sans-serif;
  font-size: 14px;
  line-height: 1.6;
  color: var(--text-color);
}

/* カルテコントロールメニュー改善 */
#ctrl-menu {
  z-index: 998;
  position: fixed;
  top: 195px;
  left: 0;
  width: 100%;
  background-color: white;
  /* padding: 10px 0; */
  border-bottom: 1px solid var(--border-color);
  box-shadow: var(--box-shadow);
}

#ctrl-form {
  width: 760px;
  padding: 0;
  margin: 10px 0 5px;
  display: flex;
  justify-content: space-between;
  align-items: center;
}

#ctrl-form td {
  padding: 5px;
}

#ctrl-form select {
  padding: 6px;
  border: 1px solid var(--border-color);
  border-radius: var(--border-radius);
  font-size: 14px;
}
input[type="button"] {
  background: var(--secondary-color);
  color: white;
  border: none;
  border-radius: var(--border-radius);
  padding: 8px 16px;
  cursor: pointer;
  font-size: 14px;
  transition: background-color 0.3s;
}

 input[type="button"]:hover {
  background-color: #2980b9;
}

/* タブナビゲーション改善 */
#area_tab {
  width: 760px;
  margin: 5px 5px 10px;
  background-color: #f5f7fa;
  border-collapse: separate;
  border-spacing: 2px 0;
}

#area_tab td {
  width: 90px;
  text-align: center;
  vertical-align: middle;
  padding: 10px 5px;
  border-radius: var(--border-radius) var(--border-radius) 0 0;
  background: #e4e9f2;
  transition: background-color 0.3s;
}

#area_tab td:hover {
  background: #d1d8e6;
}

#area_tab td a {
  color: var(--primary-color);
  text-decoration: none;
  display: block;
  font-weight: 500;
  font-size: 13px;
}

#area_tab td.selected {
  background: white;
  box-shadow: 0 -2px 5px rgba(0,0,0,0.1);
}

/* カルテエリアの改善 */
.carte_area {
  /* width: 100%;
  font-size: 14px;
  margin-bottom: 20px;
  background: white;
  border-radius: var(--border-radius);
  box-shadow: var(--box-shadow);
  padding: 15px; */
}

.carte_category {
  border: none;
  padding: 0;
  margin: 0 0 15px 0;
}

.carte_category tr td {
  vertical-align: top;
  padding: 5px;
  padding-top:0;
  padding-left:0;
}

.carte_category tr td:nth-child(1) {
  font-weight: bold;
  padding-bottom: 10px;
  color: var(--primary-color);
}

/* カルテアイテム改善 */
.carte_item {
  margin-bottom: 15px;
}

.carte_item tr td:nth-child(1) {
  /*width: 140px;
  text-decoration: underline;*/
  vertical-align: top;
  font-weight: bold;
  color: var(--primary-color);
}

.carte_item label {
  display: inline-block;
  padding: 4px 8px;
  background: #f5f5f5;
  border-radius: 3px;
  margin: 0 4px 4px 0;
  cursor: pointer;
  font-size: 14px;
}

.carte_item label:hover {
  background: #e9e9e9;
}

.carte_item .entry {
  padding: 5px 0;
  padding-top:0;
}

.carte_item input[type="text"], 
.carte_item textarea {
  border: 1px solid #ddd;
  border-radius: var(--border-radius);
  padding: 6px;
  font-size: 14px;
}

.carte_item textarea {
  width: 95%;
}

/* 処方レシピ改善 */
.medicine {
  width: 100%;
  font-size: 14px;
  text-align: left;
  margin-bottom: 15px;
}

.medicine table {
  width: 100%;
  border-collapse: collapse;
}

.medicine th {
  width: 120px;
  text-align: left;
  padding: 8px;
  background: #f5f7fa;
}

.medicine input {
  width: 40px;
  padding: 4px;
  border: 1px solid #ddd;
  border-radius: var(--border-radius);
}

/* ボタン配置の最適化 */
input[type="button"] {
  margin: 5px;
}

/* レスポンシブ対応 */
@media (max-width: 768px) {
  #ctrl-form, 
  #area_tab,
  .carte_area {
    width: 95%;
  }
  
  .carte_item label {
    padding: 6px;
    margin-bottom: 6px;
  }
  
  .carte_item textarea {
    width: 100%;
  }
}
/* タブナビゲーションのスタイル改善 */
#ctl-tab {
width: 754px;
margin:0 auto;
}

#tab td {
  padding: 12px 20px;
  background: var(--light-bg);
  border: none;
  border-radius: var(--border-radius) var(--border-radius) 0 0;
  text-align: center;
  font-size: 14px;
  transition: background-color 0.3s;
}

#tab td:hover {
  background: #e4e9f2;
}

#tab td.selected, 
#tab_exa, 
#tab_exa_edit, 
#tab_carte, 
#tab_treatment, 
#tab_history, 
#tab_card_number_edit {
  background: white;
  box-shadow: 0 -2px 5px rgba(0,0,0,0.1);
}

#tab td a {
  color: var(--primary-color);
  text-decoration: none;
  display: block;
  font-weight: 500;
}

/* 左メニューのスタイル改善 */
#left-menu {
  position: fixed;
  top: 190px;
  left: 0;
  width: 130px;
  background: white;
  border-radius: 0 var(--border-radius) var(--border-radius) 0;
  box-shadow: var(--box-shadow);
  z-index: 97;
}

.left-menu-tbl {
  width: 120px;
  border: none;
  border-radius: var(--border-radius);
  margin: 5px auto;
  background: white;
  overflow: hidden;
}

.left-menu-tbl th {
  padding: 8px;
  background: var(--primary-color);
  color: white;
  font-weight: normal;
  font-size: 13px;
  text-align: center;
  border: none;
}

.left-menu-tbl td {
  padding: 8px;
  background: white;
  border: 1px solid var(--border-color);
  border-top: none;
  font-size: 12px;
  line-height: 1.4;
}

.left-menu-tbl td a {
  color: var(--text-color);
  text-decoration: none;
  display: block;
}

.left-menu-tbl td:hover {
  background: var(--light-bg);
}

#lm_value_s {
  font-size: 12px;
  margin-bottom: 3px;
}

#left-menu a:hover {
  text-decoration: none;
}

/* メインコンテンツのマージン調整 */
#main-wrap, 
#cne_wrap, 
#flexible_frame, 
#ctrl-menu, 
.diagnosis_list {
  margin-left: 140px;
}

/* レスポンシブ対応 */
@media (max-width: 768px) {
  #ctl-tab {
    margin-left: 10px;
  }
  
  #tab td {
    padding: 8px 12px;
    font-size: 13px;
  }
  
  #left-menu {
    width: 100px;
  }
  
  .left-menu-tbl {
    width: 90px;
  }
  
  #main-wrap, 
  #cne_wrap, 
  #flexible_frame, 
  #ctrl-menu, 
  .diagnosis_list {
    margin-left: 110px;
  }
}
/* ヘッダー情報エリアのスタイル改善 */
#info-pad {
  float: left;
  width: 75%;
  background-color: white;
  border-radius: var(--border-radius);
  box-shadow: var(--box-shadow);
  /* margin: 10px 0; */
  padding: 15px;
}

#info-pad table {
  width: 100%;
  border-collapse: collapse;
  margin-bottom: 8px;
  font-size: 14px;
}

#info-pad table:first-child {
  border-bottom: none;
}

#info-pad table th {
  width: 140px;
  background: var(--primary-color);
  color: white;
  padding: 8px;
  text-align: left;
  font-weight: normal;
  border-radius: var(--border-radius) 0 0 var(--border-radius);
}

#info-pad table td {
  padding: 8px;
  border: 1px solid var(--border-color);
  background: var(--light-bg);
}

/* バイタルサインの値を強調 */
#info-pad table td:not(:first-child) {
  font-weight: bold;
  color: var(--primary-color);
}

/* レスポンシブ対応 */
@media (max-width: 768px) {
  #info-pad {
    width: 95%;
    margin: 10px auto;
  }
  
  #info-pad table {
    font-size: 13px;
  }
  
  #info-pad table th {
    width: 100px;
  }
  
}
#left-menu {
    top: 190px !important; 
}

#spacer4ctl-pad {
    height: 180px !important;
}

#list_btn, #logout{
  background-color: var(--secondary-color);
  color: white;
  border: none;
  border-radius: var(--border-radius);
  /* padding: 8px 15px; */
  cursor: pointer;
  font-size: 14px;
  transition: background-color 0.3s;
}

#logout {
  margin-bottom: 16px;
}
.carte_item label input[type="radio"], .carte_item label input[type="checkbox"] {
    display: none;
}


</style>

<div style="padding: 0.2rem;">
    <div class="clearfix ps-2 pe-2">
        <div class="float-start w-50">
            <div class="row container dt-nav">
                <div class="col-md-2 float-start ps-0 pe-1 w-59">
                    <a class="rounded text-nowrap <?=$lmd->isMainModule('doctor_tab.exa') ? "active" : "" ?>" href="<?php echo APP_ROOT ?>/doctor_tab/exa?answer_code=<?php echo $_answer_code ?>">予診票</a>
                </div>
                <?php if(_isRoleDoctor()): ?>
                    <div class="col-md-2 float-start ps-0 pe-1 w-59">
                    <a class="rounded text-nowrap <?=$lmd->isMainModule('doctor_tab.monshin') ? "active" : "" ?>" href="<?php echo APP_ROOT ?>/doctor_tab/monshin?answer_id=<?php echo $answer_id ?>&answer_code=<?php echo $_answer_code ?>">修正</a>
                    </div>
                <?php endif; ?>
                <div class="col-md-2 float-start ps-0 pe-1 w-59">
                    <a class="rounded text-nowrap <?=$lmd->isMainModule('doctor_tab.outpatient_carte') ? "active" : "" ?>" href="<?php echo APP_ROOT ?>/doctor_tab/outpatient_carte?answer_code=<?php echo $_answer_code ?>">外来カルテ</a>
                </div>
                <?php if (_isChild()) : ?>
                    <div class="col-md-2 float-start ps-0 pe-1 w-59">
                        <a class="rounded text-nowrap <?=$lmd->isMainModule('doctor_tab.treatment') ? "active" : "" ?>" href="<?php echo APP_ROOT ?>/doctor_tab/treatment?answer_id=<?php echo $answer_id ?>&answer_code=<?php echo $_answer_code ?>">患者説明</a>
                    </div>
                <?php endif; ?>
                <?php if(_isRoleDoctor()): ?>
                    <div class="col-md-4 float-start ps-0 pe-1 w-118">
                        <a class="rounded text-nowrap <?=$lmd->isMainModule('doctor_tab.card_number_edits') ? "active" : "" ?>" href="<?php echo APP_ROOT ?>/doctor_tab/card_number_edit?answer_code=<?php echo $_answer_code ?>">診察券番号修正</a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="float-end d-flex align-items-center" style="height:46.4px">
            <table  border="0">
                <tr>
                    <td>
                        <b>【入力履歴】</b>
                    </td>
                    <td>
                        <?php
                            $url = APP_ROOT."/doctor_tab/outpatient_carte?answer_code={$_answer_code}";

                            $fe = Factory::load('FormElement')->getInstance($historys);
                            if ($oc_id) {
                                $fe->setDefault($oc_id);
                            } elseif ($historys) {
                                $fe->setDefault(max(array_keys($historys)));
                            }
                            $fe->setFirst('-', '-----');
                            $fe->select('history', array('onchange' => "location.href='".$url."&oc_id='+this.value", 'class' => 'form-select'));
                        ?>
                    </td>
                    <td align="right">
                        <div>
                        <?php if(_isRoleDoctor()): ?>
                        <input class="mt-0 mb-0" type="button" name="button11" value="　保　存　" onClick="_form_submit();" />
                        &nbsp;
                        <input class="mt-0 mb-0 me-0" type="button" name="button13" value="　リセット　" onclick="location.href='<?php echo $url ?>&oc_id=-'" />
                        <?php endif; ?>
                        </div>
                    </td>
                </tr>
            </table>
        </div>
    </div>
</div>


<div class="ps-2 pe-2">
  <table class="tabs-m-c-table">
    <tbody>
      <tr>
        <td class="w-11">
            <?php
                $lmd->invokeModule('doctor.left_menu');
            ?>
        </td>
        <td colspan="7">
            <div class="tabs">
                <!-- タブメニュー -->
                <ul class="tabs-ul nav d-flex m-0 p-0 w-100 flex-nowrap">
                    <li class="nav-item b-s-2">
                        <button class="nav-link w-100 b-c-1 area_tab_cell" area="1" data-bs-toggle="tab"  >CC・OC</button>
                    </li>
                    <li class="nav-item b-s-2">
                        <button class="nav-link w-100 b-c-1 area_tab_cell" area="3" data-bs-toggle="tab"  >PE</button>
                    </li>
                    <li class="nav-item b-s-2">
                        <button class="nav-link w-100 b-c-1 area_tab_cell" area="5" data-bs-toggle="tab" >L/D</button>
                    </li>
                    <li class="nav-item b-s-2">
                        <button class="nav-link w-100 b-c-1 area_tab_cell" area="4" data-bs-toggle="tab" >A/P</button>
                    </li>
                    <li class="nav-item b-s-2">
                        <button class="nav-link w-100 b-c-1 special-item area_tab_cell" area="31" data-bs-toggle="tab" ><span class="d-block">Data Vision</span><span class="d-block">⇔DDx</span></button>
                    </li>
                    <li class="nav-item b-s-2">
                        <button class="nav-link w-100 b-c-1 special-item active area_tab_cell" area="simple" data-bs-toggle="tab" ><span class="d-block">Simple/Full</span><span class="d-block">comment</span></button>
                    </li>
                </ul>

                <!-- タブコンテンツ -->
                 
                <div class="tab-content tab-content-1 b-s-2 p-2">
                    <form name="_form" method="post" action="<?php echo APP_ROOT ?>/doctor_tab/outpatient_carte/exec">
                        <input type="hidden" name="answer_code" value="<?php echo $_answer_code ?>" />
                        <input type="hidden" name="process_xml[1]" id="process_xml_1" value="" />
                        <input type="hidden" name="process_xml[2]" id="process_xml_2" value="" />
                        <input type="hidden" name="process_xml[3]" id="process_xml_3" value="" />
                        <input type="hidden" name="process_xml[4]" id="process_xml_4" value="" />
                        <div class="tab-pane fade show active" >
                            <?php $lmd->invokeModule('doctor_tab.outpatient_tabs'); ?>
                        </div>
                    </form>
                </div>
            </div>
        </td>
      </tr>
    </tbody>
  </table>
</div>







<script type="text/javascript">
<!--

// {{{ ページ上段：領域の表示/非表示 コントロール
$(function(){
    $('.area_tab_cell').click(function(){
        $('.display_area').hide();
        // $('.area_tab_cell').css('background-color', '#ccc');
        // $(this).css('background-color', '#98fb98');
        var area = $(this).attr('area');
        if(area == 4 ) {
            $('#display_4').show();
            $('#display_5').show();
        }else if (area == 31) {
            $('#display_31').show();
        }else if (area > 0) {
            $('#display_' + area).show();
        } else if (area === 'simple') {
            $('.simple_full .area_tab_cell').removeClass('active').attr('aria-selected', 'false');
            $('.simple_full .area_tab_cell').first().addClass('active').attr('aria-selected', 'true');

            $('#display_0').show();
            $('#display_1').show();
            $('#display_3').show();
            $('#display_31').show();
            $('#display_4').show();
            $('#display_5').show();
        } else if (area === 'full') {
            $('.display_area').show();
        } else if (area === 'coment') {
            $('#display_0').show();
            $('#display_6').show();
        } 

        // URLバー非表示
        window.scrollTo(0, 0);
        window.scrollTo(0, 1);
    });
});
// }}}

// {{{ ライブラリ関数...
String.prototype.trim = function() {
    return this.replace(/^[\s　]+|[\s　]+$/g, '');
}

function checkedcheckbox()
{
    $('input:checkbox').each(function(){
        if ($(this).attr('checked')) {
            var color = 'blue'; // 基本ラベル色
            if ($(this).attr('name').match(/_MedicineName$/)) {
                // レシピの場合...
                var name = $(this).attr('name').replace('_MedicineName', '_WeightZone');
                if ($('input[name="' + name + '"]').attr('def') == 'no') {
                    // デフォルト値が存在しない(def="no")の場合はラベルを赤にする...
                    color = 'red';
                }
            }
            $(this).parent().css({'color':color,'font-weight':'bold'});
        } else {
            $(this).parent().css({'color':'#000000','font-weight':'normal'});
        }
    });

    <?php if(Device::isIos()): ?>
        // iOS で label for を有効にする
        label4iOS();
    <?php endif; ?>
}

function checkedradio()
{
    $('input:radio').each(function(){
        if ($(this).attr('checked')) {
            $(this).parent().css({'color':'#0000ff','font-weight':'bold'});
        } else {
            $(this).parent().css({'color':'#000000','font-weight':'normal'});
        }
    });

    <?php if(Device::isIos()): ?>
        // iOS で label for を有効にする
        label4iOS();
    <?php endif; ?>
}

function displaycomment()
{
    //$('input[name^="PHADDTEXT"],.carte_item input[name^="PEADDTEXT"],.carte_item input[name^="expe_add_"]').each(function(){
    $('input[name^="PHADDTEXT"],.carte_item input[name^="PEADDTEXT"]').each(function(){
        var ent = getparentcarteitemobject($(this));
        var cmt = ent.find('table.comment');
        if ($(this).attr('checked')) {
            cmt.css({'display':'inline'});
        } else {
            cmt.css({'display':'none'});
        }
    });
}

function displaytextarea()
{
    $('input[name^="DXDIFFADDTEXT"]').each(function(){
        var ent = getparentcarteitemobject($(this));
        var txt = ent.find('.entry > *');
        if ($(this).attr('checked')) {
            txt.css({'display':'inline'});
        } else {
            txt.css({'display':'none'});
        }
    });
}

function clearentry(obj)
{
    var ent = getparentcarteitemobject(obj).find('[class="entry"]');
    var radio = ent.find('input[type="radio"]');
    var check = ent.find('input[type="checkbox"]');
    var text  = ent.find('input[type="text"]');
    var area  = ent.find('textarea');
    radio.each(function(){
        $(this).attr('checked',false);
        $(this).parent().css({'color':'#000000','font-weight':'normal'});
    });
    check.each(function(){
        $(this).attr('checked',false);
        $(this).parent().css({'color':'#000000','font-weight':'normal'});
    });
    text.each(function(){
        $(this).val('');
    });
    area.each(function(){
        $(this).text('');
    });
}

function getparentcarteitemobject(obj)
{
    var max = 10;
    var cnt = 0;
    var ent = obj.parent();
    while (ent.attr('class') != 'carte_item') {
        var ent = ent.parent();
        cnt++;
        if (max < cnt) {
            return false;
        }
    }
    return ent;
}

function inentry(obj)
{
    var result = false;
    var max = 10;
    var cnt = 0;
    var ent = obj.parent();
    while (ent.attr('class') != 'carte_item') {
        if (ent.attr('class') == 'entry') {
            result = true;
            break;
        }
        var ent = ent.parent();
        cnt++;
        if (max < cnt) {
            break;
        }
    }
    return result;
}

function toggle_KARTE271001()
{
    var both = $('span[id="LABEL271002"]');
    var diff = $('span[id="LABEL271003"]');
    $('.carte_item .entry input[name="KARTE271001"]').each(function(){
        if ($(this).attr('checked')) {
            both.css({'display':'none'});
            diff.css({'display':'inline'});
        } else {
            both.css({'display':'inline'});
            diff.css({'display':'none'});
        }
    });
}

function toggle_SYMPSUB9990()
{
    $('.carte_item .entry input[name="SYMPSUB9990"]').each(function(){
        if ($(this).attr('checked')) {
            $('#table027_03').hide();
        } else {
            $('#table027_03').show();
        }
    });
}

function toggle_RECEPT1()
{
    $('input[name="RECEPT1"]').each(function(){
        var obj = getparentcarteitemobject($(this));
        var div = obj.find('td.entry > div');
        if ($(this).attr('id') == 'INPUT23' && $(this).attr('checked')) {
            div.show();
        }
        if ($(this).attr('id') == 'INPUT24' && $(this).attr('checked')) {
            div.hide();
        }
    });
}

function toggle_RECEPT21()
{
    $('.carte_item .entry input[name="RECEPT21"]').each(function(){
        var obj = getparentcarteitemobject($(this));
        var tbl = obj.find('td.entry > table');
        if ($(this).attr('id') == 'INPUT25' && $(this).attr('checked')) {
            tbl.show();
        }
        if ($(this).attr('id') == 'INPUT26' && $(this).attr('checked')) {
            tbl.hide();
        }
    });
    toggle_2nd_assessment_and_plan();
}

function toggle_RECEPT2()
{
    $('.carte_item .entry input[name="RECEPT2"]').each(function(){
        var obj = getparentcarteitemobject($(this));
        var tbl = obj.find('td.entry > table');
        var br = obj.find('td.entry > br');
        if ($(this).attr('id') == 'INPUT21' && $(this).attr('checked')) {
            tbl.show();
            br.show();
        }
        if ($(this).attr('id') == 'INPUT22' && $(this).attr('checked')) {
            tbl.hide();
            br.hide();
            $('#laboratory_data_title,#laboratory_data_item').hide();
        }
    });
    toggle_laboratory_data();
    toggle_2nd_assessment_and_plan();
}

function toggle_laboratory_data()
{
    if ($('#INPUT21').attr('checked')) {
        $('#laboratory_data_title,#laboratory_data_item').show();
    } else {
        $('#laboratory_data_title,#laboratory_data_item').hide();
    }
}

function toggle_2nd_assessment_and_plan()
{
    if ($('#INPUT21').attr('checked') || $('#INPUT25').attr('checked')) {
        $('#second_assess_plan_title,#second_assess_plan_item').show();
    } else {
        $('#second_assess_plan_title,#second_assess_plan_item').hide();
    }
}

function toggle_RECEPT7()
{
    $('.carte_item .entry input[name="RECEPT7"]').each(function(){
        var dia = $('#diagnostic_plan').find('td.entry > table');
        var dia_br = $('#diagnostic_plan').find('td.entry > br');
        var thr = $('#therapeutic_plan').find('td.entry > table');
        var lab = $('#laboratory_data').find('td.entry > table');
        var sec = $('#second_assessment').find('td.entry > label');
        var sec_br = $('#second_assessment').find('td.entry > br');
        var sec_tbl = $('#second_assessment').find('td.entry > table');
        var inf = $('#informed_consent').find('td.entry > table');
        var ap_save = $('#ap_copy_save');
        var ic_save = $('#laboic_copy_save');
        if ($(this).attr('id') == 'INPUT71' && $(this).attr('checked')) {
            // 帰宅を選択...
            dia.hide(); $('#INPUT21').attr('checked', false); $('#INPUT22').attr('checked', true);
            dia_br.hide();
            thr.hide(); $('#INPUT25').attr('checked', false); $('#INPUT26').attr('checked', true);
            lab.hide(); $('#INPUT9901').attr('checked', false); $('#INPUT9902').attr('checked', true);
            inf.show(); $('#INPUT9903').attr('checked', true); $('#INPUT9904').attr('checked', false);
            sec.hide();
            sec_br.hide();
            sec_tbl.hide();
            ap_save.hide();
            ic_save.hide();
            recipe.move(1);
        }
        if ($(this).attr('id') == 'INPUT72' && $(this).attr('checked')) {
            // 処置検査後診察を選択...
            dia.show(); $('#INPUT21').attr('checked', true); $('#INPUT22').attr('checked', false);
            dia_br.show();
            thr.show(); $('#INPUT25').attr('checked', true); $('#INPUT26').attr('checked', false);
            lab.hide(); $('#INPUT9901').attr('checked', false); $('#INPUT9902').attr('checked', true);
            inf.show(); $('#INPUT9903').attr('checked', true); $('#INPUT9904').attr('checked', false);
            sec.hide();
            sec_br.hide();
            sec_tbl.show();
            ap_save.show();
            ic_save.show();
            recipe.move(2);
        }
        if ($(this).attr('id') == 'INPUT73' && $(this).attr('checked')) {
            // 入院を選択...
            dia.hide(); $('#INPUT21').attr('checked', false); $('#INPUT22').attr('checked', true);
            dia_br.hide();
            thr.hide(); $('#INPUT25').attr('checked', false); $('#INPUT26').attr('checked', true);
            lab.hide(); $('#INPUT9901').attr('checked', false); $('#INPUT9902').attr('checked', true);
            inf.show(); $('#INPUT9903').attr('checked', true); $('#INPUT9904').attr('checked', false);
            sec.show();
            sec_br.show();
            sec_tbl.show();
            ap_save.hide();
            ic_save.hide();
            recipe.move(1);
        }
        if ($(this).attr('id') == 'INPUT72' && ! $(this).attr('checked')) {
            $('#recipe_1').show(); $('#INPUT23').attr('checked', true); $('#INPUT24').attr('checked', false);
            $('#recipe_2').hide();
        }
        if ($(this).attr('id') == 'INPUT72' && $(this).attr('checked')) {
            $('#recipe_1').hide();
            $('#recipe_2').show(); $('#INPUT23_D2').attr('checked', true); $('#INPUT24_D2').attr('checked', false);
        }
    });
    toggle_laboratory_data();
    toggle_2nd_assessment_and_plan();
    checkedradio();
}

function toggle_RECEPT9901()
{
    $('.carte_item .entry input[name="RECEPT9901"]').each(function(){
        var obj = getparentcarteitemobject($(this));
        var tbl = obj.find('td.entry > table');
        var br = obj.find('td.entry > br');
        if ($(this).attr('id') == 'INPUT9901' && $(this).attr('checked')) {
            tbl.show();
            br.show();
        }
        if ($(this).attr('id') == 'INPUT9902' && $(this).attr('checked')) {
            tbl.hide();
            br.hide();
        }
    });
}

function toggle_RECEPT9903()
{
    $('.carte_item .entry input[name="RECEPT9903"]').each(function(){
        var obj = getparentcarteitemobject($(this));
        var tbl = obj.find('td.entry > table');
        var br = obj.find('td.entry > br');
        if ($(this).attr('id') == 'INPUT9903' && $(this).attr('checked')) {
            tbl.show();
            br.show();
        }
        if ($(this).attr('id') == 'INPUT9904' && $(this).attr('checked')) {
            tbl.hide();
            br.hide();
        }
    });
}

function toggle_mtype()
{
    $('table.medicine th input[name^="medicine_type_"]').each(function(){
        var obj = $(this).parent().parent().next();
        var tbl = obj.find('table');
        var hr = obj.find('hr');
        if ($(this).attr('checked')) {
            tbl.show();
            hr.show();
        } else {
            tbl.hide();
            hr.hide();
        }
    });
}

function toggle_medicine()
{
    $('table.medicine td table th input[name^="medicine_value_"]').each(function(){
        var obj = $(this).parent().parent().parent();
        var tr = obj.find('td');
        if ($(this).attr('checked')) {
            tr.show();
        } else {
            tr.hide();
        }
    });
}

function displayitem(obj)
{
    if (inentry(obj)) {
        // class="entry"内のcheckboxでは無視する。
        return;
    }
    //if (obj.attr('name').match(/PEADDTEXT|PHADDTEXT|expe_add_|DXDIFFADDTEXT/)) {
    if (obj.attr('name').match(/PEADDTEXT|PHADDTEXT|DXDIFFADDTEXT/)) {
        // class="comment"を操作するチェックボックスは無視する。
        return;
    }
    var item = getparentcarteitemobject(obj);
    if (obj.attr('checked')) {
        item.find('td:nth-child(2),td:nth-child(3),td:nth-child(4)').show();
        item.find('tr:nth-child(2)').show();
        obj.parent().css({'color':'#0000ff','font-weight':'bold'});
    } else {
        item.find('td:nth-child(2),td:nth-child(3),td:nth-child(4)').hide();
        item.find('tr:nth-child(2)').hide();
        obj.parent().css({'color':'#000000','font-weight':'normal'});
    }
}

function showallarea3()
{
    //$('#area_3 table[id^=item_],#area_3 table[id^=expe_item_]').show();
    $('#area_3 table[id^=item_]').show();
}

function showallarea3forchecked()
{
    //$('#area_3 table[id^=item_],#area_3 table[id^=expe_item_]').each(function(){
    $('#area_3 table[id^=item_]').each(function(){
        if ($(this).find('input:first-child').attr('checked')) {
            $(this).show();
        }
    });
}
function hideallarea3fornochecked()
{
    //$('#area_3 table[id^=item_],#area_3 table[id^=expe_item_]').each(function(){
    $('#area_3 table[id^=item_]').each(function(){
        if (! $(this).find('input:first-child').attr('checked')) {
            $(this).hide();
        }
    });
}

function toggle_KARTE280401()
{
    var weight = $('input[name="KARTE280101"]').val();
    if (weight < 1000) {
        $('#INPUT280401').attr('checked', true);
        $('#INPUT280402').attr('checked', false);
    } else {
        $('#INPUT280401').attr('checked', false);
        $('#INPUT280402').attr('checked', true);
    }
    checkedradio();
}

// 【 Diagnosis 】プルダウンで「その他」を選択した場合、テキストエリアを表示する
function toggle_diagnosis_textarea()
{
    if ($("[name='diag_list']").val() == '999') { // 999: その他
        $('#diagnosis_textarea').show();
    } else {
        $('#diagnosis_textarea').hide();
    }
}
// }}}

// {{{ イベント監視...
$(function(){
    $('.carte_item input[type="checkbox"]').click(function(){
        checkedcheckbox();
    });

    $('.carte_item input[type="radio"]').click(function(){
        checkedradio();
    });

    //$('.carte_item input[name^="PHADDTEXT"],.carte_item input[name^="PEADDTEXT"],.carte_item input[name^="expe_add_"]').click(function(){
    $('.carte_item input[name^="PHADDTEXT"],.carte_item input[name^="PEADDTEXT"]').click(function(){
        displaycomment();
    });

    $('.carte_item input[name^="DXDIFFADDTEXT"]').click(function(){
        displaytextarea();
    });

    $('.carte_item a[class="clear_entry"]').click(function(){
        clearentry($(this));
    });

    $('.carte_item .entry input[name="KARTE271001"]').click(function(){
        toggle_KARTE271001();
    });

    $('#area_3 .carte_item input:checkbox').click(function(){
        displayitem($(this));
    });

    $('.carte_item .entry input[name="SYMPSUB9990"]').click(function(){
        toggle_SYMPSUB9990();
    });

    $('.carte_item .entry input[name="RECEPT21"]').click(function(){
        toggle_RECEPT21();
    });

    $('.carte_item .entry input[name="RECEPT2"]').click(function(){
        toggle_RECEPT2();
    });

    $('.carte_item .entry input[name="RECEPT1"]').click(function(){
        toggle_RECEPT1();
    });

    $('.carte_item .entry input[name="RECEPT7"]').click(function(){
        toggle_RECEPT7();
    });

    $('.carte_item .entry input[name="RECEPT9901"]').click(function(){
        toggle_RECEPT9901();
    });

    $('.carte_item .entry input[name="RECEPT9903"]').click(function(){
        toggle_RECEPT9903();
    });
});
// }}}

// {{{ DiagnosticPlan指定値によるLaboratoryDataのテキスト作成
function strlabodef(){
var strINTEXT24;
  strINTEXT24="";

  //末血
  if($('input[name="RECEPT31"]').attr('checked')){strINTEXT24=strINTEXT24+"CBC\r\n\r\n"}

  //生化
  if($('input[name="RECEPT32"]').attr('checked')){strINTEXT24=strINTEXT24+"Chem\r\n\r\n"}

  //血ガス
  if($('input[name="RECEPT35"]').attr('checked')){strINTEXT24=strINTEXT24+"BGA\r\n\r\n"}

  //外注 凝固 赤沈 その他 Glu
  if($('input[name="RECEPT33"]').attr('checked') || $('input[name="RECEPT34"]').attr('checked') || $('input[name="RECEPT36"]').attr('checked') || $('input[name="RECEPT37"]').attr('checked') || $('input[name="RECEPT38"]').attr('checked')){
    strINTEXT24=strINTEXT24+"外注 凝固 赤沈 その他\r\n"
    strINTEXT24=strINTEXT24+"\r\n"
  }

  //検尿・・・RECEPT4
  if($('input[name="RECEPT41"]').attr('checked') || $('input[name="RECEPT42"]').attr('checked') || $('input[name="RECEPT43"]').attr('checked')){
    strINTEXT24=strINTEXT24+"U/A\r\n"
    strINTEXT24=strINTEXT24+"\r\n"
  }

  //培養・・・RECEPT5
  if($('input[name="RECEPT51"]').attr('checked') || $('input[name="RECEPT52"]').attr('checked') || $('input[name="RECEPT53"]').attr('checked') || $('input[name="RECEPT54"]').attr('checked') || $('input[name="RECEPT55"]').attr('checked') || $('input[name="RECEPT56"]').attr('checked') || $('input[name="RECEPT57"]').attr('checked') || $('input[name="RECEPT58"]').attr('checked') || $('input[name="RECEPT59"]').attr('checked')){
    strINTEXT24=strINTEXT24+"培養：　"
    if($('input[name="RECEPT52"]').attr('checked')){strINTEXT24=strINTEXT24+"咽頭，"}
    if($('input[name="RECEPT53"]').attr('checked')){strINTEXT24=strINTEXT24+"鼻腔，"}
    if($('input[name="RECEPT54"]').attr('checked')){strINTEXT24=strINTEXT24+"便，"}
    if($('input[name="RECEPT51"]').attr('checked')){strINTEXT24=strINTEXT24+"血液，"}
    if($('input[name="RECEPT58"]').attr('checked')){strINTEXT24=strINTEXT24+"髄液，"}
    if($('input[name="RECEPT55"]').attr('checked')){strINTEXT24=strINTEXT24+"導尿，"}
    if($('input[name="RECEPT56"]').attr('checked')){strINTEXT24=strINTEXT24+"中間尿，"}
    if($('input[name="RECEPT57"]').attr('checked')){strINTEXT24=strINTEXT24+"パック尿，"}
    if($('input[name="RECEPT59"]').attr('checked')){strINTEXT24=strINTEXT24+"その他"}
    strINTEXT24=strINTEXT24+"\r\n\r\n"
  }

  //一般・・・RECEPT6
  if($('input[name="RECEPT61"]').attr('checked') || $('input[name="RECEPT62"]').attr('checked') || $('input[name="RECEPT63"]').attr('checked') || $('input[name="RECEPT64"]').attr('checked') || $('input[name="RECEPT65"]').attr('checked') || $('input[name="RECEPT66"]').attr('checked') || $('input[name="RECEPT67"]').attr('checked')){
    strINTEXT24=strINTEXT24+"一般："
    if($('input[name="RECEPT61"]').attr('checked')){strINTEXT24=strINTEXT24+"　インフル ＋－，"}
    if($('input[name="RECEPT62"]').attr('checked')){strINTEXT24=strINTEXT24+"　アデノ ＋－，"}
    if($('input[name="RECEPT63"]').attr('checked')){strINTEXT24=strINTEXT24+"　RS ＋－，"}
    if($('input[name="RECEPT67"]').attr('checked')){strINTEXT24=strINTEXT24+"　溶連菌 ＋－，"}
    if($('input[name="RECEPT64"]').attr('checked')){strINTEXT24=strINTEXT24+"　便ロタ ＋－，"}
    if($('input[name="RECEPT65"]').attr('checked')){strINTEXT24=strINTEXT24+"　便アデノ ＋－，"}
    if($('input[name="RECEPT66"]').attr('checked')){strINTEXT24=strINTEXT24+"　便潜血 ＋－，"}
    strINTEXT24=strINTEXT24+"\r\n\r\n"
  }

  //髄液・・・RECEPT18
  if($('input[name="RECEPT181"]').attr('checked') || $('input[name="RECEPT182"]').attr('checked') || $('input[name="RECEPT183"]').attr('checked') || $('input[name="RECEPT184"]').attr('checked')){
    strINTEXT24=strINTEXT24+"髄液： \r\n"
    strINTEXT24=strINTEXT24+"\r\n"
  }

  //Xp・・・RECEPT10
  if($('input[name="RECEPT1001"]').attr('checked') || $('input[name="RECEPT1002"]').attr('checked') || $('input[name="RECEPT1003"]').attr('checked') || $('input[name="RECEPT1004"]').attr('checked')){
    strINTEXT24=strINTEXT24+"Xp\r\n"
    if($('input[name="RECEPT1001"]').attr('checked')){strINTEXT24=strINTEXT24+"　副鼻腔： 特記すべき異常所見なし\r\n"}
    if($('input[name="RECEPT1002"]').attr('checked')){strINTEXT24=strINTEXT24+"　胸部： 特記すべき異常所見なし\r\n"}
    if($('input[name="RECEPT1003"]').attr('checked')){strINTEXT24=strINTEXT24+"　腹部： 特記すべき異常所見なし\r\n"}
    if($('input[name="RECEPT1004"]').attr('checked')){strINTEXT24=strINTEXT24+"　その他： 特記すべき異常所見なし\r\n"}
    strINTEXT24=strINTEXT24+"\r\n"
  }

  //CT・・・RECEPT10
  if($('input[name="RECEPT1005"]').attr('checked') || $('input[name="RECEPT1006"]').attr('checked') || $('input[name="RECEPT1007"]').attr('checked') || $('input[name="RECEPT1008"]').attr('checked')){
    strINTEXT24=strINTEXT24+"CT\r\n"
    if($('input[name="RECEPT1005"]').attr('checked')){strINTEXT24=strINTEXT24+"　頭部： 特記すべき異常所見なし\r\n"}
    if($('input[name="RECEPT1006"]').attr('checked')){strINTEXT24=strINTEXT24+"　胸部： 特記すべき異常所見なし\r\n"}
    if($('input[name="RECEPT1007"]').attr('checked')){strINTEXT24=strINTEXT24+"　腹部： 特記すべき異常所見なし\r\n"}
    if($('input[name="RECEPT1008"]').attr('checked')){strINTEXT24=strINTEXT24+"　その他： 特記すべき異常所見なし\r\n"}
    strINTEXT24=strINTEXT24+"\r\n"
  }

  //MRI・・・RECEPT10
  if($('input[name="RECEPT1009"]').attr('checked') || $('input[name="RECEPT1010"]').attr('checked') || $('input[name="RECEPT1011"]').attr('checked') || $('input[name="RECEPT1012"]').attr('checked')){
    strINTEXT24=strINTEXT24+"MRI\r\n"
    if($('input[name="RECEPT1009"]').attr('checked')){strINTEXT24=strINTEXT24+"　頭部： 特記すべき異常所見なし\r\n"}
    if($('input[name="RECEPT1010"]').attr('checked')){strINTEXT24=strINTEXT24+"　胸部： 特記すべき異常所見なし\r\n"}
    if($('input[name="RECEPT1011"]').attr('checked')){strINTEXT24=strINTEXT24+"　腹部： 特記すべき異常所見なし\r\n"}
    if($('input[name="RECEPT1012"]').attr('checked')){strINTEXT24=strINTEXT24+"　その他： 特記すべき異常所見なし\r\n"}
    strINTEXT24=strINTEXT24+"\r\n"
  }

  //エコー・・・RECEPT10
  if($('input[name="RECEPT1013"]').attr('checked') || $('input[name="RECEPT1014"]').attr('checked') || $('input[name="RECEPT1015"]').attr('checked') || $('input[name="RECEPT1016"]').attr('checked') || $('input[name="RECEPT1017"]').attr('checked')){
    strINTEXT24=strINTEXT24+"エコー\r\n"
    if($('input[name="RECEPT1013"]').attr('checked')){strINTEXT24=strINTEXT24+"　心臓： 特記すべき異常所見なし\r\n"}
    if($('input[name="RECEPT1014"]').attr('checked')){strINTEXT24=strINTEXT24+"　腹部： 特記すべき異常所見なし\r\n"}
    if($('input[name="RECEPT1015"]').attr('checked')){strINTEXT24=strINTEXT24+"　頚部： 特記すべき異常所見なし\r\n"}
    if($('input[name="RECEPT1016"]').attr('checked')){strINTEXT24=strINTEXT24+"　腎： 特記すべき異常所見なし\r\n"}
    if($('input[name="RECEPT1017"]').attr('checked')){strINTEXT24=strINTEXT24+"　その他： 特記すべき異常所見なし\r\n"}
    strINTEXT24=strINTEXT24+"\r\n"
  }

  //心電図・・・RECEPT81
  if($('input[name="RECEPT81"]').attr('checked')){strINTEXT24=strINTEXT24+"心電図： 特記すべき異常所見なし\r\n\r\n"}
  //脳波・・・RECEPT82
  if($('input[name="RECEPT82"]').attr('checked')){strINTEXT24=strINTEXT24+"脳波： 特記すべき異常所見なし\r\n\r\n"}
  //ODtest・・・RECEPT83
  if($('input[name="RECEPT83"]').attr('checked')){strINTEXT24=strINTEXT24+"ODtest： 特記すべき異常所見なし\r\n\r\n"}



    $('textarea[name="TEXT24"]').val(strINTEXT24);
  //document.Write.TEXT24.value=strINTEXT24;

}
// }}}

// {{{ デフォルト値のセットクラス...
var defval = {
    json: <?php echo $json ?>,
    setval: function(name, data) {
        var target = $("[name='" + name + "']");
        switch (target.attr('type')) {
            case 'hidden':
            case 'text':
            case 'textarea':
                target.val(data);
                break;

            case 'checkbox':
                target.attr('checked', true);
                break;

            case 'radio':
                target.each(function(){
                    if ($(this).val() == data) {
                        $(this).val(data).attr('checked', true);
                        return;
                    }
                });
                break;

            case 'select':
            case 'select-one':
                target.val(data);
                break;
        }
    },
    exec: function() {
        for (var i in defval.json) {
            defval.setval(i, defval.json[i]);
        }

        var visible_items = <?php echo json_encode($visible_items, JSON_UNESCAPED_UNICODE); ?>;
        for (i in visible_items) {
            $('#item_'+visible_items[i]).show();
            $('#item_'+visible_items[i]+' tr:first td:first :checkbox').attr('checked', true);
        }

        toggle_KARTE271001(); // Toggle Vital signs 左右別
        toggle_SYMPSUB9990(); // Toggle Neurological findings CNS
        toggle_RECEPT21(); // Toggle Therapeutic Plan
        toggle_RECEPT2();  // Toggle Diagnostic Plan
        toggle_RECEPT1();  // Toggle Recipe id="recipe_1" id="recipe_2"
        toggle_RECEPT7();  // Toggle Outcome
        toggle_RECEPT9901();  // Toggle Laboratory Data
        toggle_RECEPT9903();  // Toggle Informed Consent

        $('#area_3 .carte_item input:checkbox').each(function(){
            displayitem($(this));
        });

        checkedcheckbox();
        checkedradio();
        displaycomment();
        displaytextarea();
        showallarea3forchecked();
    }
};

// }}}

// {{{ 処方薬レシピの取得クラス...
var recipe = {

    // レシピDOM作成
    createYoho: function(g, kind_id, usage_num) {
        var html = '';
        // 用法
        html += '<br />';
        html += '<table width="100%">';
        html += '<tr>';
        html += '<td style="width: 5%">';
        html += this.direct_name[kind_id] + '';
        html += '</td>';
        html += '<td style="width: 95%">';
        html += '<input type="hidden" name="' + g + '_OrderType" value="' + this.direct_name[kind_id] + '" />';
        // 用法:SANYO用法マスタ
        if (this.direction != '') {
            var tmp = '';
            tmp = this.direction[kind_id].replace('__code__', g + '_AdminCode');
            tmp = tmp.replace(/__usage__/g, g + '_AdminUsage');
            var def = this.direct_def[kind_id][usage_num];
            tmp = tmp.replace('"' + def + '">', '"' + def + '" selected="selected">');
            if (kind_id == 1) {
                tmp += '&nbsp;&nbsp;';
                tmp += '<label for="for_'+g+'_ParentCheck">';
                tmp += '<input type="checkbox" id="for_'+g+'_ParentCheck" name="' + g + '_ParentCheck" value="※家族の同意のもと使用" />';
                tmp += '※家族の同意のもと使用';
                tmp += '</label>';
            }
            html += tmp + '<br />';
        }
        // 用法:数量(何日分/何回分)
        html += '<select name="' + g + '_AdminCount">';
        for (var j = 1; j <= 14; j++) {
            var selected = (j == 4 ? ' selected="selected"' : '');
            html += '<option value="' + j + '"'+selected+'>' + j + '</option>';
        }
        html += '</select>';
        html += this.direct_unit[kind_id] + '分'; // 1:内服の場合のみ「日」
        html += '<input type="hidden" name="' + g + '_AdminUnit" value="' + this.direct_unit[kind_id] + '" />';
        html += '</td>';
        html += '</tr>';
        html += '</table>';
        return html;
    },

    create: function(type, data) {
        var base = 'medicine_value_' + type;
        var len = data.length;
        var html = '';
        var group = '';
        var kind_id = '';
        var pre_g = '';
        var pre_u = '';
        for (var i = 0; i < len; i++) {
            var d = data[i];
            var g = base + '_' + d.DiagnosisID + '_' + d.RecipeDispGroup;
            var p = g + '_' + d.RecipeDispNum;
            if (pre_u == '') {
                pre_u = d.usageInfo; // グループ内最初の利用回数をセット
            }
            if (group == '') {
                kind_id = d.kind_id; // １つ目のグループに対する用法(1:内服,2:頓服,3:外用)
            }
            if (group != '' && group != d.RecipeDispGroup) {
                // 用法
                html += this.createYoho(pre_g, kind_id, pre_u);
                html += '<hr size="1" />';
                html += '<br />';
                kind_id = d.kind_id; // 2つ目以降のグループに対する用法
                pre_u = ''; // 初期化...
            }
            group = d.RecipeDispGroup;
            html += '<table>';
            html += '<tr>';
            html += '<th><label for="for_' + p + '_MedicineName"><input type="checkbox" name="' + p + '_MedicineName" id="for_' + p + '_MedicineName" value="' + d.MedicineName + '" />' + d.MedicineName + '</label></th>';
            var noflag = d.WeightZone ? ' def="yes"' : ' def="no" style="background-color: red"';
            html += '<td width="120"><input type="text" name="' + p + '_WeightZone" value="' + d.WeightZone + '"' + noflag + ' />' + d.FooterName + '</td>';
            // 1日何回分かは用法で指定する為コメントアウト
            //html += '<td width="120">';
            //html += '1日';
            //html += '<select name="' + p + '_usageInfo">';
            //for (var j = 1; j <= 4; j++) {
            //    html += '<option value="' + j + '"' + (j == d.usageInfo ? ' selected="selected"' : '') + '>' + j + '</option>';
            //}
            //html += '</select>';
            //html += '回';
            //html += '</td>';
            if (d.PreparationID == 'A') {
                html += '<td>(参考:' + d.UnitNum + d.UnitInfoName + ')</td>';
            } else {
                html += '<td>　　　　　　　　　　　　　　　　</td>';
            }
            html += '</tr>';
            html += '</table>';
            pre_g = g;
        }
        if (html) {
            // 最後のグループに対して、ここで用法を追加
            html += this.createYoho(pre_g, kind_id, pre_u);
        }
        html += '<br />';
        var type_name = recipe.typename[type];
        var td = $('table.medicine tr.' + type_name + ' td.medicine_data');
        td.append(html);
    },

    // 処方薬の英語種類名
    typename: {1:'powder',2:'tablet',3:'syrup'},

    // クリックイベント監視とチェック表示の準備
    prep: function() {
        $('input:checkbox["name$=_ParentCheck"]').click(function(){
            // ※家族の同意のもと使用
            checkedcheckbox();
        });
        $('table.medicine td table th input[name^="medicine_value_"]').click(function(){
            toggle_medicine();
            checkedcheckbox();
        });
        $('table.medicine th input[name^="medicine_type_"]').click(function(){
            toggle_mtype();
            checkedcheckbox();
        });
        toggle_medicine();
        toggle_mtype();
        checkedcheckbox();
    },

    // 処方薬データ有無フラグ(is: true or false, list: data)
    mdc: {
        powder:{is:false,list:[]},
        tablet:{is:false,list:[]},
        syrup:{is:false,list:[]},
    },

    // 処方薬データの取得
    get: function() {
return;
        $.ajax({
            type: "GET",
            async: false,
            url: "<?php echo APP_ROOT ?>/doctor/get_recipe",
            data: "diagnosis_id=" + $('[name="diag_list"]').val() + "&weight=" + $('[name="KARTE280101"]').val(),
            success: function(data){
                for (var i = 1; i <= 3; i++) {
                    var type = recipe.typename[i];
                    recipe.mdc[type].is = false; // 処方薬データ有無初期化...
                    recipe.mdc[type].list = [];  // 処方薬データリスト初期化...
                    if (data[i]) {
                        recipe.create(i, data[i]);
                        recipe.mdc[type].is = true;
                        recipe.mdc[type].list = data[i];
                    }
                }
                recipe.prep();
            }
         });
    },

    // 処方用法データの取得
    direct: function() {
return;
        $.ajax({
            type: "GET",
            async: false,
            url: "<?php echo APP_ROOT ?>/doctor/get_recipe_direction",
            success: function(data){
                // 1:内服,2:頓服,3:外用
                for (var i = 1; i <= 3; i++) {
                    if (data[i]) {
                        recipe.createDirection(i, data[i]);
                    }
                }
            }
         });
    },

    direction: {1:'', 2:'', 3:''}, // 1:内服,2:頓服,3:外用
    direct_name: {1:'内服', 2:'頓服', 3:'外用'},
    direct_unit: {1:'日', 2:'回', 3:'回'},
    direct_def: {
        1:{ // 内服
            1:'123', // １日１回　昼食後
            2:'4',   // １日２回　朝・夕　食後
            3:'2',   // １日３回　毎食後
            4:'124'  // １日４回　毎食後・寝る前
        },
        2:{ // 頓服
            1:'3310', // 頓服）３８．５℃以上発熱時　４～５時間以上あけて
            2:'2495', // 頓服）３７．５℃以上で１回目使用。８時間後３８℃以上の発熱が続く場合には、もう１
            3:'3419', // 頓服）発熱時・疼痛時　６～８時間以上空けて（１日３回まで）
            4:'183'   // 頓服）発熱時・疼痛時　４～６時間以上空けて（１日４回まで）
        },
        3:{ // 外用
            1:'5',    // １日１回
            2:'3145', // １日２回
            3:'3146', // １日３回
            4:'402'   // １日４回　１回１噴霧
        }
    },

    createDirection: function(i, d) {
        var len = d.length;
        var html = '';
        html += '<select name="__code__" onChange="recipe.setDirectUsage(\'__usage__\', this);">';
        for (var j = 0; j < len; j++) {
            html += '<option value="' + d[j].carte_master_id + '">' + d[j].name + '</option>';
        }
        html += '</select>';
        html += '<input type="hidden" name="__usage__" value="' + d[0].name + '" />';
        this.direction[i] = html;
    },

    setDirectUsage: function(usage, code) {
        $('[name="' + usage + '"]').val(code.options[code.selectedIndex].text);
    },

    textareadata: '',

    // 入力履歴有無フラグ(true:あり, false:なし)
    hist: false,

    // 入力履歴値のセット
    put: function() {
        $('[name^="medicine_value_"]').each(function(){
            var name = $(this).attr('name');
            if (defval.json[name]) {
                recipe.hist = true;
                defval.setval(name, defval.json[name]);
            }
        });
        recipe.prep();
    },

    // レシピDOM初期化
    reset: function() {
        $('.medicine_data > *').remove();
        recipe.get();
        recipe.defcheck();
    },

    // レシピ初期状態の選択
    defcheck: function() {
        var hr = false;
        var prefer = recipe.typename[recipe.prefertype()];
        var cnt = 0;
        $('tr.' + prefer + ' td.medicine_data > *').each(function(){
            if (hr == false && recipe.mdc[prefer].list[cnt] && recipe.mdc[prefer].list[cnt]['RecipeDispType'] == 'BASE') {
                // 罫線<hr>前の処方薬(最初のグループ)でかつ、表示タイプが'BASE'の場合にチェックする
                $(this).find('th > * input').attr('checked', true);
            }
            if ($(this).get(0).tagName == 'HR') {
                hr = true;
            }
            cnt++;
        });
        recipe.prep();
    },

    // 最優先処方薬種類(お好みの処方薬)の取得
    // 優先順 : 粉剤[1] > 錠剤[2] > シロップ[3]
    prefertype: function() {
        var type = 1; // デフォルトは粉剤...
        for (var i = 1; i <= 3; i++) {
            var tname = recipe.typename[i];
            var mtype = 'medicine_type_' + i;
            if (defval.json[mtype] && recipe.mdc[tname].is) {
                // 好みの処方薬指定があり、処方薬データが存在する場合に決定する
                type = i;
                break;
            }
        }
        return type;
    },

    move: function(area) {
        if (area == 2) {
            $('#recipe_1 > *').appendTo('#recipe_2');
        } else {
            $('#recipe_2 > *').appendTo('#recipe_1');
        }
    },

    postcheck: function() {
        // ここで「保存する」ボタンを押した時のポストチェックを行います。
        // 指定した薬剤に対する数量指定が空の場合にアラートを表示します。
        var res = true;
        // 薬剤選択指定チェック(1:粉剤、2:錠剤、3:シロップ項目がOFFの場合は、薬剤項目も全てOFFにする)
        for (var i = 1; i <= 3; i++) {
            if (! $('#mtype_' + i).attr('checked')) {
                $('input[name^="medicine_value_' + i + '_"]').each(function(){
                    if ($(this).attr('name').match(/_MedicineName$/)) {
                        $(this).attr('checked', false);
                        toggle_medicine();
                    }
                });
            }
        }
        $('input[name^="medicine_value_"]').each(function(){
            // 薬剤数量指定チェック
            if ($(this).attr('name').match(/_WeightZone$/) && ! $(this).val()) {
                var name = $(this).attr('name').replace('_WeightZone', '_MedicineName');
                if ($('input[name="' + name + '"]').attr('checked')) {
                    alert('処方レシピの薬剤「' + $('input[name="' + name + '"]').val() + '」の数量指定がありません');
                    res = false;
                }
            }
        });
        return res;
    }

};
// }}}

// {{{ 経過XMLの値取得...
function putProcXml1()
{
    var txt = '';
    txt += "【 Chief Complaint 】\n";
    txt += "　" + $('[name="KARTE100101"]').val() + "\n";
    txt += "【 Onset and Course 】\n";
    txt += "　" + $('[name="OCContents"]').val();
    $('#process_xml_1').val(txt);
    // for Debug...
    //var w = window.open();
    //w.document.write('<pre>' + txt + '</pre>');
}

// putProcXml2()は各PEのVIEWへ移動

function putProcXml3()
{
    var txt = '';
    txt += "【 2nd Assessment and Plan 】\n";
    txt += "　" + $('[name="TEXT25"]').val();
    $('#process_xml_3').val(txt);
    // for Debug...
    //var w = window.open();
    //w.document.write('<pre>' + txt + '</pre>');
}

function putProcXml4()
{
    var txt = '';
    // Recipe
    if ($('#INPUT23').attr('checked')) {
        txt += "Recipe　処方あり\n";
        if ($('#mtype_1').attr('checked')) {
            // 粉剤
            txt += "　粉剤\n";
            $('.powder').find('td.medicine_data > *').each(function(){
                txt += putProcXml4_cell($(this));
            });
        }
        if ($('#mtype_2').attr('checked')) {
            // 錠剤
            txt += "　錠剤\n";
            $('.tablet').find('td.medicine_data > *').each(function(){
                txt += putProcXml4_cell($(this));
            });
        }
        if ($('#mtype_3').attr('checked')) {
            // シロップ
            txt += "　シロップ\n";
            $('.syrup').find('td.medicine_data > *').each(function(){
                txt += putProcXml4_cell($(this));
            });
        }
        txt += "　" + $('[name="KARTE330101"]').val();
    } else {
        txt += "Recipe　処方なし\n";
    }
    // Diagnostic Plan
    if ($('#INPUT21').attr('checked')) {
        txt += "Diagnostic Plan　検査あり\n";
        $('#diagnostic_plan td.entry > table').each(function(){
            var tb = $(this);
            var s = tb.find('td:first-child span');
            var title = s.text().trim();
            txt += "　" + title;
            switch (title) {
                case '画像' :
                    tb.find('td:nth-child(2) table tr').each(function(){
                        var tr = $(this);
                        txt += "\n　　　" + tr.find('td:first-child').text().trim();
                        tr.find('td:nth-child(2) > label').each(function(){
                            if ($(this).find('input').attr('checked')) {
                                txt += "　" + $(this).text().trim();
                            }
                        });
                        txt += "\n";
                    });
                    break;
                case '追記欄' :
                    txt += "　" + tb.find('textarea').val();
                    break;
                default :
                    tb.find('td:nth-child(2) label').each(function(){
                        if ($(this).find('input').attr('checked')) {
                            txt += "　" + $(this).text().trim();
                        }
                    });
            }
            txt += "\n";
        });
    } else {
        txt += "Diagnostic Plan　検査なし\n";
    }
    // Therapeutic Plan
    if ($('#INPUT25').attr('checked')) {
        txt += "Therapeutic Plan　処置あり\n";
        $('#therapeutic_plan td.entry table label').each(function(){
            var l = $(this);
            if (l.find('input').attr('checked')) {
                txt += "　" + l.text().trim();
            }
        });
        txt += "\n";
        txt += "　追記欄　" + $('[name="KARTE310101"]').val();
    } else {
        txt += "Therapeutic Plan　処置なし\n";
    }
    $('#process_xml_4').val(txt);
    // for Debug...
    //var w = window.open();
    //w.document.write('<pre>' + txt + '</pre>');
}
function putProcXml4_cell(table)
{
    var txt = '';
    if (table.find('th label input').attr('checked')) {
        var l = table.find('th label');
        txt += "　　" + l.text();
        txt += "　" + l.parent().next().find('input').val();
        txt += l.parent().next().text();
        l.parent().next().next().find('option:selected').each(function(){
            txt += "　1日" + $(this).text() + "回";
        });
        txt += "　" + l.parent().next().next().next().text() + "\n";
    }
    if (table.get(0).tagName == 'HR') {
        txt += "　　-------------------------------------------------\n";
    }
    return txt;
}
// }}}

// {{{ 目黒クリニック診断名ライブラリ
function doDiag()
{
    var text = $('select[name="diag_list"] option:selected').text();
    $('input[name="DiagName"]').val(text);
    recipe.reset();
    toggle_diagnosis_textarea();
}
// }}}

// {{{ From Submit...
function _form_submit()
{
    if (recipe.postcheck() != true) {
        return false;
    }
    //putProcXml1();
    //putProcXml2();
    //putProcXml3();
    //putProcXml4();
    document._form.submit();
}
// }}}

// {{{ デフォルト実行処理...
$(function(){
    recipe.get();
    recipe.put();
    if (recipe.hist == false) {
        // 初回表示で、入力履歴が無い場合はデフォルトチェックをする...
        recipe.defcheck();
    }
    // 初回表示は「sample」を描画する
    $('.display_area').hide();
    //$('.area_tab_cell').css('background-color', '#ccc');
    $('#area_tab_cell_sample').css('background-color', '#98fb98');
    $('#display_0').show();
    $('#display_1').show();
    $('#display_3').show();
    $('#display_4').show();
    $('#display_5').show();
    toggle_diagnosis_textarea();
    toggle_KARTE280401(); // 体重により、単位をkg/gに選択...
});
// }}}

//-->
</script>

<?php
    $lmd->invokemodule('doctor.foot');
?>