<?php
    $lmd->invokeModule('doctor.head', array(
        'title' => SITE_NAME,
    ));
?>

<style type="text/css">
/* モダンなUIスタイル - 基本設定 */
:root {
  --primary-color: #2c3e50;
  --secondary-color: #3498db;
  --light-bg: #f5f7fa;
  --text-color: #333;
  --border-color: #E3E3E3;
  --border-radius: 4px;
  --box-shadow: 0 2px 5px rgba(0,0,0,0.1);
}

/* 基本フォントスタイル */
body {
  font-family: 'Helvetica Neue', Arial, sans-serif;
  font-size: 14px;
  line-height: 1.6;
  color: var(--text-color);
}
/* タブナビゲーションのスタイル改善 */
#ctl-tab {
width: 754px;
margin:0 auto;
}

#tab {
  width: 100%;
  max-width: 760px;
  border-collapse: separate;
  border-spacing: 2px 0;
  margin-top: 10px;
}

#tab td {
  padding: 12px 20px;
  background: var(--light-bg);
  border: none;
  border-radius: var(--border-radius) var(--border-radius) 0 0;
  text-align: center;
  font-size: 14px;
  transition: background-color 0.3s;
}

#tab td:hover {
  background: #e4e9f2;
}

#tab td.selected, 
#tab_exa, 
#tab_exa_edit, 
#tab_carte, 
#tab_treatment, 
#tab_history, 
#tab_card_number_edit {
  background: white;
  box-shadow: 0 -2px 5px rgba(0,0,0,0.1);
}

#tab td a {
  color: var(--primary-color);
  text-decoration: none;
  display: block;
  font-weight: 500;
}

/* 左メニューのスタイル改善 */
#left-menu {
  position: fixed;
  top: 190px;
  left: 0;
  width: 130px;
  background: white;
  border-radius: 0 var(--border-radius) var(--border-radius) 0;
  box-shadow: var(--box-shadow);
  z-index: 97;
}

.left-menu-tbl {
  width: 120px;
  border: none;
  border-radius: var(--border-radius);
  margin: 5px auto;
  background: white;
  overflow: hidden;
}

.left-menu-tbl th {
  padding: 8px;
  background: var(--primary-color);
  color: white;
  font-weight: normal;
  font-size: 13px;
  text-align: center;
  border: none;
}

.left-menu-tbl td {
  padding: 8px;
  background: white;
  border: 1px solid var(--border-color);
  border-top: none;
  font-size: 12px;
  line-height: 1.4;
}

.left-menu-tbl td a {
  color: var(--text-color);
  text-decoration: none;
  display: block;
}

.left-menu-tbl td:hover {
  background: var(--light-bg);
}

#lm_value_s {
  font-size: 12px;
  margin-bottom: 3px;
}

#left-menu a:hover {
  text-decoration: none;
}

/* メインコンテンツのマージン調整 */
#cne_wrap, 
#flexible_frame, 
#ctrl-menu {
  margin-left: 140px;
}

/* レスポンシブ対応 */
@media (max-width: 768px) {
  #ctl-tab {
    margin-left: 10px;
  }
  
  #tab td {
    padding: 8px 12px;
    font-size: 13px;
  }
  
  #left-menu {
    width: 100px;
  }
  
  .left-menu-tbl {
    width: 90px;
  }
  
  #cne_wrap, 
  #flexible_frame, 
  #ctrl-menu {
    margin-left: 110px;
  }
}
/* ヘッダー情報エリアのスタイル改善 */
#info-pad {
  float: left;
  width: 75%;
  background-color: white;
  border-radius: var(--border-radius);
  box-shadow: var(--box-shadow);
  /* margin: 10px 0; */
  padding: 15px;
}

#info-pad table {
  width: 100%;
  border-collapse: collapse;
  margin-bottom: 8px;
  font-size: 14px;
}

#info-pad table:first-child {
  border-bottom: none;
}

#info-pad table th {
  width: 140px;
  background: var(--primary-color);
  color: white;
  padding: 8px;
  text-align: left;
  font-weight: normal;
  border-radius: var(--border-radius) 0 0 var(--border-radius);
}

#info-pad table td {
  padding: 8px;
  border: 1px solid var(--border-color);
  background: var(--light-bg);
}

/* バイタルサインの値を強調 */
#info-pad table td:not(:first-child) {
  font-weight: bold;
  color: var(--primary-color);
}

/* レスポンシブ対応 */
@media (max-width: 768px) {
  #info-pad {
    width: 95%;
    margin: 10px auto;
  }
  
  #info-pad table {
    font-size: 13px;
  }
  
  #info-pad table th {
    width: 100px;
  }
  
}
#left-menu {
    top: 190px !important; 
}

#spacer4ctl-pad {
    height: 200px !important;
}

#list_btn, #logout{
  background-color: var(--secondary-color);
  color: white;
  border: none;
  border-radius: var(--border-radius);
  /* padding: 8px 15px; */
  cursor: pointer;
  font-size: 14px;
  transition: background-color 0.3s;
}

#logout {
  margin-bottom: 16px;
}

</style>

<style type="text/css">

<!--
.diagnosis {
    padding: 10px;
}
div.diagnosis:nth-child(odd) {
    background-color: #ccffcc;
}
div.diagnosis:nth-child(even) {
    background-color: #ff99ff;
}
.diagnosis_list { height: 671.6px;}
-->


</style>

<div style="padding: 0.2rem;">
    <div class="clearfix ps-2 pe-2">
        <div class="float-start w-50">
            <div class="row container dt-nav">
                <div class="col-md-2 float-start ps-0 pe-1 w-59">
                    <a class="rounded text-nowrap <?=$lmd->isMainModule('doctor_tab.exa') ? "active" : "" ?>" href="<?php echo APP_ROOT ?>/doctor_tab/exa?answer_code=<?php echo $_answer_code ?>">予診票</a>
                </div>
                <?php if(_isRoleDoctor()): ?>
                    <div class="col-md-2 float-start ps-0 pe-1 w-59">
                    <a class="rounded text-nowrap <?=$lmd->isMainModule('doctor_tab.monshin') ? "active" : "" ?>" href="<?php echo APP_ROOT ?>/doctor_tab/monshin?answer_id=<?php echo $answer_id ?>&answer_code=<?php echo $_answer_code ?>">修正</a>
                    </div>
                <?php endif; ?>
                <div class="col-md-2 float-start ps-0 pe-1 w-59">
                    <a class="rounded text-nowrap <?=$lmd->isMainModule('doctor_tab.outpatient_carte') ? "active" : "" ?>" href="<?php echo APP_ROOT ?>/doctor_tab/outpatient_carte?answer_code=<?php echo $_answer_code ?>">外来カルテ</a>
                </div>
                <?php if (_isChild()) : ?>
                    <div class="col-md-2 float-start ps-0 pe-1 w-59">
                        <a class="rounded text-nowrap <?=$lmd->isMainModule('doctor_tab.treatment') ? "active" : "" ?>" href="<?php echo APP_ROOT ?>/doctor_tab/treatment?answer_id=<?php echo $answer_id ?>&answer_code=<?php echo $_answer_code ?>">患者説明</a>
                    </div>
                <?php endif; ?>
                <?php if(_isRoleDoctor()): ?>
                    <div class="col-md-4 float-start ps-0 pe-1 w-118">
                        <a class="rounded text-nowrap <?=$lmd->isMainModule('doctor_tab.card_number_edit') ? "active" : "" ?>" href="<?php echo APP_ROOT ?>/doctor_tab/card_number_edit?answer_code=<?php echo $_answer_code ?>">診察券番号修正</a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="float-end d-flex align-items-center" style="height:46.4px">
        </div>
    </div>
</div>



<?php if (Device::isIos()) : ?>
<!--
<script type="text/javascript" src="<?php echo APP_ROOT ?>/js/iscroll.js"></script>
<script type="text/javascript">
var myScroll;
var a = 0;
function loaded() {
    setHeight();
    myScroll = new iScroll('main-wrap', {desktopCompatibility:true});
}
function setHeight() {
    var headerH = 100,
        footerH = 0,
        wrapperH = window.innerHeight - headerH - footerH;
    document.getElementById('wrapper').style.height = wrapperH + 'px';
}
window.addEventListener('onorientationchange' in window ? 'orientationchange' : 'resize', setHeight, false);
document.addEventListener('touchmove', function (e) { e.preventDefault(); }, false);
document.addEventListener('DOMContentLoaded', loaded, false);
</script>
<style type="text/css">
#wrapper {
    position:relative;
    z-index:1;
    width:100% ;
    overflow:hidden;
}

</style>
-->




<div id="wrapper"><!-- wrapper -->
<?php endif; ?>

<div class="ps-2 pe-2">
  <!-- abs-m-c-table -->
  <table class="tabs-m-c-table">
    <tbody>
      <tr>
        <td class="w-11">
            <?php
                $lmd->invokeModule('doctor.left_menu');
            ?>
        </td>
        <td colspan="7">
<div id="main-wrap" class="diagnosis_list b-s-2 p-2">

<!--
<div style="margin-bottom: 20px">
<h2>重症度： <?php echo $diagnosis_text ?></h2>
</div>
-->

<?php
    foreach ($zenshin_diagnosis_arr as $k => $v) {
        if ($v['TreatmentContents'] === '特にありません。') unset($zenshin_diagnosis_arr[$k]);
    }
 ?>

<?php if($zenshin_diagnosis_arr): ?>
    <div class="diagnosis">
    <h2>全身状態</h2>
    <?php foreach($zenshin_diagnosis_arr as $v): ?>
        <p><?php echo $v['TreatmentContents'] ?></p>
    <?php endforeach; ?>
    </div>
<?php endif; ?>

<?php if($shojo_diagnosis_arr): ?>
    <div class="diagnosis">
    <h2>症状</h2>
    <?php foreach($shojo_diagnosis_arr as $v): ?>
        <p><?php echo $v['TreatmentName'] ?></p>
    <?php endforeach; ?>
    </div>
<?php endif; ?>

<?php if($fever_diagnosis): ?>
    <div class="diagnosis">
    <h2>発熱</h2>
    <p><?php echo $fever_diagnosis['TreatmentName'] ?></p>
    </div>
<?php endif; ?>

<?php if($gaisho_diagnosis_arr): ?>
    <div class="diagnosis">
    <h2>外傷①</h2>
    <?php foreach($gaisho_diagnosis_arr as $v): ?>
        <p><?php echo $v['InjuryCommonTreat'] ?></p>
    <?php endforeach; ?>
    </div>
<?php endif; ?>

<?php if($gaisho_detail_diagnosis_arr): ?>
    <div class="diagnosis">
    <h2>外傷②</h2>
    <?php foreach($gaisho_detail_diagnosis_arr as $v): ?>
        <p><?php echo $v['InjuryDetailTreat'] ?></p>
    <?php endforeach; ?>
    </div>
<?php endif; ?>

<?php if($goin_diagnosis_text): ?>
    <div class="diagnosis">
    <h2>誤飲</h2>
    <p><?php echo $goin_diagnosis_text ?></p>
    </div>
<?php endif; ?>

</div><!-- /main-wrap -->
        </td>
      </tr>
    </tbody>
  </table>
  <!-- abs-m-c-table -->
</div>
<?php if (Device::isIos()) : ?>
</div><!-- /wrapper -->
<?php endif; ?>

<?php
    $lmd->invokeModule('doctor.foot');
?>
