
<br />
<div class="tx_stage">
    <div id="internal_tx_items"></div>
</div>



<script type="text/javascript">
/**
var internal_tx = {

    diagnosis_ids: [],
    level: '',
    weight: '',
    checked: false,

    init: function(diagnosis_ids, level, weight, checked)
    {
        this.diagnosis_ids = [];
        this.level  = '';
        this.weight = '';
        this.checked = false;

        for (var i in diagnosis_ids) {
            var diagnosis_id = '' + diagnosis_ids[i];
            if (diagnosis_id.match(/^[1-9][0-9]*$/)) {
                this.diagnosis_ids.push(diagnosis_ids[i]);
            }
        }
        this.level = level;
        this.weight = weight;
        this.checked = checked;

        return this;
    },

    execute: function()
    {
        if (this.diagnosis_ids.length == 0) {
            internal_tx.render([]);
            return false;
        }

        $.ajax({
            type: 'GET',
            async: false,
            cache: false,
            url: '<?php echo APP_ROOT ?>/doctor/get_internal_tx',
            data: {
                'diagnosis_ids[]': this.diagnosis_ids,
                level: this.level,
                weight: this.weight
            },
            success: function(data){
                internal_tx.render(data);
                internal_tx.toggle();
                internal_tx.bindAction();
            }
         });
    }, 

    render: function(data)
    {
        $('#internal_tx_items').empty();
        var h = '';
        for (var i in data) {
            var levelN = 'level' + this.level;
            var klass = 'internal_tx_class_' + data[i].internal_tx_diagnosis_name_id;
            var id    = 'internal_tx_id_' + data[i].internal_tx_item_id;
            var name  = id + '_' + data[i][levelN];
            var label = data[i][levelN];
            var kg_dose_by_weight = data[i].kg_dose_by_weight;
            var kg_dose_unit = data[i].kg_dose_unit;
            var kg_day = data[i].kg_day;
            var max_dose_max = data[i].max_dose_max;
            var max_dose_unit = data[i].max_dose_unit;

            h +='<div class="'+klass+'" style="margin:10px 0">';
            h +='<label for="'+id+'">';
            if (this.checked) {
                h += '<input type="checkbox" value="'+label+'" name="'+name+'" id="'+id+'" checked="checked">'+label;
            } else {
                h += '<input type="checkbox" value="'+label+'" name="'+name+'" id="'+id+'">'+label;
            }
            h += '</label>&nbsp;';

            if (kg_dose_by_weight != '') {
                h += '<span class="internal_tx_dose">'
                h += '<input type="text" name="'+name+'_kg_dose" value="'+kg_dose_by_weight+'" style="width:80px;ime-mode:disabled;">'+kg_dose_unit;
                if (max_dose_max != '') {
                    h += '&nbsp;【最大：'+max_dose_max+max_dose_unit+'】';
                }
                h += '</span>'
            }

            h +='</div>';
        }
        $('#internal_tx_items').append(h);
    },

    toggle: function()
    {
        $('[id^="internal_tx_id_"]').each(function(){
            if ($(this).attr('checked')) {
                $(this).parent().next().show();
            } else {
                $(this).parent().next().hide();
            }
        });
        checkedcheckbox();
    },

    bindAction: function()
    {
        $('[id^="internal_tx_id_"]').click(function(){
            if ($(this).attr('checked')) {
                $(this).parent().next().show();
            } else {
                $(this).parent().next().hide();
            }
            checkedcheckbox();
        });
    }
}
*/

var internal_tx = {

    execute: function(){
        $.ajax({
            type: 'GET',
            async: false,
            cache: false,
            url: '<?php echo APP_ROOT ?>/doctor/get_internal_tx',
            data: {
            },
            success: function(data){
                internal_tx.render(data);
            }
         });
    }, 

    prohibition: function(name){
        var prohibited_words = new Array('禁忌','塩化カリウム静注');
        for (var w in prohibited_words) {
            if (name == prohibited_words[w]) {
                return ' prohibition="yes"';
            }
        }
        return '';
    },

    render: function(data){
        $('#internal_tx_items').empty();
        var cate  = data['category'];
        var group = data['group'];
        var treat = data['treatment'];
        var h = '';
        for (var i in cate) {
            var c_class = 'internal_tx_c_class_' + cate[i].tx_category_id;
            var c_id    = 'internal_tx_c_id_' + cate[i].tx_category_id;
            var c_name  = c_id + '_label';
            var c_label = cate[i].category_name;
            var c_check = this.checked ? ' checked="checked"' : '';

            h += '<div class="'+c_class+'" style="margin:10px 0;">';
            h += '<div style="float:left;">';
            h += '<label for="'+c_id+'"'+this.prohibition(c_label)+'>';
            h += '<input type="checkbox" value="'+c_label+'" name="'+c_name+'" id="'+c_id+'"'+c_check+'>'+c_label;
            h += '</label>&nbsp;';
            h += '</div>';

            h += '<div class="child_'+c_class+'" style="float:left; margin-left:10px;">';
            for (var j in group) {
                if (group[j].tx_category_id == cate[i].tx_category_id) {
                    var g_class = 'internal_tx_g_class_' + cate[i].tx_category_id + '-' + group[j].tx_group_id;
                    var g_id    = 'internal_tx_g_id_' + cate[i].tx_category_id + '-' +  group[j].tx_group_id;
                    var g_name  = g_id + '_label';
                    var g_label = group[j].group_name.replace('＊', '');
                    var g_check = this.checked ? ' checked="checked"' : '';
                    h += '<div class="'+g_class+'" style="float:left; margin:0 10px 10px 0;">';
                    h += '<label for="'+g_id+'"'+this.prohibition(g_label)+'>';
                    h += '<input type="checkbox" value="'+g_label+'" name="'+g_name+'" id="'+g_id+'"'+g_check+'>'+g_label;
                    h += '</label>';
                    h += '</div>';

                    h += '<div class="child_'+g_class+'" style="float:left;">';
                    for (var k in treat) {
                        if (treat[k].tx_group_id == group[j].tx_group_id) {
                            var t_class = 'internal_tx_t_class_' + cate[i].tx_category_id + '-' + group[j].tx_group_id + '-' + treat[k].tx_treatment_id;
                            var t_id    = 'internal_tx_t_id_' + cate[i].tx_category_id + '-' + group[j].tx_group_id + '-' + treat[k].tx_treatment_id;
                            var t_name  = t_id + '_label';
                            var t_label = treat[k].recipe_name;
                            var t_check = this.checked ? ' checked="checked"' : '';
                            var kg_dose_flag = treat[k].quantity_flag;
                            var kg_dose_unit = treat[k].unit;
                            h += '<div style="margin:0 10px 10px 0;">';
                            h += '<label for="'+t_id+'"'+this.prohibition(t_label)+'>';
                            h += '<input type="checkbox" value="'+t_label+'" name="'+t_name+'" id="'+t_id+'"'+t_check+'>'+t_label;
                            h += '</label>';

                            if (kg_dose_flag != 0) {
                                h += '&nbsp;';
                                h += '<span class="internal_tx_t_dose">'
                                h += '<input type="text" name="'+t_name+'_kg_dose" value="" style="width:80px;ime-mode:disabled;">&nbsp;';
                                h += '<span name="'+t_name+'_kg_unit">'+kg_dose_unit+'</span>';
                                h += '</span>'
                                h += '&nbsp;';
                                h += '<span class="internal_tx_t_dose_max">';
                                h += '<span name="'+t_name+'_kg_dose_max"></span>';
                                h += '</span>'
                            }

                            h += '</div>';
                        }
                        h += '';
                        h += '';
                        h += '';
                    }
                    h += '</div>';
                    h += '<div style="clear:both;"></div>';

                }
            }
            h += '</div>';
            h += '<div style="clear:both;"></div>';

            h +='</div>';
        }
        $('#internal_tx_items').append(h);
        $('[prohibition="yes"]').css({'background-color': 'red'});
    },

    hideall: function(){
        $('[class^="child_internal_tx_g_class_"]').hide();
        $('[class^="child_internal_tx_c_class_"]').hide();
    },

    hide: function() {
        $('input[name^="internal_tx_g_"]').each(function(){
            $(this).parent().parent().show();
            if ( ! $(this).attr('checked')) {
                $(this).parent().parent().hide();
            }
        });
        $('input[name^="internal_tx_t_"]').each(function(){
            $(this).parent().parent().show();
            if ( ! $(this).attr('checked')) {
                $(this).parent().parent().hide();
            }
        });
    },

    show: function() {
        $('input:checked[name^="internal_tx_t_id_"]').each(function(){
            var tmp = $(this).attr('id').split('_id_');
            var num = tmp[1].split('-');
            var id = num[0] + '-' + num[1];
            var g = $('#internal_tx_g_id_' + id);
            var g_child = $('.child_internal_tx_g_class_' + id);
            g.attr('checked', true);
            g_child.show();
            $(this).parent().parent().show();
        });
        $('input:checked[name^="internal_tx_g_id_"]').each(function(){
            var tmp = $(this).attr('id').split('_id_');
            var num = tmp[1].split('-');
            var id = num[0];
            var c = $('#internal_tx_c_id_' + id);
            var c_child = $('.child_internal_tx_c_class_' + id);
            c.attr('checked', true);
            c_child.show();
            $(this).parent().parent().show();
        });
    },

    listen: function(){
        $('[id^="internal_tx_c_id_"]').click(function(){
            var name = 'child_' + $(this).attr('id').replace('id','class');
            if ($(this).attr('checked')) {
                $('[class="'+name+'"]').show();
                $('[class="'+name+'"] > div:hidden').show();
            } else {
                $('[class="'+name+'"]').hide();
            }
        });
        $('[id^="internal_tx_g_id_"]').click(function(){
            var name = 'child_' + $(this).attr('id').replace('id','class');
            if ($(this).attr('checked')) {
                $('[class="'+name+'"]').show();
                $('[class="'+name+'"] > div:hidden').show();
            } else {
                $('[class="'+name+'"]').hide();
            }
        });
    }
};

function mkInternalTxItems(diagnosis_ids, checked)
{
    var level   = '<?php echo $_SESSION['AnswerOriginal']['severitys']['severity_level'] ?>';
    var weight  = $('[name="KARTE280101"]').val();
    internal_tx.init(diagnosis_ids, level, weight, checked).execute();

    if ($('[name="ex_diag_list"]').val() == '-') {
        $('#INPUT25').attr('checked', false);
        $('#INPUT26').attr('checked', true);
    } else {
        $('#INPUT25').attr('checked', true);
        $('#INPUT26').attr('checked', false);
    }
    checkedradio();
    toggle_RECEPT21();

    var text = $('select[name="ex_diag_list"] option:selected').text();
    $('input[name="DiagName"]').val(text);
    $('select[name="diag_list"]').val('-');
    $('select[name="em_diagcategory_list"]').val('-');
    $('select[name="em_diag_list"]').val('-');
    //recipe.reset();
    toggle_impression_textarea();
    //recipe.set_recipe_textarea();
    //defexdiag.set();
}
function initMkInternalTxItems()
{
    var checked = <?php echo _hasOutpatientCarte() ? 'false' : 'true' ?>;
    var diagnosis_id = DEF_JSON.ex_diag_list ? parseInt(DEF_JSON.ex_diag_list) : 0;
    if (diagnosis_id > 0) {
        var diagnosis_ids = [];
        diagnosis_ids.push(diagnosis_id);
        //mkInternalTxItems(diagnosis_ids, checked);
    }
    $(function(){
        //internal_tx.toggle();
    });
}
initMkInternalTxItems();

</script>
