<?php
    $v = $lmd->param('v');
    $birth_y = $lmd->param('birth_y');
    $q17_disease = $lmd->param('q17_disease');
    $q17_other_text = $lmd->param('q17_other_text');
?>

<hr class="normal">
<div class="bg-even">
<p class="label-1">■入院するような大きな病気・継続して外来にかかる必要のある病気になったことがありますか？</p>
<?php
    $fe = Factory::load('FormElement')->getInstance(Resource::get('yesno'));
    $fe->setDefault(isset($v['q17']) ? $v['q17'] : '');
    $fe->setLabelTag('q17');
    $fe->setDelimiter('　');
    $fe->radio('q17', array('id' => 'q17'));
?>
<div id="q17-option1">
<hr class="dotted">
<div class="indent-1">
<p class="label-1">▼「はい」の場合（複数可）</p>
<?php
    $buf = $q17_disease ? unserialize($q17_disease) : array();
    $def = array();
    if ($buf) {
        foreach ($buf as $key => $val) {
            $def['value'][$key] = $val['value'];
            $def['y'][$key] = $val['y'];
            $def['m'][$key] = $val['m'];
        }
    } else {
        $def['value'] = array();
        $def['y'] = array();
        $def['m'] = array();
    }

    $fec = Factory::load('FormElementCustom')->getInstance(Resource::get('kiou_disease'));
    $fec->setDefault($def['value']);
    $fec->setLabelTag('q17_disease');
    $fec->setDelimiter('　');
    $fec->kioureki('q17_disease', array('id' => 'q17_disease'), 1, $birth_y, $def['y'], $def['m']);
?>
<div id="q17-option2">
<hr class="dotted">
<p class="label-1">▼「その他」の場合、ご入力ください</p>
<?php
    $buf = $q17_other_text ? unserialize($q17_other_text) : array();
    $def = array();
    $def['text'] = isset($buf['text']) ? $buf['text'] : '';
    $def['y'] = isset($buf['y']) ? $buf['y'] : '';
    $def['m'] = isset($buf['m']) ? $buf['m'] : '';

    $tmp  = '<input type="text" name="q17_other_text" value="' . $def['text'] . '"> ';
    $tmp .= '<span>';
    $tmp .= '<select name="q17_other_text_y" style="width:100px">';
    $tmp .= '<option value="">--</option>';
    for ($i = $birth_y; $i <= date('Y'); $i++) {
        $wareki = Date::getWareki($i, $i, '%wareki%');
        $selected = (isset($def['y']) && (int)$def['y'] === $i) ? ' selected' : '';
        $tmp .= '<option value="' . $i . '"' . $selected . '>' . $wareki[$i]  . '</option>';
    }
    $tmp .= '</select>年 ';
    $tmp .= '<select name="q17_other_text_m" style="width:80px">';
    $tmp .= '<option value="">--</option>';
    for ($i = 1; $i <= 12; $i++) {
        $selected = (isset($def['m']) && (int)$def['m'] === $i) ? ' selected' : '';
        $tmp .= '<option value="' . $i . '"' . $selected . '>' . $i  . '</option>';
    }
    $tmp .= '</select>月頃から';
    $tmp .= '</span>';
    echo $tmp;
?>
</div>
</div>
</div>
</div>
<script type="text/javascript">
$(function(){
    // 既往歴はありますか
    behaveAs_q17();
    function behaveAs_q17()
    {
        if ($("[name='q17']:checked").val() == 10) { // 10: はい
            $('#q17-option1').show();
        } else {
            $('#q17-option1').hide();
            $("[name^='q17_disease[']").attr('checked', false);
            $('#q17-option1 span').hide();
            $('#q17-option1 select').val('');
        }
        highlightCheckbox();
    }
    $("[name='q17']").click(function(){
        behaveAs_q17();
        behaveAs_q17_family();
    });

    // 既往歴の各項目をチェックした時の挙動
    var proc = function(){
        $("[name^='q17_disease[']").each(function(){
            if ($(this).attr('checked')) {
                $(this).next().next().show();
            } else {
                $(this).next().next().hide();
            }
        });
    };
    $(proc);
    $("[name^='q17_disease[']").click(proc);

    // 既往歴はありますか ⇒ 「その他」
    behaveAs_q17_family();
    function behaveAs_q17_family()
    {
        var flag = false;
        $("[name^='q17_disease[']").each(function(){
            if ($(this).attr('checked') && $(this).val() == 200) { // 200: その他
                flag = true;
                return false; // break
            }
        });

        logicalTextField(flag, '#q17-option2', "[name='q17_other_text']");
        if (flag) {
            $("[name='q17_other_text']").next().show();
        } else {
            $("[name='q17_other_text']").next().hide();
        }
    }
    $("[name^='q17_disease[']").click(function(){
        behaveAs_q17_family();
    });
});
</script>
