<?php
    $v = $lmd->param('v');
?>

<hr class="normal">
<div class="bg-odd">
<p class="label-1">■今までに受けた予防接種はどれですか？</p>
<p>
<input type="checkbox" value="on" id="q5_all">
<label style="cursor:pointer" for="q5_all">全て接種済み</label>
</p>
<?php
    $fe = Factory::load('FormElement')->getInstance(Resource::get('child.yobou'));
    $fe->setDefault(isset($v['q5']) ? explode(',', $v['q5']) : '');
    $fe->setLabelTag('q5');
    $fe->setDelimiter('　');
    $fe->checkboxes('q5', array('id' => 'q5'), 6);
?>
<div id="q5-option1">
<hr class="dotted">
<div class="indent-1">
<p class="label-1">▼「三種混合」を受けた場合</p>
<?php
    $fe = Factory::load('FormElement')->getInstance(Resource::get('child.sanshu'));
    $fe->setDefault(isset($v['q5_sanshu']) ? $v['q5_sanshu'] : '');
    $fe->setLabelTag('q5_sanshu');
    $fe->setDelimiter('　');
    $fe->radio('q5_sanshu', array('id' => 'q5_sanshu'));
?>
</div>
</div>

<div id="q5-option2">
<hr class="dotted">
<div class="indent-1">
<p class="label-1">▼「日本脳炎」を受けた場合</p>
<?php
    $fe = Factory::load('FormElement')->getInstance(Resource::get('child.nihon'));
    $fe->setDefault(isset($v['q5_nihon']) ? $v['q5_nihon'] : '');
    $fe->setLabelTag('q5_nihon');
    $fe->setDelimiter('　');
    $fe->radio('q5_nihon', array('id' => 'q5_nihon'));
?>
</div>
</div>

<div id="q5-option3">
<hr class="dotted">
<div class="indent-1">
<p class="label-1">▼「BCG」を受けた場合</p>
最終 <input type="number" style="width:100px" name="q5_bcg_text" value="<?php echo isset($v['q5_bcg_text']) ? $v['q5_bcg_text'] : '' ?>"> 歳
</div>
</div>

<div id="q5-option4">
<hr class="dotted">
<div class="indent-1">
<p class="label-1">▼その他の予防接種</p>
<input type="text" name="q5_other_text" value="<?php echo isset($v['q5_other_text']) ? $v['q5_other_text'] : '' ?>">
</div>
</div>
</div>
<script type="text/javascript">
$(function(){
    // BCGの最終年齢
    $("[name='q5_bcg_text']").blur(function(){
        if ( ! $("[name='q5_bcg_text']").val().match(/^[0-9]{0,2}$/)) {
            alert('年齢は2桁以内の数字で入力してください。');
            $("[name='q5_bcg_text']").val('');
        }
    });

    // 予防接種 ⇒ 全て接種済み 
    $('#q5_all').click(function(){
        $("[name='q5[]']").attr('checked', $('#q5_all').attr('checked'));
        var flag = ($('#q5_all:checked').val() == 'on') ? true : false;
        if (flag) {
            $('#q5-option1').show();
            $('#q5-option2').show();
        } else {
            $('#q5-option1').hide();
            $('#q5-option2').hide();
            $("[name='q5_sanshu']").attr('checked', false);
            $("[name='q5_nihon']").attr('checked', false);
        }
        highlightCheckbox();
    });

    // 予防接種 ⇒ 「三種混合」を受けた場合
    behaveAs_q5_sanshu();
    function behaveAs_q5_sanshu()
    {
        var flag = hasValueInCheckbox("[name='q5[]']", 80); // 80: 三種混合
        if (flag) {
            $('#q5-option1').show();
        } else {
            $("[name='q5_sanshu']").attr('checked', false);
            $('#q5-option1').hide();
        }
        highlightRadio();
    }
    $("[name='q5[]']").click(function(){
        behaveAs_q5_sanshu();
    });

    // 予防接種 ⇒ 「日本脳炎」を受けた場合
    behaveAs_q5_nihon();
    function behaveAs_q5_nihon()
    {
        var flag = hasValueInCheckbox("[name='q5[]']", 90); // 90: 日本脳炎
        if (flag) {
            $('#q5-option2').show();
        } else {
            $("[name='q5_nihon']").attr('checked', false);
            $('#q5-option2').hide();
        }
        highlightRadio();
    }
    $("[name='q5[]']").click(function(){
        behaveAs_q5_nihon();
    });

    // 予防接種 ⇒ 「BCG」を受けた場合
    behaveAs_q5_bcg_text();
    function behaveAs_q5_bcg_text()
    {
        var flag = hasValueInCheckbox("[name='q5[]']", 70); // 70: BCG
        logicalTextField(flag, '#q5-option3', "[name='q5_bcg_text']");
    }
    $("[name='q5[]'], #q5_all").click(function(){
        behaveAs_q5_bcg_text();
    });

    // 予防接種 ⇒ 「特にない」
    $('#q5_9').click(function(){
        if ($(this).attr('checked')) {
            $("[name='q5[]'], #q5_all").attr('checked', false);
            $(this).attr('checked', true);

            $('#q5-option1').hide();
            $('#q5-option2').hide();
            $("[name='q5_sanshu']").attr('checked', false);
            $("[name='q5_nihon']").attr('checked', false);
        }
        highlightCheckbox();
    });

    // 予防接種 ⇒ 「特にない」以外
    $("[name='q5[]']").click(function(){
        var flag = false;
        $(this).each(function(){
            if ($(this).val() != 110) { // ! 110: 特にない 以外
                if ($(this).attr('checked')) {
                    $('#q5_9').attr('checked', false);
                    return false; // break;
                }
            } 
        });
        highlightCheckbox();
    });

    // 予防接種 ⇒ 「その他の予防接種」
    behaveAs_q5_other_text();
    function behaveAs_q5_other_text()
    {
        var flag = hasValueInCheckbox("[name='q5[]']", 100); // 100: その他
        logicalTextField(flag, '#q5-option4', "[name='q5_other_text']");
    }
    $("[name='q5[]'], #q5_all").click(function(){
        behaveAs_q5_other_text();
    });
});
</script>
