<?php

define('MAX_STEP', 3);

Factory::import('App/KiouAdult');

$step = (int)$lmd->httpPost('step', 0, '/^[0-9]+$/');
$mode = $lmd->httpPost('mode', 'next');
$answer_code = $lmd->httpPost('answer_code', $lmd->httpGet('answer_code'));
list($card_number, ) = explode('-', $answer_code);

if ($step === 0) {
    $page = 1;
} elseif ($mode === 'next') {
    $page = $step + 1;
} elseif ($mode === 'back') {
    $page = $step - 1;
} else {
    exit('invalid request.');
}

// 編集タブURL
if ($lmd->hasHttpGet('back_path')) {
    $_SESSION['kiou_edit']['back_path'] = $lmd->httpGet('back_path');
}

// カレントページ以上の選択肢情報のセッションを削除
if ($mode === 'next') {
    for ($i = $page; $i <= MAX_STEP; $i++) {
        if (isset($_SESSION['kiou_edit'][$i])) {
            unset($_SESSION['kiou_edit'][$i]);
        }
    }
}

// 選択肢情報をセッションに格納
if ($mode === 'next') {
    $prev_page = $page - 1;
    foreach ($lmd->httpPost() as $k => $v) {
        if (preg_match('/^input_[\d]+$/', $k)) {
            $_SESSION['kiou_edit'][$prev_page][$k] = $v;
        }
    }
}

// プリセットするデフォルト値
list($def, ) = KiouAdult::getDefault($card_number);
for ($i = 1; $i <= MAX_STEP; $i++) {
    if (isset($_SESSION['kiou_edit'][$i])) {
        $def = array_merge($def, $_SESSION['kiou_edit'][$i]);
    }
}

$data = KiouAdult::getData(ADULT_KIOU_SORT, ADULT_KIOU_POS, $page);
$lmd->setResponse(array(
    'DAT' => json_encode($data), 
    'DEF' => json_encode($def), 
    'age' => Answer::getOriginal('age'), 
    'answer_code' => $answer_code, 
    'back_path' => isset($_SESSION['kiou_edit']['back_path']) ? $_SESSION['kiou_edit']['back_path'] : '', 
), Lambda::INSANITATION);

$lmd->setPrep('kiou_edit.adult' . $page);



if ( ! $data) {
    // データが存在しない(本ステップの既往歴が存在しない) ⇒ 保存処理へ
    $_SESSION['kiou_edit']['answer_code'] = $answer_code;
    $_SESSION['kiou_edit']['card_number'] = $card_number;
    $lmd->redirect(WEB_ROOT.'/kiou_edit/adult/save');
}
