<?php

Factory::import('App/KiouAdult');

$answer_code = $_SESSION['kiou_edit']['answer_code'];
$card_number = $_SESSION['kiou_edit']['card_number'];

if ( ! $answer_code || ! $card_number) {
    exit('invalid request.');
}

$answers = array();
for ($i = 1; $i < 10; $i++) { // 10: 存在しない大きい数字のページ
    if (isset($_SESSION['kiou_edit'][$i])) {
        foreach ($_SESSION['kiou_edit'][$i] as $k => $v) {
            if (preg_match('/^input_[\d]+$/', $k)) {
                $answers[$k] = $v;
            }
        }
    }
}

$params = array(
    'answer_code'  => $answer_code, 
    'card_number'  => $card_number, 
    'serialized_data' => serialize($answers), 
    'diseases' => KiouAdult::getStep242Diseases($answers), 
    'reg_datetime' => date('Y-m-d H:i:s'), 
    'doctor_id' => DocCookie::getUserId(), 
);

$dao = Factory::load('DB/DAO_kiou_adult')->getInstance();
$res = $dao->insert($params);

if ($res) {
    // 登録成功
    $_SESSION['kiou_edit'] = array();
    $lmd->redirect(WEB_ROOT. '/kiou_edit/complete');
} else {
    // 登録失敗
    Javascript::backReferer('登録に失敗しました', '#ffa07a');
}
