<?php

$answer_code = $lmd->httpPost('answer_code');
list($card_number, ) = explode('-', $answer_code);

if ( ! $answer_code || ! $card_number) {
    exit('invalid request.');
}

$answers = array();
foreach ($lmd->httpPost() as $k => $v) {
    if (preg_match('/^(q[1-9]+.*|status|reason)/', $k)) {
        if (is_array($v)) {
            $answers[$k] = join(',', $v);
        } else {
            $answers[$k] = $v;
        }
    }
}

$params = array(
    'answer_code'  => $answer_code, 
    'card_number'  => $card_number, 
    'reg_datetime' => date('Y-m-d H:i:s'), 
    'doctor_id' => DocCookie::getUserId(), 
);
$params = array_merge($params, $answers);

$dao = Factory::load('DB/DAO_kiou_child')->getInstance();
$res = $dao->insert($params);

if ($res) {
    // 登録成功
    $lmd->redirect(WEB_ROOT. '/kiou_edit/complete');
} else {
    // 登録失敗
    Javascript::backReferer('登録に失敗しました', '#ffa07a');
}
