<?php

define('MAX_STEP', 3);

Factory::import('App/KiouChild');

$step = (int)$lmd->httpPost('step', 0, '/^[0-9]+$/');
$mode = $lmd->httpPost('mode', 'next');
$answer_code = $lmd->httpPost('answer_code', $lmd->httpGet('answer_code'));
list($card_number, ) = explode('-', $answer_code);

if ($step === 0) {
    $page = 1;
} elseif ($mode === 'next') {
    $page = $step + 1;
} elseif ($mode === 'back') {
    $page = $step - 1;
} else {
    exit('invalid request.');
}

// 編集タブURL
if ($lmd->hasHttpGet('back_path')) {
    $_SESSION['kiou_edit']['back_path'] = $lmd->httpGet('back_path');
}

// カレントページ以上の選択肢情報のセッションを削除
if ($mode === 'next') {
    for ($i = $page; $i <= MAX_STEP; $i++) {
        if (isset($_SESSION['kiou_edit'][$i])) {
            unset($_SESSION['kiou_edit'][$i]);
        }
    }
}

// 選択肢情報をセッションに格納
if ($mode === 'next') {
    $prev_page = $page - 1;
    foreach ($lmd->httpPost() as $k => $v) {
        if (preg_match('/^(q[1-9]+.*|status|reason)/', $k)) {
            if (is_array($v)) {

                // 配列の場合

                // 不要
                if ($k === 'q17_disease_y' || $k === 'q17_disease_m') continue;

                if ($k === 'q17_disease') {
                    // 「Q17. 入院するような大きな病気...」
                    $v = serialize(
                            KiouChild::mkQ17($lmd->httpPost('q17_disease', array()), 
                                $lmd->httpPost('q17_disease_y', array()), 
                                $lmd->httpPost('q17_disease_m', array())
                            )
                        );
                } elseif ($k === 'q17_disease_text') {
                    // 「Q17. 「その他」の場合、ご入力ください」
                    $v = serialize(
                            KiouChild::mkQ17text($lmd->httpPost('q17_other_text', NULL), 
                                $lmd->httpPost('q17_other_text_y', NULL), 
                                $lmd->httpPost('q17_other_text_m', NULL)
                            )
                        );
                } else {
                    foreach ($v as $val) {
                        if ($val !== '') {
                            // 空値以外、カンマ区切りに変換
                            $v = join(',', $v);
                            break;
                        }
                    }
                }
            }

            $_SESSION['kiou_edit'][$prev_page][$k] = $v;
        }
    }
}

// プリセットするデフォルト値
$dao = Factory::load('DB/DAO_kiou_child')->getInstance();
$def = $dao->fetchNewest_BY_card_number($card_number);
for ($i = 1; $i <= MAX_STEP; $i++) {
    if (isset($_SESSION['kiou_edit'][$i])) {
        $def = array_merge($def, $_SESSION['kiou_edit'][$i]);
    }
}



$lmd->setResponse(array(
    'v' => $def,
    'card_number' => $card_number,
    'answer_code' => $answer_code, 
    'back_path' => isset($_SESSION['kiou_edit']['back_path']) ? $_SESSION['kiou_edit']['back_path'] : '', 
));
$lmd->setResponse(array(
    'q17_disease'    => isset($def['q17_disease']) ? $def['q17_disease'] : '',
    'q17_other_text' => isset($def['q17_other_text']) ? $def['q17_other_text'] : '',
), Lambda::INSANITATION);

$lmd->setPrep('kiou_edit.child.internal' . $page);



if ($page > MAX_STEP) {
    // ページ(ステップ)が存在しない ⇒ 保存処理へ
    $_SESSION['kiou_edit']['answer_code'] = $answer_code;
    $_SESSION['kiou_edit']['card_number'] = $card_number;
    $lmd->redirect(WEB_ROOT.'/kiou_edit/child/internal/save');
}
