<?php

$answer_code = $_SESSION['kiou_edit']['answer_code'];
$card_number = $_SESSION['kiou_edit']['card_number'];

if ( ! $answer_code || ! $card_number) {
    exit('invalid request.');
}

$answers = array();
for ($i = 1; $i < 10; $i++) { // 10: 存在しない大きい数字のページ
    if (isset($_SESSION['kiou_edit'][$i])) {
        foreach ($_SESSION['kiou_edit'][$i] as $k => $v) {
            if (preg_match('/^(q[1-9]+.*|status|reason)/', $k)) {
                $answers[$k] = $v;
            }
        }
    }
}

$params = array(
    'answer_code'  => $answer_code, 
    'card_number'  => $card_number, 
    'reg_datetime' => date('Y-m-d H:i:s'), 
    'doctor_id' => DocCookie::getUserId(), 
);
$params = array_merge($params, $answers);

$dao = Factory::load('DB/DAO_kiou_child')->getInstance();
$res = $dao->insert($params);

if ($res) {
    // 登録成功
    $_SESSION['kiou_edit'] = array();
    $lmd->redirect(WEB_ROOT. '/kiou_edit/complete');
} else {
    // 登録失敗
    Javascript::backReferer('登録に失敗しました', '#ffa07a');
}
