<?php
/**
 * step2
 */
$year  = $lmd->httpPost('year');
$month = $lmd->httpPost('month');
$day   = $lmd->httpPost('day');

$life_days = _calcLifeDays($year, $month, $day);
list($age, $age_m) = _getAgeAndMonth($life_days);

$prev_step = 1;
$step      = 2;
$next_step = _isChild($age) ? 3 : 241;

Answer::removeForwardAnswer($step);

if ($lmd->hasHttpPost('back')) {
    // do nothing.
} elseif ((int)$lmd->httpPost('next_step') === $step) {
    Answer::set($prev_step, array(
        'year'  => $year, 
        'month' => $month, 
        'day'   => $day, 
        'gender'  => $lmd->httpPost('gender'), 
        'weight'  => $lmd->httpPost('weight_int') . '.' . $lmd->httpPost('weight_float'), 
        'nowtemp' => $lmd->httpPost('nowtemp'), 
        'maxtemp' => $lmd->httpPost('maxtemp'), 
        'fromtemp' => $lmd->httpPost('fromtemp'), 
        'card_number_in_agent' => $lmd->httpPost('card_number_in_agent', ''), 
    ));
} else {
    _invalidRequest();
}

Answer::set($step, array(
    'life_days' => $life_days,
    'age' => $age,
    'age_m' => $age_m,
));

$qa = Factory::load('App/QA')->getInstance();
$questions = $qa->step2_getQuestions($life_days, $category_id);
$answers   = $qa->step2_getAnswers($questions, $category_id);
//_Ve($questions, $answers);
$lmd->setResponse(array(
    'prev_step' => $prev_step, 
    'step'      => $step, 
    'next_step' => $next_step, 
    'questions' => $questions, 
    'answers'   => $answers, 
    'zenshin_category_id' => $category_id,
));

Answer::set($step, array(
    'zenshin_category_id' => $category_id,
));

// for Doctor.
$lmd->setResponse(array(
    'orig_answers' => explode(',', Answer::getOriginal("step{$step}_answers", null, '')),
    'orig_isGoin' => Answer::getOriginal('isGoin'),
));

// child | adult
if (_isChild()) {
    $lmd->setPrep("step{$step}.child");
} else {
    $lmd->setPrep("step{$step}.adult");
}
