<?php
/**
 * step231
 * 患者側 : 外傷一般QA 設問画面
 */

if (Answer::get(233, 'isKotsu')) {
    // 交通フラグがあれば、遷移元はstep234となる(救急外傷経路:step232>233>234)...
    $prev_step = 234;
} else {
    $prev_step = 233;
}
$step      = 231;
$next_step = 4;

//Answer::removeForwardAnswer($step);
Answer::set($next_step, array('answers' => array())); // 232>233>231と番号が矛盾した遷移に対応

if ($lmd->hasHttpPost('back')) {
    // do nothing.
} elseif ((int)$lmd->httpPost('next_step') === $step // 詳細項目画面入力あり
	    || (int)$lmd->httpGet('next_step') === $step // 詳細項目画面スキップ
        ) {
    $answers = array();
    foreach ($lmd->httpPost("step{$prev_step}", array()) as $q => $v) {
        $answers[$q] = $v;
    }
    Answer::set($prev_step, array('answers' => $answers));
} else {
    _invalidRequest();
}

$dao = Factory::load('DB/DAO_body_condition2_question')->getInstance();

$selection = $dao->fetchAllBodyCondition2QuestionWithAnswerSelection();
$questions = $answers = array();
foreach ($selection as $val) {
    $questions[$val['body_condition2_question_id']] = array(
            'body_condition2_question_id' => $val['body_condition2_question_id'],
            'question_name' => $val['question_name'],
            'select_type' => $val['select_type'],
    );
    $answers[$val['body_condition2_question_id']][] = $val;
}

$lmd->setResponse(array(
    'prev_step' => $prev_step, 
    'step'      => $step, 
    'next_step' => $next_step, 
    'questions' => $questions, 
    'answers'   => $answers, 
    'ishiki' => Answer::get(2, 'isIshiki'),
));

// for Doctor.
$lmd->setResponse(array(
    'orig_answers' => explode(',', Answer::getOriginal("step{$step}_answers", null, '')),
));
