<?php
/**
 * step234
 * 患者側 : 交通外傷 詳細画面
 */
$prev_step = 233;
$step      = 234;
$next_step = 231; // 外傷一般QAへ

$step235_answers = Answer::get(235, 'answers'); // 以下で削除されてしまうので一時退避
Answer::removeForwardAnswer($step);
Answer::set(235, array('answers' => $step235_answers)); // 退避データを再度セット

if ($lmd->hasHttpPost('back')) {
    // do nothing.
} elseif ((int)$lmd->httpPost('next_step') === $step) {
    $answers = array();
    foreach ($lmd->httpPost("step{$prev_step}", array()) as $q => $v) {
        $answers[$q] = $v;
    }
    Answer::set($prev_step, array('answers' => $answers));
    $isKotsu = $lmd->hasHttpPost('isKotsu') ? 1 : 0;
    Answer::set($prev_step, array('isKotsu' => $isKotsu));
} else {
    _invalidRequest();
}

$type_id = $lmd->httpPost('step233');

// {{{ 交通外傷の回答項目と各詳細への質問ID
// 回答ID  回答項目名                   質問ID
// 559     歩行者　対　自転車           19
// 560     歩行者　対　自動車/自動２輪  20
// 561     自転車　対　自転車           21
// 562     自転車　対　自動車/自動２輪  22
// 563     自動車　対　自動車/自動２輪  23
// 564     列車                         24
// 565     その他の車両                 25
// 以下配列にて管理します。
$koutsu_quest = array(
    559 => 19,
    560 => 20,
    561 => 21,
    562 => 22,
    563 => 23,
    564 => 24,
    565 => 25,
);
$koutsu_type_id = array();
foreach ($type_id as $val) {
    if (! is_array($val) && isset($koutsu_quest[$val])) {
        // $valが配列の場合は無視する(複数選択[部位など]の質問は交通外傷とは関係なし)
        $koutsu_type_id[] = $koutsu_quest[$val];
    }
}
// }}}

$dao = Factory::load('DB/DAO_external_injury_question')->getInstance();
$selection = $dao->fetchAllExternalInjuryQuestionWithAnswerSelection($koutsu_type_id);
$injurys = $questions = $answers = array();
foreach ($selection as $val) {
    $questions[$val['external_injury_question_id']] = array('external_injury_question_id' => $val['external_injury_question_id'], 'question_name' => $val['question_name'], 'external_injury_type_id' => $val['external_injury_type_id']);
    $answers[$val['external_injury_question_id']][] = $val;
    $injurys[$val['external_injury_type_id']] = $val['type_name'];
}

$lmd->setResponse(array(
    'prev_step' => $prev_step, 
    'step'      => $step, 
    'next_step' => $next_step, 
    'injurys' => $injurys, 
    'questions' => $questions, 
    'answers'   => $answers, 
));

// for Doctor.
$lmd->setResponse(array(
    'orig_answers' => explode(',', Answer::getOriginal("step{$step}_answers", null, '')),
));
