<?php
/**
 * step235
 * 患者側 : 救急外傷 共通画面
 */
$prev_step = 232;
$step      = 235;
$next_step = 233; // 外傷詳細へ

Answer::removeForwardAnswer($step);

if ($lmd->hasHttpPost('back')) {
    // do nothing.
} elseif ((int)$lmd->httpPost('next_step') === $step) {
    $answers = array();
    foreach ($lmd->httpPost("step{$prev_step}", array()) as $q => $v) {
        $answers[$q] = $v;
    }
    Answer::set($prev_step, array('answers' => $answers));
} else {
    _invalidRequest();
}

$type_id = $lmd->httpPost('step232');

$con = Factory::load('DB/DAO_external_injury_common')->getInstance();
$que = Factory::load('DB/DAO_external_injury_question')->getInstance();
$selection = $con->fetchAllNameListByType($type_id);

// 共通項目スキップ処理
if (empty($selection)) {
    // If no common question for type_id, then skip to next step...
    $lmd->redirect(APP_ROOT . '/step' . $next_step . '?next_step=' . $next_step);
}

$parts = $con->fetchPartsList();
$parts_list = $parts_group = array();
foreach ($parts as $val) {
    $parts_list[$val['external_injury_parts_id']] = $val;
    $parts_group[$val['external_injury_group_id']] = $val['external_injury_group_name'];
    $parts_group[$val['external_injury_group_id']] = $val['external_injury_group_name'];
    $parts_group[$val['external_injury_group_id']] = $val['external_injury_group_name'];
}

$questions = $answers = array();
foreach ($selection as $val) {
    foreach ($type_id as $id) {
        $cname = 'type' . $id;
        if (! empty($val[$cname])) {
            $answer_id = $val[$cname];
            break;
        }
    }
    if ($val['kind'] == 1) { // 部位の場合
        $val['external_injury_group_id'] = $parts_list[$val['common_num']]['external_injury_group_id'];
        $val['external_injury_group_name'] = $parts_list[$val['common_num']]['external_injury_group_name'];
    }
    $question = $que->fetchExternalInjuryQuestionByAnswerId($answer_id);
    $questions[$val['kind']] = array(
                'kind' => $val['kind'],
                'question_name' => $question['question_name'],
                'external_injury_type_id' => $question['external_injury_type_id'],
                'select_type' => $question['select_type'],
                );
    $answers[$val['kind']][] = $val;
}

$parts = Factory::load('App/Parts')->getInstance();
$parts_question = array();
foreach ($parts->map as $key => $val) {
    if ($key == 18) { continue; } // 交通外傷はスキップ
    $parts_question[$val] = $key;
}



$lmd->setResponse(array(
    'prev_step' => $prev_step, 
    'step'      => $step, 
    'next_step' => $next_step, 
    'questions' => $questions, 
    'answers'   => $answers, 
    'parts_group' => $parts_group,
    'parts_question' => $parts_question,
));

// for Doctor.
$lmd->setResponse(array(
    'orig_answers' => explode(',', Answer::getOriginal("step{$step}_answers", null, '')),
));
