<?php
/**
 * step241: 大人(16歳以上)専用の既往歴1
 */

Factory::import('App/KiouAdult');

$prev_step = 2;
$step      = 241;
$next_step = 242;

Answer::removeForwardAnswer($step);

if ($lmd->hasHttpPost('back')) {
    // do nothing.
} elseif ((int)$lmd->httpPost('next_step') === $step) {
    Answer::step2_answer2session($lmd);
} else {
    _invalidRequest();
}

if (_isAgent() || _isDoctor()) {
    // 代理入力 | ドクター
    $lmd->redirect(APP_ROOT . '/step3');
}

$lmd->setResponse(array(
    'prev_step' => $prev_step, 
    'step'      => $step, 
    'next_step' => $next_step, 
));



$card_number = Answer::get(0, 'card_number');
list($def, $reg_date) = KiouAdult::getDefault($card_number);
$lmd->setResponse(array(
    'is_repeater' => $def ? true : false,
    'reg_date' => $reg_date,
));

$sort    = ADULT_KIOU_SORT;
$pos_use = ADULT_KIOU_POS;
$pos_val = 1;
$data = KiouAdult::getData($sort, $pos_use, $pos_val);

$DAT = json_encode($data);
$DEF = json_encode($def);

$lmd->setResponse(array(
    'DAT' => $DAT, 
    'DEF' => $DEF, 
    'age' => Answer::get(2, 'age'), 
), Lambda::INSANITATION);
