<?php
/**
 * step3: 内因専用：気になる症状 x ３つ
 */
$prev_step = 2;
//if ( ! _isChild()) {
//   $prev_step = 242;
//}
if (_isChild()) {
    if (Answer::get(2, 'isGaisho')) $prev_step = 212;
    if (Answer::get(2, 'isGoin'))   $prev_step = 22;
} else {
   $prev_step = 242;
}
$step      = 3;
$next_step = _isChild() ? 451 : 41;

//if (Answer::get(2, 'isGaisho') || Answer::get(2, 'isGoin')) {
//    // 外傷、誤飲フラグがあれば、遷移先を step* とする
//    $next_step = '*'; //暫定
//}

Answer::removeForwardAnswer($step);

// 内因のため、外傷、誤飲フラグを落とす
//Answer::set(2, array('isGaisho' => 0, 'isGoin' => 0)); // <- 製品版では必要なので無効に...

if ($lmd->hasHttpPost('back')) {
    // do nothing.
} elseif (_isAgent() || _isDoctor() || (int)$lmd->httpPost('next_step') === $step) {
    // ドクター「修正」／代理入力は無条件で通す。
    switch ($prev_step) {
        case 2:
            Answer::step2_answer2session($lmd);
            break;

        case 212:
            Answer::step212_answer2session($lmd);
            break;

        case 22:
            $answers = array();
            foreach ($lmd->httpPost("step{$prev_step}", array()) as $v) {
                $answers[] = $v;
            }
            Answer::set($prev_step, array('answers' => $answers));
            break;

        case 242:
            $answers = array();
            foreach ($lmd->httpPost() as $k => $v) {
                if (preg_match('/^input_(\d+)$/', $k, $c)) {
                    $answers[$c[0]] = $v;
                }
            }
            Answer::set($prev_step, array('answers' => $answers));
            break;
    }
} else {
    _invalidRequest();
}

$dao = Factory::load(_isChild() ? 'DB/DAO_monshin_child' : 'DB/DAO_monshin_adult')->getInstance();

$life_days = Answer::get(2, 'life_days');
$gender    = Answer::get(1, 'gender');

$arr = $dao->step3_getCategoryId($life_days, $gender);
$category_id = isset($arr['CategoryID']) ? $arr['CategoryID'] : '';

$items = $dao->step3_getDiseaseItems($category_id);

$lmd->setResponse(array(
    'prev_step' => $prev_step, 
    'step'      => $step, 
    'next_step' => $next_step, 
    'items' => $items, 
    'nowtemp' => Answer::get(1, 'nowtemp'),
    'maxtemp' => Answer::get(1, 'maxtemp'),
));

Answer::set($step, array(
    'shojo_category_id' => $category_id,
));

// for Doctor.
$lmd->setResponse(array(
    'orig_answers' => explode(',', Answer::getOriginal("step{$step}_answers", null, '')),
    'primaryShojo' => Answer::getOriginal("primaryShojo", null, ''),
    'isNotShojo'   => Answer::getOriginal("isNotShojo", null, ''),
    's3_other_disease' => Answer::getOriginal("s3_other_disease", null, ''),
    's3_other_disease_flg' => Answer::getOriginal("s3_other_disease_flg", null, ''),
));

// child | adult
if (_isChild()) {
    $lmd->setPrep("step{$step}.child");
} else {
    $lmd->setPrep("step{$step}.adult");
}
