<?php
/**
 * step4
 */

$prev_step = $lmd->httpPost('isNotShojo') ? 3 : 31;
//if (Answer::get(2, 'isGaisho') || Answer::get(2, 'isGoin')) {
//    // 外傷、誤飲フラグがあれば、遷移元はstep231となる(救急外傷経路:step232>233>{234>}231)...
//    $prev_step = 231;
//}
$step      = 4;
$next_step = 5;

Answer::removeForwardAnswer($step);

if ($lmd->hasHttpPost('back')) {
    // do nothing.
} elseif (_isAgent()) {
    // 代理入力
    if ($prev_step === 3) {
        Answer::step3_answer2session($lmd);
    } elseif ($prev_step === 31) {
        Answer::step31_answer2session($lmd);
    } elseif ($prev_step === 231) {
        // 救急外傷(外傷、誤飲)が遷移元の場合...
        Answer::step231_answer2session($lmd);
    }
    $lmd->redirect(APP_ROOT . '/step5');
} elseif ((int)$lmd->httpPost('next_step') === $step) {
    if ($prev_step === 3) {
        Answer::step3_answer2session($lmd);
    } elseif ($prev_step === 31) {
        Answer::step31_answer2session($lmd);
    //} elseif ($prev_step === 231) {
    //    // 救急外傷(外傷、誤飲)が遷移元の場合...
    //    Answer::step231_answer2session($lmd);
    }
} else {
    // 矛盾が生じるため、不要。
    //_invalidRequest();
}

$lmd->setResponse(array(
    'prev_step' => $prev_step, 
    'step'      => $step, 
    'next_step' => $next_step, 
));



$fh_id = $lmd->httpGet('fh_id');
if (_isDoctor() && ! $fh_id) {
    // ドクター側で「修正」を通してこのステップ(既往)に来た場合は次のステップ(step5)に強制リダイレクト
    //  ※パラメーター「fh_id(family_history_id)」が存在しない場合は「修正」からの遷移と見なす
    $lmd->redirect(APP_ROOT . '/step5');
}



if (_isDoctor()) {
    // ドクター側からの家族歴修正
    list($card_number, ) = explode('-', $_answer_code);
} else {
    // 患者側からの通常遷移
    $card_number = Answer::get(0, 'card_number');
}

$res = array();
$reg_date = '';
if ($card_number) {
    $dao = Factory::load(_isChild() ? 'DB/DAO_kiou_child' : 'DB/DAO_kiou_adult')->getInstance();
    $res = $dao->fetchNewest_BY_card_number($card_number);
    if ($res) {
        list($reg_date, ) = explode(' ', $res['reg_datetime']);
        $reg_date = str_replace('-', '/', $reg_date);
    }
}


// {{{ 外傷ルートの場合予防接種の回答を既往画面と連携する
if (Answer::get(2, 'isGaisho') || Answer::get(2, 'isGoin')) {
    $res = $res ? $res : array('q5' => '');
    $step231_ans = Answer::get(231, 'answers');
    // Q12.DPT（または破傷風注射）は完了していますか？
    switch ($step231_ans[13]) {
        case 43 : // DPTは完了していない
            $res['q5_sanshu'] = 10;
            break;
        case 44 : // DPTはすでに3回以上接種している
            $res['q5_sanshu'] = 20;
            $res['q5'] .= ',80'; // 三種混合チェック
            break;
        case 45 : // DPT3回接種（または破傷風注射）から5年以上経過している
            $res['q5_sanshu'] = 30;
            $res['q5'] .= ',80'; // 三種混合チェック
            break;
        case 46 : // DPT3回接種（または破傷風注射）から１０年以上経過している・全く接種なし
            $res['q5_sanshu'] = 40;
            $res['q5'] .= ',80'; // 三種混合チェック
            break;
        default :
    }
    $res['q5'] = ltrim($res['q5'], ',');
}
// }}}

$lmd->setResponse(array(
    'is_repeater' => $res ? true : false,
    'reg_date' => $reg_date,
    'v' => $res,
    'card_number' => $card_number,

    'fh_id' => $fh_id, 
));

if (_isDoctor()) {
    // ドクター側からの家族歴修正
    $lmd->setPrep('step4.doctor');
}
