<?php
/**
 * step41: 大人(16歳以上)専用の既往歴3
 */

Factory::import('App/KiouAdult');

$prev_step = $lmd->httpPost('isNotShojo') ? 3 : 31;
$step      = 41;
$next_step = 5;

Answer::removeForwardAnswer($step);

if ($lmd->hasHttpPost('back')) {
    // do nothing.
} elseif (_isAgent()) {
    // 代理入力
    $lmd->redirect(APP_ROOT . '/step5');
} elseif ((int)$lmd->httpPost('next_step') === $step) {
    if ($prev_step === 3) {
        Answer::step3_answer2session($lmd);
    } elseif ($prev_step === 31) {
        $answers = $when = array();
        foreach ($lmd->httpPost("step{$prev_step}", array()) as $val) foreach ($val as $v) {
            $answers[] = $v;
        }
        foreach ($lmd->httpPost('when', array()) as $k => $v) {
            $when[] = "{$k}:{$v}";
        }
        Answer::set($prev_step, array('answers' => $answers));
        Answer::set($prev_step, array('when' => $when));

        if ($lmd->hasHttpPost('fever')) {
            foreach ($lmd->httpPost('fever') as $v) {
                $fever_answers[] = $v;
            }
            Answer::set($prev_step, array('fever_answers' => $fever_answers));
        }
    } elseif ($prev_step === 231) {
        // 救急外傷(外傷、誤飲)が遷移元の場合...
        $answers = array();
        foreach ($lmd->httpPost("step{$prev_step}", array()) as $q => $v) {
            $answers[$q] = $v;
        }
        Answer::set($prev_step, array('answers' => $answers));
    }

    if (_isDoctor()) {
        $lmd->redirect(APP_ROOT . '/step5');
    }

} elseif (_isDoctor()) {
    // ドクター側で「修正」を通してこのステップ(既往)に来た場合は次のステップ(step5)に強制リダイレクト
    //  ※パラメーター「fh_id(family_history_id)」が存在しない場合は「修正」からの遷移と見なす
    if ( ! $lmd->hasHttpGet('fh_id')) {
        $lmd->redirect(APP_ROOT . '/step5');
    } else {
        // ドクター側からの家族歴修正
        $DOCTOR_FAMILY_HISTORY_EDIT_MODE = true;
    }
} else {
    _invalidRequest();
}

$lmd->setResponse(array(
    'prev_step' => $prev_step, 
    'step'      => $step, 
    'next_step' => $next_step, 
));



$card_number = Answer::get(0, 'card_number');
list($def, $reg_date) = KiouAdult::getDefault($card_number);
$lmd->setResponse(array(
    'is_repeater' => $def ? true : false,
    'reg_date' => $reg_date,
));

$sort    = ADULT_KIOU_SORT;
$pos_use = ADULT_KIOU_POS;
$pos_val = 3;
$data = KiouAdult::getData($sort, $pos_use, $pos_val);

if ( ! $data) {
    // 既往歴3 を聞かない施設の場合
    $lmd->redirect(APP_ROOT . '/step5');
}

$DAT = json_encode($data);
$DEF = json_encode($def);

$lmd->setResponse(array(
    'DAT' => $DAT, 
    'DEF' => $DEF, 
    'age' => Answer::get(2, 'age'), 
), Lambda::INSANITATION);

