<?php
/**
 * step5
 */

Factory::import('App/KiouAdult');
Factory::import('App/KiouChild');

$prev_step = _isChild() ? 453 : 41;
$step      = 5;
$next_step = 6;

Answer::removeForwardAnswer($step);

// {{{ 緊急フローの処理
if ($lmd->hasHttpPost('isKinkyu')) {
    $prev_step = 2; // 前画面は全身状態
    Answer::step2_answer2session($lmd);
}
// }}}

if ($prev_step === 453) {
    $arr = array();
    foreach ($lmd->httpPost() as $k => $v) {
        if (preg_match('/^(q[1-9]+|status|reason)/', $k)) {
            $arr[$k] = $v;
        }
    }
    Answer::set($prev_step, $arr);
}

$card_number  = Answer::get(0, 'card_number');
// {{{ 代理入力からの診察券番号入力の処理
$card_number_in_agent  = Answer::get(1, 'card_number_in_agent');
if ($card_number_in_agent !== '') {
    $card_number = $card_number_in_agent;
}
// }}}

$answer_code  = $card_number . '-' . date('YmdHis');
$now_datetime = date('Y-m-d H:i:s');

if ( ! $card_number) {
    Javascript::redirect(APP_ROOT . '/', '[error:101] 診察券番号が正しくありません');
}
if (_isDoctor() && ! _isAgent()) {
    if ( ! Answer::getOriginal('answer_code')) exit('[error:102] invalid answer_code.');
    if ( ! Answer::getOriginal('version')) exit('[error:103] invalid version.');
    if ( ! DocCookie::getUserId()) exit('[error:104] invalid AdminUserId.');
}

// {{{ 外傷ルートの回答値調整
//$parts = Factory::load('App/Parts')->getInstance();
//$step233_answers = parseExternalAnswers(Answer::get(233, 'answers'));
//$step231_answers = parseExternalAnswers(Answer::get(231, 'answers'));
//$step235_answers = parseExternalAnswers(Answer::get(235, 'answers'));
//function parseExternalAnswers($answers)
//{
//    $res = array();
//    foreach ((array)$answers as $key => $val) {
//        if (is_array($val)) {
//            $res[] = implode(',', $val);
//        } else {
//            $res[] = $val;
//        }
//    }
//    return implode(',', $res);
//}
// }}}
$params = array();
$params['answers'] = array(
    'answer_code'          => (_isDoctor() && ! _isAgent()) ? Answer::getOriginal('answer_code') : $answer_code, 
    'card_number'          => $card_number, 
    'birth_y'              => Answer::get(1, 'year'), 
    'birth_m'              => Answer::get(1, 'month'), 
    'birth_d'              => Answer::get(1, 'day'), 
    'gender_div_id'        => Answer::get(1, 'gender'), 
    'weight'               => Answer::get(1, 'weight'), 
    'nowtemp'              => Answer::get(1, 'nowtemp'), 
    'maxtemp'              => Answer::get(1, 'maxtemp'), 
    'fromtemp_div_id'      => Answer::get(1, 'fromtemp'), 
    'life_days'            => Answer::get(2, 'life_days'), 
    'age'                  => Answer::get(2, 'age'), 
    'age_m'                => Answer::get(2, 'age_m'), 
    'zenshin_category_id'  => Answer::get(2, 'zenshin_category_id'), 
    'shojo_category_id'    => Answer::get(3, 'shojo_category_id'), 
    'isGaisho'             => Answer::get(2, 'isGaisho'), 
    'isGoin'               => Answer::get(2, 'isGoin'), 
    'isNotShojo'           => Answer::get(3, 'isNotShojo'), 
    'primaryShojo'         => Answer::get(3, 'primaryShojo'), 
    's3_other_disease'     => Answer::get(3, 's3_other_disease'), 
    's3_other_disease_flg' => Answer::get(3, 's3_other_disease_flg'), 
    's3_no_disease_flg'    => Answer::get(3, 's3_no_disease_flg'), 
    'step2_answers'        => join(',', Answer::get(2, 'answers', array())), 
    'step211_answers'      => join(',', Answer::get(211, 'answers', array())), 
    'step212_answers'      => join(',', Answer::get(212, 'answers', array())), 
    'step22_answers'       => join(',', Answer::get(22, 'answers', array())), 
    //'step231_answers'      => $step231_answers,
    //'step232_answers'      => join(',', Answer::get(232, 'answers', array())), 
    //'step233_answers'      => $step233_answers,
    //'step234_answers'      => join(',', Answer::get(234, 'answers', array())), 
    //'step235_answers'      => $step235_answers,
    'step3_answers'        => join(',', Answer::get(3, 'answers', array())), 
    'step31_answers'       => join(',', Answer::get(31, 'answers', array())), 
    'step31_when'          => join(',', Answer::get(31, 'when', array())), 
    'fever_answers'        => join(',', Answer::get(31, 'fever_answers', array())), 
    //'parts_answers'        => $parts->getSerializedPartsData(Answer::get(235, 'answers')),
    'version'              => (_isDoctor() && ! _isAgent()) ? Answer::getOriginal('version') + 1 : 1,  
    'doctor_id'            => _isDoctor() ? DocCookie::getUserId() : NULL, 
    'serialized'           => serialize(Answer::get()), 
    'answer_datetime'      => (_isDoctor() && ! _isAgent()) ? Answer::getOriginal('answer_datetime') : $now_datetime, 
    'reg_datetime'         => $now_datetime, 
);

// これは成育用なので目黒用ポート確認取得情報は無効にします。
//if (! _isDoctor()) {
//    $params['patient_code'] = array(
//        'card_number'  => Answer::get(0, 'card_number'),
//        'patient_code' => Answer::get(0, 'patient_code'),
//        'insurance_no' => Answer::get(0, 'insurance_no'),
//        'insurance_name' => Answer::get(0, 'insurance_name'),
//    );
//}

if (_isChild()) {

    function getKiouVal($key, $fallback = '')
    {
        static $ret;

        $kiou_step_map = array(451, 452, 453);

        if ($ret === null) {
            $ret = array();
            foreach (array_keys(Answer::get()) as $kiou_key) {
                if (in_array($kiou_key, $kiou_step_map)) {
                    foreach (Answer::get($kiou_key) as $k => $v) {
                        $ret[$k] = $v;
                    }
                }
            }

        }

        return (isset($ret[$key])) ? $ret[$key] : $fallback;
    }

    $q12_family = function ()
    {
        $disease_names = getKiouVal('q12_family_text');
        $ret = array();
        foreach (getKiouVal('q12_family', array()) as $k => $v) {
            $ret[] = array('id' => $v, 'disease_name' => $disease_names[$k]);
        }
        return serialize($ret);
    };

    $q13_family = function ()
    {
        $allergy_names = getKiouVal('q13_family_text');
        $ret = array();
        foreach (getKiouVal('q13_family', array()) as $k => $v) {
            $ret[] = array('id' => $v, 'allergy_name' => $allergy_names[$k]);
        }
        return serialize($ret);
    };

    // {{{ 外傷ルートの場合の既往情報調整
    if (Answer::get(2, 'isGaisho') || Answer::get(2, 'isGoin')) {
        // 外傷の場合
        $step231_ans = Answer::get(231, 'answers');
        $q9 = (isset($step231_ans[11]) && $step231_ans[11] == 39) ? 10 : 20; // 39:yes(10), 38:no(20)
        $q9_medicine_text = in_array(40, isset($step231_ans[12]) ? $step231_ans[12] : array()) ? 'あり' : '';
        $q9_food_text     = in_array(41, isset($step231_ans[12]) ? $step231_ans[12] : array()) ? 'あり' : '';
        $q9_contact_text  = in_array(42, isset($step231_ans[12]) ? $step231_ans[12] : array()) ? 'あり' : '';
        // 常用薬はありますか？
        $q16              = isset($step231_ans[16]) ? ($step231_ans[16] == 73 ? 10 : 20) : NULL; // 73:yes(10), 74:no(20)
        $q16_medicine     = NULL;
        if (isset($step231_ans[17])) {
            $tmp_17 = array();
            $tmp_q16_mdc = array(74=>10, 75=>20, 76=>30, 77=>40, 78=>50);
            for ($i = 74; $i <= 78; $i++) {
                if (in_array($i, $step231_ans[17])) {
                    $tmp_17[] = $tmp_q16_mdc[$i];
                }
            }
            $q16_medicine     = join(',', $tmp_17);
        }
        // 既往歴はありますか？
        $q17 = isset($step231_ans[14]) ? ($step231_ans[14] == 48 ? 10 : 20) : NULL; // 48:yes(10), 47:no(20)
        $tmp_15 = array();
        if (isset($step231_ans[15])) {
            $tmp_q17_dis = array(
                    49 => 210, 50 => 220, 51 => 230, 52 => 10,
                    53 => 20,  54 => 30,  55 => 40,  56 => 50,
                    57 => 60,  58 => 70,  59 => 80,  60 => 90,
                    61 => 100, 62 => 110, 63 => 120, 64 => 130,
                    65 => 140, 66 => 150, 67 => 160, 68 => 170,
                    69 => 180, 70 => 190, 71 => 200,
                            );
            for ($i = 49; $i <= 71; $i++) {
                if (in_array($i, $step231_ans[15])) {
                    $tmp_15[] = $tmp_q17_dis[$i];
                }
            }
        }
        $q17_disease      = serialize(
                                  KiouChild::mkQ17($tmp_15, 
                                        getKiouVal('q17_disease_y', array()), 
                                        getKiouVal('q17_disease_m', array())
                                  )
                            );
    } else {
        // 内因の場合
        $q9 = getKiouVal('q9', NULL);
        $q9_medicine_text = getKiouVal('q9_medicine_text', NULL);
        $q9_food_text     = getKiouVal('q9_food_text', NULL);
        $q9_contact_text  = getKiouVal('q9_contact_text', NULL);
        $q16              = getKiouVal('q16', NULL);
        $q16_medicine     = join(',', getKiouVal('q16_medicine', array()));
        $q17              = getKiouVal('q17', NULL);
        $q17_disease      = serialize(
                                  KiouChild::mkQ17(getKiouVal('q17_disease', array()), 
                                        getKiouVal('q17_disease_y', array()), 
                                        getKiouVal('q17_disease_m', array())
                                  )
                            );
    }
    // }}}

    $params['kiou'] = array(
        'answer_code'      => $answer_code, 
        'card_number'      => $card_number, 
        'status'           => getKiouVal('status', NULL), 
        'reason'           => getKiouVal('reason', NULL), 
        'q1'               => getKiouVal('q1', NULL), 
        'q1_a'             => join(',', getKiouVal('q1_a', array())), 
        'q1_a_text'        => getKiouVal('q1_a_text', NULL), 
        'q2_text'          => getKiouVal('q2_text', NULL), 
        'q3'               => getKiouVal('q3', NULL), 
        'q3_text'          => getKiouVal('q3_text', NULL), 
        'q4'               => getKiouVal('q4', NULL), 
        'q4_text'          => getKiouVal('q4_text', NULL), 
        'q5'               => join(',', getKiouVal('q5', array())), 
        'q5_sanshu'        => getKiouVal('q5_sanshu', NULL), 
        'q5_nihon'         => getKiouVal('q5_nihon', NULL), 
        'q5_bcg_text'      => getKiouVal('q5_bcg_text', NULL), 
        'q5_other_text'    => getKiouVal('q5_other_text', NULL), 
        'q6'               => join(',', getKiouVal('q6', array())), 
        'q6_text'          => getKiouVal('q6_text', NULL), 
        'q7'               => join(',', getKiouVal('q7', array())), 
        'q7_text'          => getKiouVal('q7_text', NULL), 
        'q8'               => getKiouVal('q8', NULL), 
        'q8_text'          => getKiouVal('q8_text', NULL), 
        'q9'               => $q9,
        'q9_medicine_text' => $q9_medicine_text,
        'q9_food_text'     => $q9_food_text,
        'q9_contact_text'  => $q9_contact_text,
        'q15'              => join(',', getKiouVal('q15', array())), 
        'q15_text'         => getKiouVal('q15_text', NULL), 
        'q16'              => $q16,
        'q16_medicine'     => $q16_medicine,
        'q16_other_text'   => getKiouVal('q16_other_text', NULL), 
        'q17'              => $q17,
        'q17_disease'      => $q17_disease,
        'q17_other_text'   => serialize(
                                  KiouChild::mkQ17text(getKiouVal('q17_other_text', NULL), 
                                            getKiouVal('q17_other_text_y', NULL), 
                                            getKiouVal('q17_other_text_m', NULL)
                                  )
                              ),
        'same_symptoms'    => join(',', getKiouVal('same_symptoms', array())), 
        'reg_datetime'     => $now_datetime, 
    );

} else {

    $step241_answers = Answer::get(241, 'answers', array());
    $step242_answers = Answer::get(242, 'answers', array());
    $step41_answers = array();
    foreach ($lmd->httpPost() as $k => $v) {
        if (preg_match('/^input_(\d+)$/', $k, $c)) {
            $step41_answers[$c[0]] = $v;
        }
    }

    $params['kiou'] = array(
        'answer_code'  => $answer_code, 
        'card_number'  => $card_number, 
        'serialized_data' => serialize(array_merge($step241_answers, $step242_answers, $step41_answers)), 
        'diseases' => KiouAdult::getStep242Diseases($step242_answers), 
        'reg_datetime' => $now_datetime, 
        'doctor_id' => NULL, 
    );
}


// 重症度判定結果の取得
{
    $zenshin_category_id = Answer::get(2, 'zenshin_category_id');
    $shojo_category_id   = Answer::get(3, 'shojo_category_id');

    $step2_answers   = Answer::get(2, 'answers', array());
    $step31_answers  = Answer::get(31, 'answers', array());
    $step212_answers = Answer::get(212, 'answers', array());
    $fever_answers   = Answer::get(31, 'fever_answers', array());

    $severity = Factory::load('App/Severity')->getInstance(_isChild() ? Severity::CHILD : Severity::ADULT);
    $severity->prepare($zenshin_category_id, $shojo_category_id);
    $severity->execute($step2_answers, $step31_answers, $step212_answers, $fever_answers);

    $sevs = $severity->getSeverities();
    $base_severity = $severity->getBase();
    $severities = array(
        'zenshin' => (isset($sevs['zenshin']) && $sevs['zenshin']) ? $sevs['zenshin'] : null,
        'shojo1'  => (isset($sevs['shojo1']) && $sevs['shojo1']) ? $sevs['shojo1'] : null,
        'shojo2'  => (isset($sevs['shojo2']) && $sevs['shojo2']) ? $sevs['shojo2'] : null,
        'shojo3'  => (isset($sevs['shojo3']) && $sevs['shojo3']) ? $sevs['shojo3'] : null,
        'fever'   => (isset($sevs['fever']) && $sevs['fever']) ? $sevs['fever'] : null,
        'gaisho1' => (isset($sevs['gaisho1']) && $sevs['gaisho1']) ? $sevs['gaisho1'] : null,
        'gaisho2' => (isset($sevs['gaisho2']) && $sevs['gaisho2']) ? $sevs['gaisho2'] : null,
        'gaisho3' => (isset($sevs['gaisho3']) && $sevs['gaisho3']) ? $sevs['gaisho3'] : null,
        'base_severity'  => $base_severity ? $base_severity : null,
    );
    //_Ve($severities);
}

// 救急外傷重症度の判定結果取得
//{
//    $life_days = Answer::get(2, 'life_days');
//    $qa = array();
//    // {{{ 緊急度レベルの取得
//    // 全身状態2...
//    foreach ((array)Answer::get(231, 'answers') as $key => $val) {
//        if (is_array($val)) {
//            foreach ($val as $k => $v) {
//                $item = array();
//                $item['target_kind'] = 2; // 2:全身状態...
//                $item['question_id'] = $key;
//                $item['answer_selection_id'] = $v;
//                $qa[] = $item;
//            }
//        } else {
//            $item = array();
//            $item['target_kind'] = 2; // 2:全身状態...
//            $item['question_id'] = $key;
//            $item['answer_selection_id'] = $val;
//            $qa[] = $item;
//        }
//    }
//    // 救急外傷...
//    $dao = Factory::load('DB/DAO_external_injury_common')->getInstance();
//    $injury_type = Answer::get(232, 'answers');
//    foreach ((array)Answer::get(235, 'answers') as $key => $val) {
//        // 共通項目の調整
//        if (! preg_match('/^\d+$/', $key)) { continue; } // 数値以外のキーは無視
//        if (is_array($val)) {
//            foreach ($injury_type as $type) {
//                foreach ($val as $k => $v) {
//                    $answer_data = $dao->fetchAnswerIdByTypeSeq($type, $v);
//                    if (! empty($answer_data)) {
//                        $item = array();
//                        $item['target_kind'] = 1; // 1:救急外傷...
//                        $item['question_id'] = $answer_data['external_injury_question_id'];
//                        $item['answer_selection_id'] = $answer_data['external_injury_answer_selection_id'];
//                        $item['answer_selection_name'] = $answer_data['answer_selection_name']; // 確認用...
//                        $qa[] = $item;
//                    }
//                }
//            }
//        } else {
//            foreach ((array)$injury_type as $type) {
//                $answer_data = $dao->fetchAnswerIdByTypeSeq($type, $val);
//                if (! empty($answer_data)) {
//                    $item = array();
//                    $item['target_kind'] = 1; // 1:救急外傷...
//                    $item['question_id'] = $answer_data['external_injury_question_id'];
//                    $item['answer_selection_id'] = $answer_data['external_injury_answer_selection_id'];
//                    $item['answer_selection_name'] = $answer_data['answer_selection_name']; // 確認用...
//                    $qa[] = $item;
//                }
//            }
//        }
//    }
//    foreach ((array)Answer::get(233, 'answers') as $key => $val) {
//        if (! preg_match('/^\d+$/', $key)) { continue; } // 数値以外のキーは無視
//        if (is_array($val)) {
//            foreach ($val as $k => $v) {
//                $item = array();
//                $item['target_kind'] = 1; // 1:救急外傷...
//                $item['question_id'] = $key;
//                $item['answer_selection_id'] = $v;
//                $qa[] = $item;
//            }
//        } else {
//            $item = array();
//            $item['target_kind'] = 1; // 1:救急外傷...
//            $item['question_id'] = $key;
//            $item['answer_selection_id'] = $val;
//            $qa[] = $item;
//        }
//    }
//    $dao = Factory::load('DB/DAO_external_injury_level')->getInstance();
//    $level = $dao->fetchExternalInjuryLevelMax($qa, $life_days);
//    // }}}
//
//    $severities['serious_level'] = $level ? (float)$level : null; // テーブル[severitys]へセット...
//    if ($severities['serious_level']) {
//        // 外傷ルートのため、上書き
//        $severities['base_severity']  = $severities['serious_level'];
//
//        // 重症化リスク算出で利用するため、値をセット。
//        //  serious_level は各値の最大値であるため、重症化リスク算出に利用できる。
//        //  詳細は、ドキュメントを参照。
//        //   ⇒ doc/いただいたドキュメント/重症度／緊急度(重症化リスク)/算出指標{1,2}.txt
//        $severities['gaisho1'] = $severities['serious_level'];
//        $severities['gaisho2'] = $severities['serious_level'];
//        $severities['gaisho3'] = $severities['serious_level'];
//    }
//   //_Ve($severities);
//}

$dao = array();
$dao['base']       = Factory::load('DB/DAO_Base')->getInstance();
$dao['answers']    = Factory::load('DB/DAO_answers')->getInstance();
$dao['kiou']       = Factory::load(_isChild() ? 'DB/DAO_kiou_child' : 'DB/DAO_kiou_adult')->getInstance();
$dao['severitys']  = Factory::load('DB/DAO_severitys')->getInstance();
$dao['vital_sign'] = Factory::load('DB/DAO_vital_sign')->getInstance();

/**
 * Transaction.
 */
try {
    // begin
    $dao['base']->begin();

    // insert: answers
    $dao['answers']->insert($params['answers']);

    $answer_id = $dao['answers']->lastInsertId();

    if ( ! _isDoctor()) {
        // これは成育用なので目黒用ポート確認取得情報は無効にします。
        //// insert: patient_code
        //$dao['patient_code']->insert($params['patient_code']);

        if (! $lmd->hasHttpPost('isKinkyu')) {
            // 緊急フロー以外のときに既往と家族歴を保存
            // insert: kiou
            $dao['kiou']->insert($params['kiou']);

            // save(update/insert/delete): family_history
            $fh = Factory::load('App/FamilyHistory')->getInstance($card_number);
            $fh->save($lmd->httpPost());
        }
    }

    // insert: severitys
    $dao['severitys']->insert($answer_id, $severities);

    // insert: vital_sign
    $dao['vital_sign']->insert(array('answer_code' => $answer_code));

    // commit
    $dao['base']->commit();
    $res = true;

} catch (Exception $e) {

    // rollback
    $dao['base']->rollback();
    $res = false;
}

if ($res) {
    // 登録成功
    if (_isAgent()) {
        // 代理入力
        //$lmd->redirect(APP_ROOT. '/doctor/top/');
        if (_isQQAgent()) {
            // 救急入力
            $lmd->redirect(APP_ROOT. '/agent/');
        } else {
            // ドクター、看護師、事務方
            $lmd->redirect(APP_ROOT. '/doctor_tab/exa?answer_code=' . $answer_code);
        }
    } else {
        $lmd->redirect(APP_ROOT. '/step5/complete?answer_id=' . $answer_id);
    }
} else {
    // 登録失敗
    Javascript::backReferer('登録に失敗しました', '#ffa07a');
}


