<?php
/**
 * ベンチマーク Class
 * 
 * @package Lambda/component
 * @author  rooth
 * @version 0.0.1
 *
 * PHP version 5
 *
 *<pre>
 *
 * usage:
 *  $benchmark = new Benchmark();
 *  $benchmark->start();
 *  $benchmark->stop();
 *
 *</pre>
 */
class Benchmark
{
    private $start_time;
    private $end_time;
    private $init_memory;
    private $fini_memory;
    private $peak_memory = 'unknown (PHP 5 >= 5.2.0)';
    private $format;

    public function __construct($format = '%.6f sec / init_mem: %s KB / fini_mem: %s KB / peak_mem: %s KB')
    {
        $this->start_time = 0;
        $this->end_time   = 0;
        $this->format     = $format;
    }

    public function start()
    {
        $this->start_time = $this->microtimeFloat();
        $this->init_memory = number_format(round(memory_get_usage() / 1024, 2));
    }

    public function stop()
    {
        $this->end_time = $this->microtimeFloat();
        $this->fini_memory = number_format(round(memory_get_usage() / 1024, 2));

        if (version_compare(PHP_VERSION, '5.2.0', '>=')) {
            $this->peak_memory = number_format(round(memory_get_peak_usage() / 1024, 2));
        }

        return sprintf(
            $this->format, 
            $this->end_time - $this->start_time, 
            $this->init_memory, 
            $this->fini_memory, 
            $this->peak_memory
        );
    }

    private function microtimeFloat()
    {
        list($usec, $sec) = explode(' ', microtime());
        return ((float)$usec + (float)$sec);
    }



} // -- End of class


