<?php
/**
 * デバイス class
 *
 * @package Lambda/component
 * @author  rooth
 * @version 0.0.1
 *
 * PHP version 5
 */
class Device
{
    public static function isMobile()
    {
        if (self::isDocomo())   return true;
        if (self::isAu())       return true;
        if (self::isSoftbank()) return true;

        return false;
    }

    public static function isSmartPhone()
    {
        if (self::isIphone())        return true;
        if (self::isAndroidMobile()) return true;

        return false;
    }

    public static function isIos()
    {
        if (self::isIphone()) return true;
        if (self::isIpad())   return true;
        if (self::isIpod())   return true;

        return false;
    }

    public static function isDocomo()
    {
        return preg_match('/DoCoMo|FOMA;/', self::getUserAgent());
    }
    public static function isAu()
    {
        return preg_match('/KDDI-/', self::getUserAgent());
    }
    public static function isSoftbank()
    {
        return preg_match('/SoftBank|Vodafone|J-PHONE/', self::getUserAgent());
    }
    public static function isIphone()
    {
        return preg_match('/iPhone/', self::getUserAgent());
    }
    public static function isIpad()
    {
        return preg_match('/iPad/', self::getUserAgent());
    }
    public static function isIpod()
    {
        return preg_match('/iPod/', self::getUserAgent());
    }
    public static function isAndroidMobile()
    {
        return preg_match('/Android.+Mobile/', self::getUserAgent());
    }

    public static function getDeviceId()
    {
        if (self::isDocomo() && isset($_SERVER['HTTP_X_DCMGUID'])) return $_SERVER['HTTP_X_DCMGUID'];
        if (self::isAu() && isset($_SERVER['HTTP_X_UP_SUBNO'])) return $_SERVER['HTTP_X_UP_SUBNO'];
        if (self::isSoftbank() && isset($_SERVER['HTTP_X_JPHONE_UID'])) return $_SERVER['HTTP_X_JPHONE_UID'];
        return '';
    }

    public static function getUserAgent()
    {
        return isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '';
    }

    public static function appendDocomoGuid()
    {
        if ( ! self::isDocomo()) return;

        if ( ! isset($_REQUEST['guid']) || $_REQUEST['guid'] !== 'ON') {
            $req_uri = preg_replace('|[?&]?guid=?[^&]*|', '', urldecode($_SERVER['REQUEST_URI']));
            $guid = (strpos($req_uri, '?') === false) ? '?guid=ON' :'&guid=ON';
            header('Location: http://'.$_SERVER['HTTP_HOST'].$req_uri.$guid);
            exit;
        }

        output_add_rewrite_var('guid', 'ON');
    }



} // -- End of class


