<?php

class AdmCookie
{
    const SESSION_USERNAME = 'admin_user_name';
    const SESSION_USER_ID  = 'admin_user_id';
    const SESSION_USER_DIV = 'admin_user_div';

    // 设置用户名称
    public static function setUserName($user_name)
    {
        $_SESSION[self::SESSION_USERNAME] = $user_name;
    }

    // 获取用户名称
    public static function getUserName()
    {
        return $_SESSION[self::SESSION_USERNAME] ?? '';
    }

    // 清除用户名称
    protected static function unsetUserName()
    {
        unset($_SESSION[self::SESSION_USERNAME]);
    }

    // 设置用户ID
    public static function setUserId($user_id)
    {
        $_SESSION[self::SESSION_USER_ID] = $user_id;
    }

    // 获取用户ID
    public static function getUserId()
    {
        return $_SESSION[self::SESSION_USER_ID] ?? '';
    }

    // 清除用户ID
    protected static function unsetUserId()
    {
        unset($_SESSION[self::SESSION_USER_ID]);
    }

    // 设置用户权限
    public static function setUserDiv($user_div)
    {
        $_SESSION[self::SESSION_USER_DIV] = $user_div;
    }

    // 获取用户权限
    public static function getUserDiv()
    {
        return $_SESSION[self::SESSION_USER_DIV] ?? '';
    }

    // 清除用户权限
    protected static function unsetUserDiv()
    {
        unset($_SESSION[self::SESSION_USER_DIV]);
    }

    // 清除所有 Session 数据
    public static function unsetAll()
    {
        self::unsetUserName();
        self::unsetUserId();
        self::unsetUserDiv();
        session_unset(); // 清空所有 Session 变量
    }
}

