<?php
/**
 * 回答 class
 */

isset($_SESSION[Answer::ANSWER]) || $_SESSION[Answer::ANSWER] = array();
isset($_SESSION[Answer::ANSWER_ORIGINAL]) || $_SESSION[Answer::ANSWER_ORIGINAL] = array();

class Answer
{
    const ANSWER = 'Answer';
    const ANSWER_ORIGINAL = 'AnswerOriginal';

    public static function set($key, Array $arr)
    {
        foreach ($arr as $k => $v) {
            $_SESSION[Answer::ANSWER][$key][$k] = $v;
        }
    }

    public static function get($key = null, $key2 = null, $fallback = '')
    {
        return self::_get(self::ANSWER, $key, $key2, $fallback);
    }

    public static function setOriginal(Array $arr)
    {
        $_SESSION[Answer::ANSWER_ORIGINAL] = $arr;
    }

    public static function getOriginal($key = null, $key2 = null, $fallback = '')
    {
        return self::_get(self::ANSWER_ORIGINAL, $key, $key2, $fallback);
    }

    /**
     * 現在のステップ以降のセッションを破棄する
     */
    public static function removeForwardAnswer($current_step)
    {
        foreach (array_keys($_SESSION['Answer']) as $step) {
            // 枝分かれするステップ「step211」のような２桁や３桁のステップがある。
            // そのため、単純にステップ数で比較すると、意図しないものまで削除されてしまうため、
            // ステップを 2.11 のような float に変換して比較する
            $current_step_f = self::stepNum2stepFloat($current_step);
            $step_f = self::stepNum2stepFloat($step);

            if ($current_step_f <= $step_f) {
                if (isset($_SESSION['Answer'][$step])) unset($_SESSION['Answer'][$step]);
            }
        }
    }



    /**
     * ステップ２の回答結果を Session に格納する
     */
    public static function step2_answer2session(Lambda $lmd)
    {
        $step = 2;

        $answers = array();
        foreach ($lmd->httpPost("step{$step}") as $v) {
            $answers[] = $v;
        }

        $p = array(
            'isGaisho' => $lmd->hasHttpPost('isGaisho') ? 1 : 0,
            'isGoin'   => $lmd->hasHttpPost('isGoin') ? 1 : 0,
        );

        self::set($step, array('answers' => $answers));
        self::set($step, $p);
    }

    /**
     * ステップ２１２の回答結果を Session に格納する
     */
    public static function step212_answer2session(Lambda $lmd)
    {
        $step = 212;

        $answers = array();
        foreach ($lmd->httpPost("step{$step}", array()) as $val) foreach ($val as $v) {
            $answers[] = $v;
        }
        self::set($step, array('answers' => $answers));
    }

    /**
     * ステップ３の回答結果を Session に格納する
     */
    public static function step3_answer2session(Lambda $lmd)
    {
        $step = 3;

        $answers = array();
        foreach ($lmd->httpPost("step{$step}", array()) as $v) {
            $answers[] = $v;
        }

        $p = array(
            's3_other_disease' => $lmd->httpPost('s3_other_disease'), // その他：テキストフィールド
            's3_other_disease_flg' => $lmd->hasHttpPost('s3_other_disease_flg') ? 1 : 0, // その他フラグ
            's3_no_disease_flg' => $lmd->hasHttpPost('s3_no_disease_flg') ? 1 : 0, // 特に気になる症状はないフラグ

            'isNotShojo' => $lmd->hasHttpPost('isNotShojo') ? 1 : 0,
            'primaryShojo' => $lmd->httpPost('primaryShojo'),
        );

        self::set($step, array('answers' => $answers));
        self::set($step, $p);
    }

    /**
     * ステップ31の回答結果を Session に格納する
     */
    public static function step31_answer2session(Lambda $lmd)
    {
        $step = 31;

        $answers = $when = array();
        foreach ($lmd->httpPost("step{$step}", array()) as $val) foreach ($val as $v) {
            $answers[] = $v;
        }
        foreach ($lmd->httpPost('when', array()) as $k => $v) {
            $when[] = "{$k}:{$v}";
        }
        Answer::set($step, array('answers' => $answers));
        Answer::set($step, array('when' => $when));

        if ($lmd->hasHttpPost('fever')) {
            foreach ($lmd->httpPost('fever') as $v) {
                $fever_answers[] = $v;
            }
            Answer::set($step, array('fever_answers' => $fever_answers));
        }
    }

    /**
     * ステップ231の回答結果を Session に格納する
     */
    public static function step231_answer2session(Lambda $lmd)
    {
        $step = 231;

        $answers = array();
        foreach ($lmd->httpPost("step{$step}", array()) as $q => $v) {
            $answers[$q] = $v;
        }
        Answer::set($step, array('answers' => $answers));
    }

    private static function _get($key1, $key2 = null, $key3 = null, $fallback = '')
    {
        $fallback = ($fallback === '') ? '' : $fallback;

        if ($key2 === null && $key3 === null) {
            return isset($_SESSION[$key1]) ? $_SESSION[$key1] : $fallback;
        }
        if ($key3 === null) {
            return isset($_SESSION[$key1][$key2]) ? $_SESSION[$key1][$key2] : $fallback;
        }
        return isset($_SESSION[$key1][$key2][$key3]) ? $_SESSION[$key1][$key2][$key3] : $fallback;
    }

    /**
     * stepNum2stepFloat
     */
    private static function stepNum2stepFloat($num)
    {
        $arr = str_split($num);
        if (count($arr) === 1) {
            $ret = "{$num}.0";
        } else {
            $first = array_shift($arr);
            $ret = "{$first}." . implode('', $arr);
        }

        return (float)$ret;
    }



}


