<?php

class ExternalInjuryDiagnosisRank
{
    const COMMON_MAX = 5;
    const LIFE_THREATENING_MAX = 10;

    private $common = array();
    private $life_threatening = array();

    public function __construct(Array $common = array(), Array $life_threatening = array())
    {
        $this->common = $common;
        $this->life_threatening = $life_threatening;
        $this->prepare();
    }

    public function getSortedCommon()
    {
        return $this->mkRank($this->common);
    }

    public function getSortedLifeThreatening()
    {
        return $this->mkRank($this->life_threatening);
    }

    private function prepare()
    {
        for ($i = 1; $i <= self::COMMON_MAX; $i++) {
            if (isset($this->common[$i])) {
                sort($this->common[$i]);
            }
        }
        for ($i = 1; $i <= self::LIFE_THREATENING_MAX; $i++) {
            if (isset($this->life_threatening[$i])) {
                sort($this->life_threatening[$i]);
            }
        }
        if (is_array($this->common)) {
            krsort($this->common, SORT_NUMERIC);
        }
        if (is_array($this->life_threatening)) {
            krsort($this->life_threatening, SORT_NUMERIC);
        }
    }

    private function mkRank(Array $arr)
    {
        foreach (array_keys($arr) as $rank) {
            sort($arr[$rank]);
            foreach ($arr[$rank] as $idx => $diag_name) {
                if ($diag_name === '') continue;
                if (isset($arr[$rank][$idx - 1])) {
                    if ($arr[$rank][$idx - 1] === $diag_name) {
                        // 前要素と同一診断名の場合、ワンランク上のランクに昇格させる。
                        $arr[$rank - 1][] = $diag_name;

                        // 対象の診断名(２つとも)を除去する
                        unset($arr[$rank][$idx - 1]);
                        unset($arr[$rank][$idx]);
                    }
                }
            }
            if ( ! $arr[$rank]) $arr[$rank] = array();
            sort($arr[$rank]);
        }
        ksort($arr);

        $ret = array();
        foreach ($arr as $val) foreach ($val as $v) {
            if ($v === '') continue;
            // 重複した診断名の削除 ※ランクの高い方を残す
            if ( ! in_array($v, $ret)) $ret[] = $v;
        }

        return $ret;
    }



} // -- End of class


