<?php

class KiouChild
{
    /**
     * 「Q17. 入院するような大きな病気...」の値を生成
     *
     *  生成される値： array('value' => [チェックされた値], 'y' => [対応する年], 'm' => [対応する月])
     */
    public static function mkQ17(Array $disease, Array $y, Array $m)
    {
        $buf = array();
        foreach ($disease as $k => $v) {
            $buf[$k] = array(
                'value' => $v, 
                'y' => isset($y[$k]) ? $y[$k] : '', 
                'm' => isset($m[$k]) ? $m[$k] : '', 
            );
        }
        return $buf;
    }

    /**
     * 「Q17. 「その他」の場合、ご入力ください」の値を生成
     *
     *  生成される値： array('text' => [入力値], 'y' => [対応する年], 'm' => [対応する月])
     */
    public static function mkQ17text($text, $y, $m)
    {
        if ($text === null || $text === '') return '';

        return array(
            'text' => $text,
            'y' => $y,
            'm' => $m,
        );
    }



}


