<?php
/**
 * 質問/回答 class
 * 
 * @dependence lib/Factory.php
 * @dependence lib/DB//DAO_monshin_child.php
 * @dependence lib/DB//DAO_monshin_adult.php
 * @dependence lib/App//Answer.php
 */
class QA
{
    protected $dao;

    public function __construct()
    {
        $this->dao = Factory::load(_isChild() ? 'DB/DAO_monshin_child' : 'DB/DAO_monshin_adult')->getInstance();
    }



    public function step2_getQuestions($life_days, &$category_id)
    {
        $arr = $this->dao->step2_getAgeDiv($life_days);
        $category_id = isset($arr['CategoryID']) ? $arr['CategoryID'] : '';

        return  $this->dao->step2_getQuestions($category_id);
    }

    public function step2_getAnswers(Array $questions, $category_id)
    {
        $ret = array();
        foreach ($questions as $v) {
            $class_id  = $v['ClassID'];
            $ret[$class_id] = $this->dao->step2_getAnswers($category_id, $class_id);
        }

        return $ret;
    }



    public function step212_getQuestions(Array $step211_answers, &$injurys)
    {
        $injurys = array();
        $questions = array();
        foreach ($step211_answers as $v) {
            $injury_id = $v;
            $injurys[$injury_id]   = $this->dao->step212_getInjury($injury_id);
            $questions[$injury_id] = $this->dao->step212_getQuestions($injury_id);
        }

        return $questions;
    }

    public function step212_getAnswers(Array $questions)
    {
        $ret = array();
        foreach ($questions as $val) foreach ($val as $v) {
            $question_id = $v['IQuestionID'];
            $ret[$question_id] = $this->dao->step212_getAnswers($question_id);
        }

        return $ret;
    }



    public function step31_getDiseaseArr(Array $step3_answers)
    {
        $disease_arr = array();
        foreach ($step3_answers as $v) {
            $disease_arr[] = $v;
        }

        return $disease_arr;
    }

    public function step31_getDisease(Array $disease_arr, $category_id)
    {
        $diseases = array();
        foreach ($disease_arr as $disease_id)
        {
            $diseases[$disease_id] = $this->dao->step31_getDiseaseItem($category_id, $disease_id);
        }

        return $diseases;
    }

    public function step31_checkDiseaseIdWithWhenFlag(Array $disease_arr, $category_id)
    {
        $diseases = array();
        foreach ($disease_arr as $disease_id) {
            $arr = $this->dao->step31_getQestions($category_id, $disease_id);
            foreach ($arr as $v2) {
                if ($v2['when_flag'] == 1) {
                    $diseases[] = $disease_id;
                }
            }
        }

        return $diseases;
    }

    public function step31_getQestions(Array $disease_arr, $category_id)
    {
        $questions = array();
        foreach ($disease_arr as $disease_id) {
            $arr = $this->dao->step31_getQestions($category_id, $disease_id);
            foreach ($arr as $v2) {
                $question_id = $v2['DQuestionID'];
                $text = $v2['DQContents'];
                $questions[$disease_id][$question_id] = $text;
            }
        }

        return $questions;
    }

    public function step31_getRawQuestions(Array $disease_arr, $category_id)
    {
        $questions = array();
        foreach ($disease_arr as $disease_id) {
            $arr = $this->dao->step31_getQestions($category_id, $disease_id);
            foreach ($arr as $v2) {
                $question_id = $v2['DQuestionID'];
                $questions[$disease_id][$question_id] = $v2;
            }
        }

        return $questions;
    }

    public function step31_getAnswers(Array $questions, $category_id)
    {
        $answers = array();
        foreach ($questions as $v) foreach (array_keys($v) as $question_id) {
            $arr = $this->dao->step31_getAnswers($category_id, $question_id);
            foreach ($arr as $v2) {
                $answer_id = $v2['DAnswerID'];
                $text = $v2['DAContents'];
                $answers[$question_id][$answer_id] = $text;
            }
        }

        return $answers;
    }

    public function step31_getRawAnswers(Array $questions, $category_id)
    {
        $answers = array();
        foreach ($questions as $v) foreach (array_keys($v) as $question_id) {
            $arr = $this->dao->step31_getAnswers($category_id, $question_id);
            foreach ($arr as $v2) {
                $answer_id = $v2['DAnswerID'];
                $answers[$question_id][$answer_id] = $v2;
            }
        }

        return $answers;
    }



    public function step31_getFiverDisease($category_id, $fever_id)
    {
        return $this->dao->step31_getDiseaseItem($category_id, $fever_id);
    }

    public function step31_getFiverQestions($category_id, $fever_id)
    {
        $arr = $this->dao->step31_getQestions($category_id, $fever_id);
        $questions = array();
        foreach ($arr as $v) {
            $question_id = $v['DQuestionID'];
            $text = $v['DQContents'];
            $questions[$fever_id][$question_id] = $text;
        }

        return $questions;
    }





}
