<?php
/* vim:se et ts=4 sw=4 sts=4: */
/**
 * Xml Api for Recipe / Proccess
 * 
 * LICENSE: 
 * 
 * @copyright 2011 Topazos, Inc.
 * @license http://www.topazos.co.jp/license/3_0.txt PHP License 3.0
 * @version CVS: $Id: $
 * @link http://www.topazos.co.jp/package/PackageName
 * @since File available since Release 1.0.0
 */

/**
 * Xml Api
 */
class XmlApi
{

    private $_err = array();
    private $_name = ''; // need string 'xml_recipe' or 'xml_process'

    public function __construct($name = 'xml_recipe')
    {
        $this->_name = $name;
        try {
            $this->_db = Factory::load('DB/DAO_' . $this->_name)->getInstance();
        } catch (PDOException $e) {
            $this->_err[] = $e->getMessage();
        }
    }

    public function prepare()
    {
        list($xml, $kind) = explode('_', $this->_name);
        $name = ucwords($xml) . ucwords($kind);
        $method = 'fetchAll'. $name . 'ByExportFlag';
        try {
            $this->_list = $this->_db->$method();
        } catch (PDOException $e) {
            $this->_err[] = $e->getMessage();
        }
    }

    public function validate()
    {
        $result = FALSE;
        if (empty($this->_err)) {
            $result = (count($this->_list) > 0);
        }
        return $result;
    }

    public function execute()
    {
        $out = array();
        foreach ($this->_list as $val) {
            $out[] = sprintf("Filename:%s\n%s", $val['file_name'], $val['xml_contents']);
        }
        $result = implode("\n--" . $this->_name . "--\n", $out);
        $result = str_replace('UTF-8', 'Shift_JIS', $result);
        $result = mb_convert_encoding($result, 'Shift_JIS', 'UTF-8');
        echo($result);
    }

    public function complete()
    {
        try {
            $this->_db->begin();
            foreach ($this->_list as $val) {
                $this->_db->update_flag($val[$this->_name . '_id']);
            }
            $this->_db->commit();
        } catch (PDOException $e) {
            $this->_err[] = $e->getMessage();
        }
    }

    public function error()
    {
        if (! empty($this->_err)) {
            $result = "--get_error--\n";
            $result .= implode("\n", $this->_err);
            return $result;
        }
    }

    public function __destruct()
    {
        exit;
    }

}

?>
