<?php
/* vim:se et ts=4 sw=4 sts=4 fdm=marker: */
/**
 * Create Xml for Common
 * 
 * LICENSE: 
 * 
 * @copyright 2011 Topazos, Inc.
 * @license http://www.topazos.co.jp/license/3_0.txt PHP License 3.0
 * @version CVS: $Id: $
 * @link http://www.topazos.co.jp/package/PackageName
 * @since File available since Release 1.0.0
 */

// タイムゾーンの設定
// 注意: PHP 5.1.0 以降（日付/時刻 関数が書き直されてから）、タイムゾーンを 正しく設定せずに日付/時刻関数をコールすると
// E_NOTICE が発生し、またシステムの設定や TZ 環境変数を 使用すると E_STRICT が発生するようになりました。
date_default_timezone_set('Asia/Tokyo');


/**
 * Xml Common Class
 */
class XmlCommon
{

    /**
     * Variables
     */
    protected $_enc = 'UTF-8';

    /**
     * Constructor
     */
    public function __construct($enc = 'UTF-8')
    {
        $this->_enc = $enc;
        $this->x = new DOMDocument('1.0', 'UTF-8'); // DOMはUTF-8でないと正常動作しない(最後に一括変換する)
        $this->x->formatOutput = TRUE;
        $this->x->preserveWhiteSpace = FALSE;
    }

    // {{{ Xml Tools...
    /**
     * Create Xml Element
     */
    protected function _xmlElement($name, $text = '', $attr = array())
    {
        if (is_object($text)) {
            $el = $this->x->createElement($name);
            $el->appendChild($text);
        } elseif (is_array($text)) {
            $el = $this->x->createElement($name);
            foreach ($text as $key => $val) {
                if (! is_object($val)) {
                    if (preg_match('/^\d+$/', $key)) {
                        foreach ($val as $k => $v) {
                            if (isset($v[1])) {
                                $val = $this->_xmlElement($k, $v[0], $v[1]);
                            } else {
                                $val = $this->_xmlElement($k, $v[0]);
                            }
                        }
                    } elseif (isset($val[1])) {
                        $val = $this->_xmlElement($key, $val[0], $val[1]);
                    } else {
                        $val = $this->_xmlElement($key, $val[0]);
                    }
                }
                $el->appendChild($val);
            }
        } else {
            $text = $this->_xmlConvertor($text);
            $el = $this->x->createElement($name, $text);
        }
        if (! empty($attr)) {
            $el = $this->_xmlAttribute($el, $attr);
        }
        return $el;
    }

    /**
     * Create Xml Attribute on Element
     */
    protected function _xmlAttribute($el, $attr)
    {
        foreach ((array)$attr as $key => $val) {
            $val = $this->_xmlConvertor($val);
            $el->setAttribute($key, $val);
        }
        return $el;
    }

    /**
     * Convert String for Xml
     */
    protected function _xmlConvertor($str)
    {
        $str = str_replace('&', '＆', $str);
        return $str;
    }
    // }}}

    // {{{ Encode Tools...
    protected function _outEncode($data, $enc)
    {
        $data = str_replace('UTF-8', $enc, $data);
        $data = mb_convert_encoding($data, $enc, 'UTF-8');
        return $data;
    }

    protected function _removeSjisGaiji($data)
    {
        if (is_array($data)) {
            foreach ($data as $key => $val) {
                $data[$key] = $this->_removeSjisGaiji($val);
            }
        } else {
            $tmp = '';
            mb_language('ja');
            mb_internal_encoding('UTF-8');
            $len = mb_strlen($data);
            for ($i = 0; $i < $len; $i++) {
                $char = mb_substr($data, $i, 1);
                $char = mb_convert_encoding($char, 'SJIS', 'UTF-8');
                $char = bin2hex($char);
                $tmp .= preg_replace('/f[0-9][4-9a-f][0-9a-c]/', '81a1', $char);
            }
            $data = pack('H*', $tmp);
            $data = mb_convert_encoding($data, 'UTF-8', 'SJIS');
        }
        return $data;
    }
    // }}}

}

?>
