<?php
/**
 * データアクセスオブジェクト
 * 
 * 内科の医師・小児科医の場合のテーブル     INT_CarteDisRelationTable01
 */

require_once dirname(__FILE__).'/DAO_Base.php';

class DAO_INT_CarteDisRelationTable01 extends DAO_Base
{
    protected $table = 'INT_CarteDisRelationTable01';
    //protected $pkey  = '';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
    }

    public function fetch_BY_CategoryID_AND_DiseaseID($CategoryID, $DiseaseID)
    {
        $this->manipulator->select(' * ');
        $this->manipulator->where(array(
            'CategoryID' => $CategoryID, 
            'and',
            'DiseaseID' => $DiseaseID, 
            'and',
            'ValidFlag' => 1, 
        ));
        $this->manipulator->orderBy(array(
            'DiseaseID' => 'ASC',
        ));

        return $this->manipulator->fetch();
    }



} //-- End of class


