<?php
/**
 * データアクセスオブジェクト
 */

require_once dirname(__FILE__).'/PDO_MySQL.php';

class DAO_RecipeDiagRelationTable extends PDO_MySQL
{
    public function __construct()
    {
        parent::__construct(DB_HOST, DB_NAME, DB_USER, DB_PASS, DB_ENCODING);
    }

    /**
     * レシピ一覧を返却する
     *
     * @param int $diagnosis_id
     * @param int $weight 体重(単位：kg)
     */
    public function fetchAll_UNION_ALL_BY_DiagnosisID_AND_weight($diagnosis_id, $weight)
    {
        /*
        WeightZone01	0	4000
        WeightZone02	4001	8000
        WeightZone03	8001	12000
        WeightZone04	12001	16000
        WeightZone05	16001	20000
        WeightZone06	20001	24000
        WeightZone07	24001	28000
        WeightZone08	28001	32000
        WeightZone09	32001	36000
        WeightZone10	36001	40000
        WeightZone11	40001	∞
        */
        $map = array(
            'WeightZone01' => array(0, 4000),
            'WeightZone02' => array(4001, 8000),
            'WeightZone03' => array(8001, 12000),
            'WeightZone04' => array(12001, 16000),
            'WeightZone05' => array(16001, 20000),
            'WeightZone06' => array(20001, 24000),
            'WeightZone07' => array(24001, 28000),
            'WeightZone08' => array(28001, 32000),
            'WeightZone09' => array(32001, 36000),
            'WeightZone10' => array(36001, 40000),
            'WeightZone11' => array(40001, 44000),
            'WeightZone12' => array(44001, 48000),
            'WeightZone13' => array(48001, 52000),
            'WeightZone14' => array(52001, 999999999),
        );

        // kg -> g 変換
        $weight = (int)($weight * 1000);

        // WeightZone
        $weight_zone = "'' as WeightZone";
        foreach ($map as $k => $v) {
            if ($v[0] <= $weight && $weight <= $v[1]) {
                $weight_zone = "{$k} as WeightZone";
                break;
            }
        }

        /**
         * table1: 粉剤
         * table2: 錠剤
         * table3: シロップ
         */
        $sql = "
            (select *, $weight_zone, 1 as partition_id, 'powder' as medicine_type from RecipeDiagRelationTable1 
                where DiagnosisID = :diagnosis_id order by DiagnosisID, RecipeDispGroup, RecipeDispNum)

            union all

            (select *, $weight_zone, 2 as partition_id, 'tablet' as medicine_type from RecipeDiagRelationTable2 
                where DiagnosisID = :diagnosis_id order by DiagnosisID, RecipeDispGroup, RecipeDispNum)

            union all

            (select *, $weight_zone, 3 as partition_id, 'syrup' as medicine_type from RecipeDiagRelationTable3 
                where DiagnosisID = :diagnosis_id order by DiagnosisID, RecipeDispGroup, RecipeDispNum)
        ";

        $params = array(
            ':diagnosis_id' => $diagnosis_id,
        );

        return $this->fetchAll($sql, $params);
    }



} //-- End of class


