<?php
/**
 * Body Condition2 Question
 * 
 * LICENSE: 
 * 
 * @copyright 2011 Topazos, Inc.
 * @license http://www.topazos.co.jp/license/3_0.txt PHP License 3.0
 * @version CVS: $Id: $
 * @link http://www.topazos.co.jp/package/PackageName
 * @since File available since Release 1.0.0
 */

require_once dirname(__FILE__) . '/DAO_Base.php';

/**
 * Body Condition2 Question Class.
 */
class DAO_body_condition2_question extends DAO_Base
{

    protected $table = 'body_condition2_question';
    protected $pkey  = 'body_condition2_question_id';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
    }

    public function fetchBodyCondition2QuestionById($id)
    {
        $this->manipulator->setAlias('q');
        $this->manipulator->select('q.*');
        $this->manipulator->where(array(
            'q.delete_flag' => '0',
            'and',
            $this->pkey => $id,
        ));
        return $this->manipulator->fetch();
    }

    public function fetchAllBodyCondition2Question()
    {
        $this->manipulator->setAlias('q');
        $this->manipulator->select('q.*');
        $this->manipulator->where(array(
            'q.delete_flag' => '0',
        ));
        $this->manipulator->orderBy(array(
            'q.order_num' => 'asc',
        ));
        return $this->manipulator->fetchAll();
    }

    public function fetchAllBodyCondition2QuestionWithAnswerSelection()
    {
        $this->manipulator->setAlias('q');
        $this->manipulator->select('q.*, a.body_condition2_answer_selection_id, a.answer_selection_name');
        $this->manipulator->join('left', 'body_condition2_answer_selection a');
        $this->manipulator->using($this->pkey);
        $this->manipulator->where(array(
            'q.delete_flag' => '0',
            'and',
            'a.delete_flag' => '0',
        ));
        $this->manipulator->orderBy(array(
            'q.order_num' => 'asc',
            'a.order_num' => 'asc',
        ));
        return $this->manipulator->fetchAll();
    }

}

?>
