<?php
/**
 * Default Diagnosis Therapeutic Plan (救急外傷系DXTXデフォルト)
 * 
 * LICENSE: 
 * 
 * @copyright 2011 Topazos, Inc.
 * @license http://www.topazos.co.jp/license/3_0.txt PHP License 3.0
 * @version CVS: $Id: $
 * @link http://www.topazos.co.jp/package/PackageName
 * @since File available since Release 1.0.0
 */

require_once dirname(__FILE__) . '/DAO_Base.php';

/**
 * Default Diagnosis Therapeutic Plan Class.
 */
class DAO_default_diagnosis_therapeutic_plan extends DAO_Base
{

    protected $table = 'default_diagnosis_therapeutic_plan';
    protected $pkey  = 'default_diagnosis_therapeutic_plan_id';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
    }

    public function fetchAllDefaultDxTxPlan($emergency_injury_diagnosis_id, $serious_level)
    {
        $this->manipulator->setAlias('d');
        $this->manipulator->select('d.*, i.*');
        $this->manipulator->join('left', 'input_diagnosis_therapeutic_plan i');
        $this->manipulator->using('input_diagnosis_therapeutic_plan_id');
        $this->manipulator->where(array(
            'emergency_injury_diagnosis_id' => $emergency_injury_diagnosis_id,
            'and',
            'serious_level' => $serious_level,
        ));
        //$this->manipulator->orderBy(array(
        //    'order_num' => 'asc',
        //));
        return $this->manipulator->fetchAll();
    }

    public function fetchAllDefaultDxTxPlanByDiagName(Array $diagnosis_name_arr, $serious_level)
    {
        $this->manipulator->setAlias('d');
        $this->manipulator->select('e.*, d.*, i.*');
        $this->manipulator->join('left', 'emergency_injury_diagnosis e');
        $this->manipulator->using('emergency_injury_diagnosis_id');
        $this->manipulator->join('left', 'input_diagnosis_therapeutic_plan i');
        $this->manipulator->using('input_diagnosis_therapeutic_plan_id');
        $this->manipulator->where(array(
            'e.diagnosis_name' => array('IN', $diagnosis_name_arr),
            'and',
            'serious_level' => $serious_level,
        ));
        //$this->manipulator->orderBy(array(
        //    'order_num' => 'asc',
        //));
        return $this->manipulator->fetchAll();
    }

}

?>
