<?php
/**
 * Emergency Injury Diagnosis Category (救急外傷系診断名カテゴリ)
 * 
 * LICENSE: 
 * 
 * @copyright 2011 Topazos, Inc.
 * @license http://www.topazos.co.jp/license/3_0.txt PHP License 3.0
 * @version CVS: $Id: $
 * @link http://www.topazos.co.jp/package/PackageName
 * @since File available since Release 1.0.0
 */

require_once dirname(__FILE__) . '/DAO_Base.php';

/**
 * Emergency Injury Diagnosis Category Class.
 */
class DAO_emergency_injury_diagnosis_category extends DAO_Base
{

    protected $table = 'emergency_injury_diagnosis_category';
    protected $pkey  = 'emergency_injury_diagnosis_category_id';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
    }

    public function fetchAllEmergencyInjuryDiagnosisCategory()
    {
        $this->manipulator->select('*');
        $this->manipulator->where(array(
            'delete_flag' => '0',
        ));
        $this->manipulator->orderBy(array(
            'order_num' => 'asc',
        ));
        return $this->manipulator->fetchAll();
    }

}

?>
