<?php
/**
 * External Injury Diagnosis
 * 
 * LICENSE: 
 * 
 * @copyright 2011 Topazos, Inc.
 * @license http://www.topazos.co.jp/license/3_0.txt PHP License 3.0
 * @version CVS: $Id: $
 * @link http://www.topazos.co.jp/package/PackageName
 * @since File available since Release 1.0.0
 */

require_once dirname(__FILE__) . '/DAO_Base.php';

/**
 * External Injury Diagnosis Class.
 */
class DAO_external_injury_diagnosis extends DAO_Base
{

    protected $table = 'external_injury_diagnosis';
    protected $pkey  = 'external_injury_diagnosis_id';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
    }

    public function fetchAllExternalInjuryDiagnosis($category_id = FALSE)
    {
        $this->manipulator->setAlias('d');
        $this->manipulator->select('d.*, c.category_name');
        $this->manipulator->join('left', 'external_injury_diagnosis_category c');
        $this->manipulator->using('external_injury_diagnosis_category_id');
        $this->manipulator->where(array(
            'd.delete_flag' => '0',
            'and',
            'c.delete_flag' => '0',
        ));
        if ($category_id !== FALSE) {
            $this->manipulator->ifDefineWhere('and');
            if (is_array($category_id)) {
                $this->manipulator->where(array(
                    'external_injury_diagnosis_category_id' => array('in', $category_id),
                ));
            } else {
                $this->manipulator->where(array(
                    'external_injury_diagnosis_category_id' => $category_id,
                ));
            }
        }
        $this->manipulator->orderBy(array(
            'c.order_num' => 'asc',
            'd.order_num' => 'asc',
        ));
        return $this->manipulator->fetchAll();
    }

}

?>
