<?php
/**
 * External Injury Medicine
 * 
 * LICENSE: 
 * 
 * @copyright 2011 Topazos, Inc.
 * @license http://www.topazos.co.jp/license/3_0.txt PHP License 3.0
 * @version CVS: $Id: $
 * @link http://www.topazos.co.jp/package/PackageName
 * @since File available since Release 1.0.0
 */

require_once dirname(__FILE__) . '/DAO_Base.php';

/**
 * External Injury Medicine Class.
 */
class DAO_external_injury_medicine extends DAO_Base
{

    protected $table = 'external_injury_medicine';
    protected $pkey  = 'external_injury_medicine_id';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
    }

    private function getSeriousColumnName($level)
    {
        switch ($level) {
            case 0 :
            case 1 :
            case 2 :
            case 3 :
            case 4 :
                $num = (int)$level;
                break;
            default :
                $num = 0;
        }
        $result = 'serious_level_' . $num;
        return $result;
    }

    public function fetchAllExternalInjuryMedicine($serious_level, $ex_diagnosis_id)
    {
        $level_column = $this->getSeriousColumnName($serious_level);
        $this->manipulator->setAlias('m');
        $this->manipulator->select('m.*, d.diagnosis_name');
        $this->manipulator->join('left', 'external_injury_diagnosis d');
        $this->manipulator->using('external_injury_diagnosis_id');
        $this->manipulator->where(array(
            'external_injury_diagnosis_id' => $ex_diagnosis_id,
            'and',
            $level_column => '1', // 対象の重症度レベルのフラグがONであるレコード抽出...
            'and',
            'm.delete_flag' => '0',
            'and',
            'd.delete_flag' => '0',
        ));
        $this->manipulator->orderBy(array(
            'd.order_num' => 'asc',
            'm.order_num' => 'asc',
        ));
        return $this->manipulator->fetchAll();
    }

}

?>
