<?php
/**
 * External Injury Question
 * 
 * LICENSE: 
 * 
 * @copyright 2011 Topazos, Inc.
 * @license http://www.topazos.co.jp/license/3_0.txt PHP License 3.0
 * @version CVS: $Id: $
 * @link http://www.topazos.co.jp/package/PackageName
 * @since File available since Release 1.0.0
 */

require_once dirname(__FILE__) . '/DAO_Base.php';

/**
 * External Injury Question Class.
 */
class DAO_external_injury_question extends DAO_Base
{

    protected $table = 'external_injury_question';
    protected $pkey  = 'external_injury_question_id';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
    }

    public function fetchExternalInjuryQuestionById($id)
    {
        $this->manipulator->setAlias('q');
        $this->manipulator->select('q.*, t.type_name');
        $this->manipulator->join('left', 'external_injury_type t');
        $this->manipulator->using('external_injury_type_id');
        $this->manipulator->where(array(
            'q.delete_flag' => '0',
            'and',
            't.delete_flag' => '0',
            'and',
            $this->pkey => $id,
        ));
        return $this->manipulator->fetch();
    }

    public function fetchExternalInjuryQuestionByAnswerId($id)
    {
        $this->manipulator->setAlias('q');
        $this->manipulator->select('a.*, q.question_name, q.select_type, t.type_name, t.external_injury_type_id');
        $this->manipulator->join('left', 'external_injury_type t');
        $this->manipulator->using('external_injury_type_id');
        $this->manipulator->join('left', 'external_injury_answer_selection a');
        $this->manipulator->using($this->pkey);
        $this->manipulator->where(array(
            'a.external_injury_answer_selection_id' => $id,
            //'and',
            //'a.delete_flag' => '0', // 回答データの削除フラグはOFFとなっているのでチェックしない。
            'and',
            'q.delete_flag' => '0',
            'and',
            't.delete_flag' => '0',
        ));
        return $this->manipulator->fetch();
    }

    public function fetchAllExternalInjuryQuestionByTypeId($type_id = FALSE)
    {
        $this->manipulator->setAlias('q');
        $this->manipulator->select('q.*, t.type_name');
        $this->manipulator->join('left', 'external_injury_type t');
        $this->manipulator->using('external_injury_type_id');
        $this->manipulator->where(array(
            'q.delete_flag' => '0',
            'and',
            't.delete_flag' => '0',
        ));
        if ($type_id !== FALSE) {
            $this->manipulator->ifDefineWhere('and');
            if (is_array($type_id)) {
                $this->manipulator->where(array(
                    'external_injury_type_id' => array('in', $type_id),
                ));
            } else {
                $this->manipulator->where(array(
                    'external_injury_type_id' => $type_id,
                ));
            }
        }
        $this->manipulator->orderBy(array(
            'q.order_num' => 'asc',
        ));
        return $this->manipulator->fetchAll();
    }

    public function fetchAllExternalInjuryQuestionWithAnswerSelection($type_id = FALSE)
    {
        $this->manipulator->setAlias('q');
        $this->manipulator->select('q.*, t.type_name, a.external_injury_answer_selection_id, a.answer_selection_name');
        $this->manipulator->join('left', 'external_injury_type t');
        $this->manipulator->using('external_injury_type_id');
        $this->manipulator->join('left', 'external_injury_answer_selection a');
        $this->manipulator->using($this->pkey);
        $this->manipulator->where(array(
            'q.delete_flag' => '0',
            'and',
            't.delete_flag' => '0',
            'and',
            'a.delete_flag' => '0',
        ));
        if ($type_id !== FALSE) {
            $this->manipulator->ifDefineWhere('and');
            if (is_array($type_id)) {
                $this->manipulator->where(array(
                    'external_injury_type_id' => array('in', $type_id),
                ));
            } else {
                $this->manipulator->where(array(
                    'external_injury_type_id' => $type_id,
                ));
            }
        }
        $this->manipulator->orderBy(array(
            'q.order_num' => 'asc',
            'a.order_num' => 'asc',
        ));
        return $this->manipulator->fetchAll();
    }

}

?>
