<?php

/* vim:se et ts=4 sw=4 sts=4: */

/**
 * データアクセスオブジェクト
 */

require_once dirname(__FILE__).'/DAO_Base.php';

class DAO_internal_tx_items extends DAO_Base
{
    protected $table = 'internal_tx_items';
    protected $pkey  = 'internal_tx_item_id';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
    }

    public function getItems(Array $name_ids = array())
    {
        $this->manipulator->setAlias('items');
        $this->manipulator->select(' * ');
        $this->manipulator->join('left', 'internal_tx_diagnosis_names names');
        $this->manipulator->using('internal_tx_diagnosis_name_id');
        $this->manipulator->join('left', 'internal_tx_diagnosis_groups groups');
        $this->manipulator->using('internal_tx_diagnosis_group_id');

        if ($name_ids && is_array($name_ids)) {
            $this->manipulator->where(array(
                'items.internal_tx_diagnosis_name_id' => array('in', $name_ids), 
            ));
        }

        $this->manipulator->orderBy(array(
            'internal_tx_diagnosis_name_id' => 'ASC',
            'orderby' => 'ASC',
        ));

        return $this->manipulator->fetchAll();
    }

    public function getItemsByName($name)
    {
        $this->manipulator->setAlias('items');
        $this->manipulator->select(' * ');
        $this->manipulator->join('left', 'internal_tx_diagnosis_names names');
        $this->manipulator->using('internal_tx_diagnosis_name_id');
        $this->manipulator->join('left', 'internal_tx_diagnosis_groups groups');
        $this->manipulator->using('internal_tx_diagnosis_group_id');

        $this->manipulator->where(array(
            'names.diagnosis_name' => $name, 
        ));

        $this->manipulator->orderBy(array(
            'internal_tx_diagnosis_name_id' => 'ASC',
            'orderby' => 'ASC',
        ));

        return $this->manipulator->fetchAll();
    }

    // {{{ Get recipe parsing alias
    private $level = FALSE;
    public function setLevel($level)
    {
        $this->level = $level;
    }

    public function getRecipe($diag_id = '', $name = '')
    {
        if (! empty($name)) {
            $res = $this->getItemsByName($name);
            $this->_setDoneAlias($name);
            $this->done_cnt++;
        } else {
            $res = $this->getItems(array($diag_id));
            $this->done_cnt = 0;
            $this->_setDoneAlias($res[0]['diagnosis_name'], TRUE);
        }
        return $this->_parseRecipeList($res);
    }

    private $done_alias = array();
    private $done_cnt = 0;

    private function _setDoneAlias($name, $init = FALSE)
    {
        if ($init !== FALSE) {
            $this->done_alias = array($name);
        } elseif (! in_array($name, $this->done_alias)) {
            $this->done_alias[] = $name;
        }
    }

    private function _isDoneAlias($name)
    {
        return in_array($name, $this->done_alias);
    }

    private function _parseRecipeList($list)
    {
        $len = count($list);
        $result = array();
        for ($key = 0; $key < $len; $key++) {
            $val = $list[$key];
            $name = $this->getRecipeName($val);
            if ($name === FALSE) {
                // Nothing to do(= skipping), when no data(recipe name) for level.
            } elseif (strpos($name, '＊') === 0 && $this->done_cnt < 10) {
                $name = substr($name, 3);
                if ($this->_isDoneAlias($name)) {
                    unset($list[$key]);
                } else {
                    // Alias
                    $tmp = $this->getRecipe('', $name);
                    if (! empty($tmp)) {
                        // recipe exists for alias diagnosis_name
                        unset($list[$key]);
                        $result = array_merge($result, $this->_parseRecipeList($tmp));
                    } else {
                        // no recipe, means only alias diagnosis_name
                        $result[] = $val;
                    }
                }
            } else {
                $result[] = $val;
            }
        }
        return $result;
    }

    public function getRecipeName($data)
    {
        if ($this->level !== FALSE) {
            $col = 'level' . (int)$this->level;
            return (isset($data[$col]) ? $data[$col] : FALSE);
        } else {
            switch (TRUE) {
                case (! empty($data['level1'])) :
                    $col = 'level1';
                    break;
                case (! empty($data['level2'])) :
                    $col = 'level2';
                    break;
                case (! empty($data['level3'])) :
                    $col = 'level3';
                    break;
                case (! empty($data['level4'])) :
                    $col = 'level4';
                    break;
                default :
                    $col = 'level4';
            }
            return $data[$col];
        }
    }
    // }}}

} //-- End of class


